//>>built
require({cache:{"dojox/charting/Chart":function(){define(["../main","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-style","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/sniff","./Element","./SimpleTheme","./Series","./axis2d/common","./plot2d/common","dojox/gfx/shape","dojox/gfx","dojo/has!dojo-bidi?./bidi/Chart","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e,_f,_10,g,_11,_12){var dc=_2.getObject("charting",true,_1),_13={l:10,t:10,r:10,b:10};function _14(_15){return _15.clear();};function _16(_17){return _17.destroy();};function _18(_19){_19.dirty=false;return false;};function _1a(_1b){_1b.dirty=true;return true;};function _1c(_1d){return _1d.name;};var _1e=_4(_a("dojo-bidi")?"dojox.charting.NonBidiChart":"dojox.charting.Chart",null,{constructor:function(_1f,_20){if(!_20){_20={};}this.margins=_20.margins||_13;this._customMargins=!!_20.margins;this.stroke=_20.stroke;this.fill=_20.fill;this.delayInMs=_20.delayInMs||200;this.title=_20.title;this.titleGap=_20.titleGap;this.titlePos=_20.titlePos;this.titleFont=_20.titleFont;this.titleFontColor=_20.titleFontColor;this.titleAlign=_20.titleAlign;this.chartTitle=null;this.htmlLabels=true;if("htmlLabels" in _20){this.htmlLabels=_20.htmlLabels;}this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.node=_6.byId(_1f);var box=_7.getMarginBox(_1f);this.surface=g.createSurface(this.node,box.w||400,box.h||300);if(this.surface.declaredClass.indexOf("vml")==-1){this._nativeClip=true;}},destroy:function(){_3.forEach(this.series,_16);_3.forEach(this.stack,_16);_12.forIn(this.axes,_16);this.surface.destroy();if(this.chartTitle&&this.chartTitle.tagName){_8.destroy(this.chartTitle);}},getCoords:function(){var _21=this.node;var s=_5.getComputedStyle(_21),_22=_7.getMarginBox(_21,s);var abs=_7.position(_21,true);_22.x=abs.x;_22.y=abs.y;return _22;},setTheme:function(_23){this.theme=_23.clone();if(!this._customMargins){this.margins=this.theme.chart.margins||_13;}this.dirty=true;return this;},addAxis:function(_24,_25){var _26,_27=_25&&_25.type||"Default";if(typeof _27=="string"){if(!dc.axis2d||!dc.axis2d[_27]){throw Error("Can't find axis: "+_27+" - Check "+"require() dependencies.");}_26=new dc.axis2d[_27](this,_25);}else{_26=new _27(this,_25);}_26.name=_24;_26.dirty=true;if(_24 in this.axes){this.axes[_24].destroy();}this.axes[_24]=_26;this.dirty=true;return this;},getAxis:function(_28){return this.axes[_28];},removeAxis:function(_29){if(_29 in this.axes){this.axes[_29].destroy();delete this.axes[_29];this.dirty=true;}return this;},addPlot:function(_2a,_2b){var _2c,_2d=_2b&&_2b.type||"Default";if(typeof _2d=="string"){if(!dc.plot2d||!dc.plot2d[_2d]){throw Error("Can't find plot: "+_2d+" - didn't you forget to dojo"+".require() it?");}_2c=new dc.plot2d[_2d](this,_2b);}else{_2c=new _2d(this,_2b);}_2c.name=_2a;_2c.dirty=true;if(_2a in this.plots){this.stack[this.plots[_2a]].destroy();this.stack[this.plots[_2a]]=_2c;}else{this.plots[_2a]=this.stack.length;this.stack.push(_2c);}this.dirty=true;return this;},getPlot:function(_2e){return this.stack[this.plots[_2e]];},removePlot:function(_2f){if(_2f in this.plots){var _30=this.plots[_2f];delete this.plots[_2f];this.stack[_30].destroy();this.stack.splice(_30,1);_12.forIn(this.plots,function(idx,_31,_32){if(idx>_30){_32[_31]=idx-1;}});var ns=_3.filter(this.series,function(run){return run.plot!=_2f;});if(ns.length<this.series.length){_3.forEach(this.series,function(run){if(run.plot==_2f){run.destroy();}});this.runs={};_3.forEach(ns,function(run,_33){this.runs[run.plot]=_33;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return _12.map(this.stack,_1c);},setPlotOrder:function(_34){var _35={},_36=_12.filter(_34,function(_37){if(!(_37 in this.plots)||(_37 in _35)){return false;}_35[_37]=1;return true;},this);if(_36.length<this.stack.length){_12.forEach(this.stack,function(_38){var _39=_38.name;if(!(_39 in _35)){_36.push(_39);}});}var _3a=_12.map(_36,function(_3b){return this.stack[this.plots[_3b]];},this);_12.forEach(_3a,function(_3c,i){this.plots[_3c.name]=i;},this);this.stack=_3a;this.dirty=true;return this;},movePlotToFront:function(_3d){if(_3d in this.plots){var _3e=this.plots[_3d];if(_3e){var _3f=this.getPlotOrder();_3f.splice(_3e,1);_3f.unshift(_3d);return this.setPlotOrder(_3f);}}return this;},movePlotToBack:function(_40){if(_40 in this.plots){var _41=this.plots[_40];if(_41<this.stack.length-1){var _42=this.getPlotOrder();_42.splice(_41,1);_42.push(_40);return this.setPlotOrder(_42);}}return this;},addSeries:function(_43,_44,_45){var run=new _d(this,_44,_45);run.name=_43;if(_43 in this.runs){this.series[this.runs[_43]].destroy();this.series[this.runs[_43]]=run;}else{this.runs[_43]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(_46){return this.series[this.runs[_46]];},removeSeries:function(_47){if(_47 in this.runs){var _48=this.runs[_47];delete this.runs[_47];this.series[_48].destroy();this.series.splice(_48,1);_12.forIn(this.runs,function(idx,_49,_4a){if(idx>_48){_4a[_49]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(_4b,_4c,_4d){if(_4b in this.runs){var run=this.series[this.runs[_4b]];run.update(_4c);if(_4d){this.dirty=true;}else{this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}}return this;},getSeriesOrder:function(_4e){return _12.map(_12.filter(this.series,function(run){return run.plot==_4e;}),_1c);},setSeriesOrder:function(_4f){var _50,_51={},_52=_12.filter(_4f,function(_53){if(!(_53 in this.runs)||(_53 in _51)){return false;}var run=this.series[this.runs[_53]];if(_50){if(run.plot!=_50){return false;}}else{_50=run.plot;}_51[_53]=1;return true;},this);_12.forEach(this.series,function(run){var _54=run.name;if(!(_54 in _51)&&run.plot==_50){_52.push(_54);}});var _55=_12.map(_52,function(_56){return this.series[this.runs[_56]];},this);this.series=_55.concat(_12.filter(this.series,function(run){return run.plot!=_50;}));_12.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(_57){if(_57 in this.runs){var _58=this.runs[_57],_59=this.getSeriesOrder(this.series[_58].plot);if(_57!=_59[0]){_59.splice(_58,1);_59.unshift(_57);return this.setSeriesOrder(_59);}}return this;},moveSeriesToBack:function(_5a){if(_5a in this.runs){var _5b=this.runs[_5a],_5c=this.getSeriesOrder(this.series[_5b].plot);if(_5a!=_5c[_5c.length-1]){_5c.splice(_5b,1);_5c.push(_5a);return this.setSeriesOrder(_5c);}}return this;},resize:function(_5d,_5e){switch(arguments.length){case 1:_7.setMarginBox(this.node,_5d);break;case 2:_7.setMarginBox(this.node,{w:_5d,h:_5e});break;}var box=_7.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;return this.render();}else{return this;}},getGeometry:function(){var ret={};_12.forIn(this.axes,function(_5f){if(_5f.initialized()){ret[_5f.name]={name:_5f.name,vertical:_5f.vertical,scaler:_5f.scaler,ticks:_5f.ticks};}});return ret;},setAxisWindow:function(_60,_61,_62,_63){var _64=this.axes[_60];if(_64){_64.setWindow(_61,_62);_3.forEach(this.stack,function(_65){if(_65.hAxis==_60||_65.vAxis==_60){_65.zoom=_63;}});}return this;},setWindow:function(sx,sy,dx,dy,_66){if(!("plotArea" in this)){this.calculateGeometry();}_12.forIn(this.axes,function(_67){var _68,_69,_6a=_67.getScaler().bounds,s=_6a.span/(_6a.upper-_6a.lower);if(_67.vertical){_68=sy;_69=dy/s/_68;}else{_68=sx;_69=dx/s/_68;}_67.setWindow(_68,_69);});_3.forEach(this.stack,function(_6b){_6b.zoom=_66;});return this;},zoomIn:function(_6c,_6d,_6e){var _6f=this.axes[_6c];if(_6f){var _70,_71,_72=_6f.getScaler().bounds;var _73=Math.min(_6d[0],_6d[1]);var _74=Math.max(_6d[0],_6d[1]);_73=_6d[0]<_72.lower?_72.lower:_73;_74=_6d[1]>_72.upper?_72.upper:_74;_70=(_72.upper-_72.lower)/(_74-_73);_71=_73-_72.lower;this.setAxisWindow(_6c,_70,_71);if(_6e){this.delayedRender();}else{this.render();}}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _75=_3.filter(this.stack,function(_76){return _76.dirty||(_76.hAxis&&this.axes[_76.hAxis].dirty)||(_76.vAxis&&this.axes[_76.vAxis].dirty);},this);_77(_75,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();_3.forEach(this.stack,_14);if(!this.theme){this.setTheme(new _c());}_3.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var _78=new dc.plot2d.Default(this,{});_78.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(_78);}this.stack[this.plots[run.plot]].addSeries(run);},this);_3.forEach(this.stack,function(_79){if(_79.assignAxes){_79.assignAxes(this.axes);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);_12.forIn(this.axes,_14);_77(this.stack,dim);var _7a=this.offsets={l:0,r:0,t:0,b:0};var _7b=this;_12.forIn(this.axes,function(_7c){if(_a("dojo-bidi")){_7b._resetLeftBottom(_7c);}_12.forIn(_7c.getOffsets(),function(o,i){_7a[i]=Math.max(o,_7a[i]);});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";this.titleAlign=this.titleAlign||this.theme&&this.theme.chart&&this.theme.chart.titleAlign||"middle";var _7d=g.normalizedLength(g.splitFontString(this.titleFont).size);_7a[this.titlePos=="top"?"t":"b"]+=(_7d+this.titleGap);}_12.forIn(this.margins,function(o,i){_7a[i]+=o;});this.plotArea={width:dim.width-_7a.l-_7a.r,height:dim.height-_7a.t-_7a.b};_12.forIn(this.axes,_14);_77(this.stack,this.plotArea);return this;},render:function(){if(this._delayedRenderHandle){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;}if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();_12.forEachRev(this.stack,function(_7e){_7e.render(this.dim,this.offsets);},this);_12.forIn(this.axes,function(_7f){_7f.render(this.dim,this.offsets);},this);this._makeClean();return this;},fullRender:function(){this.fullGeometry();var _80=this.offsets,dim=this.dim;var w=Math.max(0,dim.width-_80.l-_80.r),h=Math.max(0,dim.height-_80.t-_80.b);_3.forEach(this.series,_f.purgeGroup);_12.forIn(this.axes,_f.purgeGroup);_3.forEach(this.stack,_f.purgeGroup);var _81=this.surface.children;if(_10.dispose){for(var i=0;i<_81.length;++i){_10.dispose(_81[i]);}}if(this.chartTitle&&this.chartTitle.tagName){_8.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;this._renderChartBackground(dim,_80);if(this._nativeClip){this._renderPlotBackground(dim,_80,w,h);}else{this._renderPlotBackground(dim,_80,w,h);}_12.foldr(this.stack,function(z,_82){return _82.render(dim,_80),0;},0);if(!this._nativeClip){this._renderChartBackground(dim,_80);}if(this.title){this._renderTitle(dim,_80);}_12.forIn(this.axes,function(_83){_83.render(dim,_80);});this._makeClean();return this;},_renderTitle:function(dim,_84){var _85=(g.renderer=="canvas")&&this.htmlLabels,_86=_85||!_a("ie")&&!_a("opera")&&this.htmlLabels?"html":"gfx",_87=g.normalizedLength(g.splitFontString(this.titleFont).size),_88=g._base._getTextBox(this.title,{font:this.titleFont});var _89=this.titleAlign;var _8a=_a("dojo-bidi")&&this.isRightToLeft();var _8b=dim.width/2;if(_89==="edge"){_89="left";if(_8a){_8b=dim.width-(_84.r+_88.w);}else{_8b=_84.l;}}else{if(_89!="middle"){if(_8a){_89=_89==="left"?"right":"left";}if(_89==="left"){_8b=this.margins.l;}else{if(_89==="right"){_89="left";_8b=dim.width-(this.margins.l+_88.w);}}}}this.chartTitle=_e.createText[_86](this,this.surface,_8b,this.titlePos=="top"?_87+this.margins.t:dim.height-this.margins.b,_89,this.title,this.titleFont,this.titleFontColor);},_renderChartBackground:function(dim,_8c){var t=this.theme,_8d;var _8e=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);var _8f=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(_8e=="inherit"){var _90=this.node;_8e=new _9(_5.get(_90,"backgroundColor"));while(_8e.a==0&&_90!=document.documentElement){_8e=new _9(_5.get(_90,"backgroundColor"));_90=_90.parentNode;}}if(_8e){if(this._nativeClip){_8e=_b.prototype._shapeFill(_b.prototype._plotFill(_8e,dim),{x:0,y:0,width:dim.width+1,height:dim.height+1});this.surface.createRect({width:dim.width+1,height:dim.height+1}).setFill(_8e);}else{_8e=_b.prototype._plotFill(_8e,dim,_8c);if(_8c.l){_8d={x:0,y:0,width:_8c.l,height:dim.height+1};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.r){_8d={x:dim.width-_8c.r,y:0,width:_8c.r+1,height:dim.height+2};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.t){_8d={x:0,y:0,width:dim.width+1,height:_8c.t};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.b){_8d={x:0,y:dim.height-_8c.b,width:dim.width+1,height:_8c.b+2};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}}}if(_8f){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_8f);}},_renderPlotBackground:function(dim,_91,w,h){var t=this.theme;var _92=t.plotarea&&t.plotarea.fill;var _93=t.plotarea&&t.plotarea.stroke;var _94={x:_91.l-1,y:_91.t-1,width:w+2,height:h+2};if(_92){_92=_b.prototype._shapeFill(_b.prototype._plotFill(_92,dim,_91),_94);this.surface.createRect(_94).setFill(_92);}if(_93){this.surface.createRect({x:_91.l,y:_91.t,width:w+1,height:h+1}).setStroke(_93);}},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(_2.hitch(this,function(){this.render();}),this.delayInMs);}return this;},connectToPlot:function(_95,_96,_97){return _95 in this.plots?this.stack[this.plots[_95]].connect(_96,_97):null;},fireEvent:function(_98,_99,_9a){if(_98 in this.runs){var _9b=this.series[this.runs[_98]].plot;if(_9b in this.plots){var _9c=this.stack[this.plots[_9b]];if(_9c){_9c.fireEvent(_98,_99,_9a);}}}return this;},_makeClean:function(){_3.forEach(this.axes,_18);_3.forEach(this.stack,_18);_3.forEach(this.series,_18);this.dirty=false;},_makeDirty:function(){_3.forEach(this.axes,_1a);_3.forEach(this.stack,_1a);_3.forEach(this.series,_1a);this.dirty=true;},_invalidateDependentPlots:function(_9d,_9e){if(_9d in this.plots){var _9f=this.stack[this.plots[_9d]],_a0,_a1=_9e?"vAxis":"hAxis";if(_9f[_a1]){_a0=this.axes[_9f[_a1]];if(_a0&&_a0.dependOnData()){_a0.dirty=true;_3.forEach(this.stack,function(p){if(p[_a1]&&p[_a1]==_9f[_a1]){p.dirty=true;}});}}else{_9f.dirty=true;}}},setDir:function(dir){return this;},_resetLeftBottom:function(_a2){},formatTruncatedLabel:function(_a3,_a4,_a5){}});function _a6(_a7){return {min:_a7.hmin,max:_a7.hmax};};function _a8(_a9){return {min:_a9.vmin,max:_a9.vmax};};function _aa(_ab,h){_ab.hmin=h.min;_ab.hmax=h.max;};function _ac(_ad,v){_ad.vmin=v.min;_ad.vmax=v.max;};function _ae(_af,_b0){if(_af&&_b0){_af.min=Math.min(_af.min,_b0.min);_af.max=Math.max(_af.max,_b0.max);}return _af||_b0;};function _77(_b1,_b2){var _b3={},_b4={};_3.forEach(_b1,function(_b5){var _b6=_b3[_b5.name]=_b5.getSeriesStats();if(_b5.hAxis){_b4[_b5.hAxis]=_ae(_b4[_b5.hAxis],_a6(_b6));}if(_b5.vAxis){_b4[_b5.vAxis]=_ae(_b4[_b5.vAxis],_a8(_b6));}});_3.forEach(_b1,function(_b7){var _b8=_b3[_b7.name];if(_b7.hAxis){_aa(_b8,_b4[_b7.hAxis]);}if(_b7.vAxis){_ac(_b8,_b4[_b7.vAxis]);}_b7.initializeScalers(_b2,_b8);});};return _a("dojo-bidi")?_4("dojox.charting.Chart",[_1e,_11]):_1e;});},"dojox/main":function(){define(["dojo/_base/kernel"],function(_b9){return _b9.dojox;});},"dojox/charting/Element":function(){define(["dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx","dojox/gfx/shape"],function(arr,_ba,_bb,gfx,_bc){return _bb("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,renderingOptions:null,constructor:function(_bd,_be){this.chart=_bd;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];if(_be&&_be.renderingOptions){this.renderingOptions=_be.renderingOptions;}},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.getGroup().removeShape();var _bf=this.getGroup().children;if(_bc.dispose){for(var i=0;i<_bf.length;++i){_bc.dispose(_bf[i],true);}}if(this.getGroup().rawNode){_ba.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_bc.dispose){_bc.dispose(this.getGroup(),true);}if(this.getGroup()!=this.group){if(this.group.rawNode){_ba.empty(this.group.rawNode);}this.group.clear();if(_bc.dispose){_bc.dispose(this.group,true);}}this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(_c0){_c0.shape.disconnect(_c0.handle);});this._events=[];}return this;},cleanGroup:function(_c1){this.destroyHtmlElements();if(!_c1){_c1=this.chart.surface;}if(this.group){var _c2;var _c3=this.getGroup().children;if(_bc.dispose){for(var i=0;i<_c3.length;++i){_bc.dispose(_c3[i],true);}}if(this.getGroup().rawNode){_c2=this.getGroup().bgNode;_ba.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_c2){this.getGroup().rawNode.appendChild(_c2);}}else{this.group=_c1.createGroup();if(this.renderingOptions&&this.group.rawNode&&this.group.rawNode.namespaceURI=="http://www.w3.org/2000/svg"){for(var key in this.renderingOptions){this.group.rawNode.setAttribute(key,this.renderingOptions[key]);}}}this.dirty=true;return this;},getGroup:function(){return this.group;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_ba.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},overrideShape:function(_c4,_c5){},getTextWidth:function(s,_c6){return gfx._base._getTextBox(s,{font:_c6}).w||0;},getTextWithLimitLength:function(s,_c7,_c8,_c9){if(!s||s.length<=0){return {text:"",truncated:_c9||false};}if(!_c8||_c8<=0){return {text:s,truncated:_c9||false};}var _ca=2,_cb=0.618,_cc=s.substring(0,1)+this.trailingSymbol,_cd=this.getTextWidth(_cc,_c7);if(_c8<=_cd){return {text:_cc,truncated:true};}var _ce=this.getTextWidth(s,_c7);if(_ce<=_c8){return {text:s,truncated:_c9||false};}else{var _cf=0,end=s.length;while(_cf<end){if(end-_cf<=_ca){while(this.getTextWidth(s.substring(0,_cf)+this.trailingSymbol,_c7)>_c8){_cf-=1;}return {text:(s.substring(0,_cf)+this.trailingSymbol),truncated:true};}var _d0=_cf+Math.round((end-_cf)*_cb),_d1=this.getTextWidth(s.substring(0,_d0),_c7);if(_d1<_c8){_cf=_d0;end=end;}else{_cf=_cf;end=_d0;}}}},getTextWithLimitCharCount:function(s,_d2,_d3,_d4){if(!s||s.length<=0){return {text:"",truncated:_d4||false};}if(!_d3||_d3<=0||s.length<=_d3){return {text:s,truncated:_d4||false};}return {text:s.substring(0,_d3)+this.trailingSymbol,truncated:true};},_plotFill:function(_d5,dim,_d6){if(!_d5||!_d5.type||!_d5.space){return _d5;}var _d7=_d5.space,_d8;switch(_d5.type){case "linear":if(_d7==="plot"||_d7==="shapeX"||_d7==="shapeY"){_d5=gfx.makeParameters(gfx.defaultLinearGradient,_d5);_d5.space=_d7;if(_d7==="plot"||_d7==="shapeX"){_d8=dim.height-_d6.t-_d6.b;_d5.y1=_d6.t+_d8*_d5.y1/100;_d5.y2=_d6.t+_d8*_d5.y2/100;}if(_d7==="plot"||_d7==="shapeY"){_d8=dim.width-_d6.l-_d6.r;_d5.x1=_d6.l+_d8*_d5.x1/100;_d5.x2=_d6.l+_d8*_d5.x2/100;}}break;case "radial":if(_d7==="plot"){_d5=gfx.makeParameters(gfx.defaultRadialGradient,_d5);_d5.space=_d7;var _d9=dim.width-_d6.l-_d6.r,_da=dim.height-_d6.t-_d6.b;_d5.cx=_d6.l+_d9*_d5.cx/100;_d5.cy=_d6.t+_da*_d5.cy/100;_d5.r=_d5.r*Math.sqrt(_d9*_d9+_da*_da)/200;}break;case "pattern":if(_d7==="plot"||_d7==="shapeX"||_d7==="shapeY"){_d5=gfx.makeParameters(gfx.defaultPattern,_d5);_d5.space=_d7;if(_d7==="plot"||_d7==="shapeX"){_d8=dim.height-_d6.t-_d6.b;_d5.y=_d6.t+_d8*_d5.y/100;_d5.height=_d8*_d5.height/100;}if(_d7==="plot"||_d7==="shapeY"){_d8=dim.width-_d6.l-_d6.r;_d5.x=_d6.l+_d8*_d5.x/100;_d5.width=_d8*_d5.width/100;}}break;}return _d5;},_shapeFill:function(_db,_dc){if(!_db||!_db.space){return _db;}var _dd=_db.space,_de;switch(_db.type){case "linear":if(_dd==="shape"||_dd==="shapeX"||_dd==="shapeY"){_db=gfx.makeParameters(gfx.defaultLinearGradient,_db);_db.space=_dd;if(_dd==="shape"||_dd==="shapeX"){_de=_dc.width;_db.x1=_dc.x+_de*_db.x1/100;_db.x2=_dc.x+_de*_db.x2/100;}if(_dd==="shape"||_dd==="shapeY"){_de=_dc.height;_db.y1=_dc.y+_de*_db.y1/100;_db.y2=_dc.y+_de*_db.y2/100;}}break;case "radial":if(_dd==="shape"){_db=gfx.makeParameters(gfx.defaultRadialGradient,_db);_db.space=_dd;_db.cx=_dc.x+_dc.width/2;_db.cy=_dc.y+_dc.height/2;_db.r=_db.r*_dc.width/200;}break;case "pattern":if(_dd==="shape"||_dd==="shapeX"||_dd==="shapeY"){_db=gfx.makeParameters(gfx.defaultPattern,_db);_db.space=_dd;if(_dd==="shape"||_dd==="shapeX"){_de=_dc.width;_db.x=_dc.x+_de*_db.x/100;_db.width=_de*_db.width/100;}if(_dd==="shape"||_dd==="shapeY"){_de=_dc.height;_db.y=_dc.y+_de*_db.y/100;_db.height=_de*_db.height/100;}}break;}return _db;},_pseudoRadialFill:function(_df,_e0,_e1,_e2,end){if(!_df||_df.type!=="radial"||_df.space!=="shape"){return _df;}var _e3=_df.space;_df=gfx.makeParameters(gfx.defaultRadialGradient,_df);_df.space=_e3;if(arguments.length<4){_df.cx=_e0.x;_df.cy=_e0.y;_df.r=_df.r*_e1/100;return _df;}var _e4=arguments.length<5?_e2:(end+_e2)/2;return {type:"linear",x1:_e0.x,y1:_e0.y,x2:_e0.x+_df.r*_e1*Math.cos(_e4)/100,y2:_e0.y+_df.r*_e1*Math.sin(_e4)/100,colors:_df.colors};}});});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(_e5,_e6,_e7){_e6.switchTo(_e7);return _e6;});},"dojox/gfx/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_e8,_e9,_ea,has,win,arr,dom,_eb,_ec){var g=_e9.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(_ed,_ee){var cls=_ed.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_ee+" ")>=0;};g._addClass=function(_ef,_f0){var cls=_ef.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_f0+" ")<0){_ef.setAttribute("className",cls+(cls?" ":"")+_f0);}};g._removeClass=function(_f1,_f2){var cls=_f1.getAttribute("className");if(cls){_f1.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_f2+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _f3={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p,_f4;if(has("ie")){_f4=win.doc.documentElement.style.fontSize||"";if(!_f4){win.doc.documentElement.style.fontSize="100%";}}var div=_eb.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _f3){div.style.fontSize=p;_f3[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}if(has("ie")){win.doc.documentElement.style.fontSize=_f4;}win.body().removeChild(div);return _f3;};var _f5=null;b._getCachedFontMeasurements=function(_f6){if(_f6||!_f5){_f5=b._getFontMeasurements();}return _f5;};var _f7=null,_f8={};b._getTextBox=function(_f9,_fa,_fb){var m,s,al=arguments.length;var i,box;if(!_f7){_f7=_eb.create("div",{style:{position:"absolute",top:"-10000px",left:"0",visibility:"hidden"}},win.body());}m=_f7;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_fa){for(i in _fa){if(i in _f8){continue;}s[i]=_fa[i];}}if(al>2&&_fb){m.className=_fb;}m.innerHTML=_f9;if(m.getBoundingClientRect){var bcr=m.getBoundingClientRect();box={l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{box=_ec.getMarginBox(m);}m.innerHTML="";return box;};b._computeTextLocation=function(_fc,_fd,_fe,_ff){var loc={},_100=_fc.align;switch(_100){case "end":loc.x=_fc.x-_fd;break;case "middle":loc.x=_fc.x-_fd/2;break;default:loc.x=_fc.x;break;}var c=_ff?0.75:1;loc.y=_fc.y-_fe*c;return loc;};b._computeTextBoundingBox=function(s){if(!g._base._isRendered(s)){return {x:0,y:0,width:0,height:0};}var loc,_101=s.getShape(),font=s.getFont()||g.defaultFont,w=s.getTextWidth(),h=g.normalizedLength(font.size);loc=b._computeTextLocation(_101,w,h,true);return {x:loc.x,y:loc.y,width:w,height:h};};b._isRendered=function(s){var p=s.parent;while(p&&p.getParent){p=p.parent;}return p!==null;};var _102=0;b._getUniqueId=function(){var id;do{id=_e8._scopeName+"xUnique"+(++_102);}while(dom.byId(id));return id;};var _103=has("pointer-events")?"touchAction":has("MSPointer")?"msTouchAction":null;b._fixMsTouchAction=_103?function(_104){_104.rawNode.style[_103]="none";}:function(){};_e9.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _105={};return function(type){var t=_105[type];if(t){return new t();}t=_105[type]=function(){};t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_106){return (_106 instanceof _ea)?_106:new _ea(_106);},normalizeParameters:function(_107,_108){var x;if(_108){var _109={};for(x in _107){if(x in _108&&!(x in _109)){_107[x]=_108[x];}}}return _107;},makeParameters:function(_10a,_10b){var i=null;if(!_10b){return _e9.delegate(_10a);}var _10c={};for(i in _10a){if(!(i in _10c)){_10c[i]=_e9.clone((i in _10b)?_10b[i]:_10a[i]);}}return _10c;},formatNumber:function(x,_10d){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _10e=val.indexOf(".");if(_10e>=0&&val.length-_10e>5){val=x.toFixed(4);}}if(x<0){return val;}return _10d?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _10f=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_10f;case "in":return val*72*_10f;case "pc":return val*12*_10f;case "mm":return val*g.mm_in_pt*_10f;case "cm":return val*g.cm_in_pt*_10f;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-DF-Za-df-z])|([-+]?\d*[.]?\d+(?:[eE][-+]?\d+)?)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_110){var ns=typeof _110=="string"?g[_110]:_110;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});if(typeof _110=="string"){g.renderer=_110;}else{arr.some(["svg","vml","canvas","canvasWithEvents","silverlight"],function(r){return (g.renderer=g[r]&&g[r].Surface===g.Surface?r:null);});}}}});return g;});},"dojox/gfx/renderer":function(){define(["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_111){var _112=null;has.add("vml",function(_113,_114,_115){_115.innerHTML="<v:shape adj=\"1\"/>";var _116=("adj" in _115.firstChild);_115.innerHTML="";return _116;});return {load:function(id,_117,load){if(_112&&id!="force"){load(_112);return;}var _118=_111.forceGfxRenderer,_119=!_118&&(lang.isString(_111.gfxRenderer)?_111.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_11a,_11b;while(!_118&&_119.length){switch(_119.shift()){case "svg":if("SVGAngle" in win.global){_118="svg";}break;case "vml":if(has("vml")){_118="vml";}break;case "silverlight":try{if(has("ie")){_11a=new ActiveXObject("AgControl.AgControl");if(_11a&&_11a.IsVersionSupported("1.0")){_11b=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_11b=true;}}}catch(e){_11b=false;}finally{_11a=null;}if(_11b){_118="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_118="canvas";}break;}}if(_118==="canvas"&&_111.canvasEvents!==false){_118="canvasWithEvents";}if(_111.isDebug){}function _11c(){_117(["dojox/gfx/"+_118],function(_11d){g.renderer=_118;_112=_11d;load(_11d);});};if(_118=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_11c);}else{_11c();}}};});},"dojox/gfx/shape":function(){define(["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/on","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,lang,_11e,_11f,has,on,arr,_120,_121,_122){function _123(a,_124){var len=(a.length-1);while(_124<len){a[_124]=a[++_124];}a.length=len;};var _125=g.shape={};_125.Shape=_11e("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;if(has("gfxRegistry")){var uid=_125.register(this);this.getUID=function(){return uid;};}},destroy:function(){if(has("gfxRegistry")){_125.dispose(this);}if(this.rawNode&&"__gfxObject__" in this.rawNode){this.rawNode.__gfxObject__=null;}this.rawNode=null;},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_122;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(clip){this.clip=clip;},getClip:function(){return this.clip;},setShape:function(_126){this.shape=g.makeParameters(this.shape,_126);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}var f=null;if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);break;}}else{f=g.normalizeColor(fill);}this.fillStyle=f;return this;},setStroke:function(_127){if(!_127){this.strokeStyle=null;return this;}if(typeof _127=="string"||lang.isArray(_127)||_127 instanceof _121){_127={color:_127};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_127);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_128){this.matrix=_122.clone(_128?_122.normalize(_128):_122.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_129){return _129?this.setTransform([this.matrix,_129]):this;},applyLeftTransform:function(_12a){return _12a?this.setTransform([_12a,this.matrix]):this;},applyTransform:function(_12b){return _12b?this.setTransform([this.matrix,_12b]):this;},removeShape:function(_12c){if(this.parent){this.parent.remove(this,_12c);}return this;},_setParent:function(_12d,_12e){this.parent=_12d;return this._updateParentMatrix(_12e);},_updateParentMatrix:function(_12f){this.parentMatrix=_12f?_122.clone(_12f):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_122.multiply(p.matrix,m);}p=p.parent;}return m;}});_125._eventsProcessing={on:function(type,_130){return on(this.getEventSource(),type,_125.fixCallback(this,g.fixTarget,_130));},connect:function(name,_131,_132){if(name.substring(0,2)=="on"){name=name.substring(2);}return this.on(name,_132?lang.hitch(_131,_132):_131);},disconnect:function(_133){return _133.remove();}};_125.fixCallback=function(_134,_135,_136,_137){if(!_137){_137=_136;_136=null;}if(lang.isString(_137)){_136=_136||_11f.global;if(!_136[_137]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_137,"\"] is null (scope=\"",_136,"\")"].join(""));}return function(e){return _135(e,_134)?_136[_137].apply(_136,arguments||[]):undefined;};}return !_136?function(e){return _135(e,_134)?_137.apply(_136,arguments):undefined;}:function(e){return _135(e,_134)?_137.apply(_136,arguments||[]):undefined;};};lang.extend(_125.Shape,_125._eventsProcessing);_125.Container={_init:function(){this.children=[];this._batch=0;},openBatch:function(){return this;},closeBatch:function(){return this;},add:function(_138){var _139=_138.getParent();if(_139){_139.remove(_138,true);}this.children.push(_138);return _138._setParent(this,this._getRealMatrix());},remove:function(_13a,_13b){for(var i=0;i<this.children.length;++i){if(this.children[i]==_13a){if(_13b){}else{_13a.parent=null;_13a.parentMatrix=null;}_123(this.children,i);break;}}return this;},clear:function(_13c){var _13d;for(var i=0;i<this.children.length;++i){_13d=this.children[i];_13d.parent=null;_13d.parentMatrix=null;if(_13c){_13d.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _13e=null;arr.forEach(this.children,function(_13f){var bb=_13f.getBoundingBox();if(bb){var ct=_13f.getTransform();if(ct){bb=_122.multiplyRectangle(ct,bb);}if(_13e){_13e.x=Math.min(_13e.x,bb.x);_13e.y=Math.min(_13e.y,bb.y);_13e.endX=Math.max(_13e.endX,bb.x+bb.width);_13e.endY=Math.max(_13e.endY,bb.y+bb.height);}else{_13e={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_13e){_13e.width=_13e.endX-_13e.x;_13e.height=_13e.endY-_13e.y;}return _13e;}return null;},_moveChildToFront:function(_140){for(var i=0;i<this.children.length;++i){if(this.children[i]==_140){_123(this.children,i);this.children.push(_140);break;}}return this;},_moveChildToBack:function(_141){for(var i=0;i<this.children.length;++i){if(this.children[i]==_141){_123(this.children,i);this.children.unshift(_141);break;}}return this;}};_125.Surface=_11e("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_120.destroy);this._nodes=[];arr.forEach(this._events,function(h){if(h){h.remove();}});this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_120.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_142){},whenLoaded:function(_143,_144){var f=lang.hitch(_143,_144);if(this.isLoaded){f(this);}else{on.once(this,"load",function(_145){f(_145);});}}});lang.extend(_125.Surface,_125._eventsProcessing);_125.Rect=_11e("dojox.gfx.shape.Rect",_125.Shape,{constructor:function(_146){this.shape=g.getDefault("Rect");this.rawNode=_146;},getBoundingBox:function(){return this.shape;}});_125.Ellipse=_11e("dojox.gfx.shape.Ellipse",_125.Shape,{constructor:function(_147){this.shape=g.getDefault("Ellipse");this.rawNode=_147;},getBoundingBox:function(){if(!this.bbox){var _148=this.shape;this.bbox={x:_148.cx-_148.rx,y:_148.cy-_148.ry,width:2*_148.rx,height:2*_148.ry};}return this.bbox;}});_125.Circle=_11e("dojox.gfx.shape.Circle",_125.Shape,{constructor:function(_149){this.shape=g.getDefault("Circle");this.rawNode=_149;},getBoundingBox:function(){if(!this.bbox){var _14a=this.shape;this.bbox={x:_14a.cx-_14a.r,y:_14a.cy-_14a.r,width:2*_14a.r,height:2*_14a.r};}return this.bbox;}});_125.Line=_11e("dojox.gfx.shape.Line",_125.Shape,{constructor:function(_14b){this.shape=g.getDefault("Line");this.rawNode=_14b;},getBoundingBox:function(){if(!this.bbox){var _14c=this.shape;this.bbox={x:Math.min(_14c.x1,_14c.x2),y:Math.min(_14c.y1,_14c.y2),width:Math.abs(_14c.x2-_14c.x1),height:Math.abs(_14c.y2-_14c.y1)};}return this.bbox;}});_125.Polyline=_11e("dojox.gfx.shape.Polyline",_125.Shape,{constructor:function(_14d){this.shape=g.getDefault("Polyline");this.rawNode=_14d;},setShape:function(_14e,_14f){if(_14e&&_14e instanceof Array){this.inherited(arguments,[{points:_14e}]);if(_14f&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_14e]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _150=[];for(var i=0;i<l;i+=2){_150.push({x:p[i],y:p[i+1]});}this.shape.points=_150;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_125.Image=_11e("dojox.gfx.shape.Image",_125.Shape,{constructor:function(_151){this.shape=g.getDefault("Image");this.rawNode=_151;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_125.Text=_11e(_125.Shape,{constructor:function(_152){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_152;},getFont:function(){return this.fontStyle;},setFont:function(_153){this.fontStyle=typeof _153=="string"?g.splitFontString(_153):g.makeParameters(g.defaultFont,_153);this._setFont();return this;},getBoundingBox:function(){var bbox=null,s=this.getShape();if(s.text){bbox=g._base._computeTextBoundingBox(this);}return bbox;}});_125.Creator={createShape:function(_154){switch(_154.type){case g.defaultPath.type:return this.createPath(_154);case g.defaultRect.type:return this.createRect(_154);case g.defaultCircle.type:return this.createCircle(_154);case g.defaultEllipse.type:return this.createEllipse(_154);case g.defaultLine.type:return this.createLine(_154);case g.defaultPolyline.type:return this.createPolyline(_154);case g.defaultImage.type:return this.createImage(_154);case g.defaultText.type:return this.createText(_154);case g.defaultTextPath.type:return this.createTextPath(_154);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_155){return this.createObject(g.Ellipse,_155);},createCircle:function(_156){return this.createObject(g.Circle,_156);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_157){return this.createObject(g.Polyline,_157);},createImage:function(_158){return this.createObject(g.Image,_158);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_159,_15a){return null;}};return _125;});},"dojox/gfx/matrix":function(){define(["./_base","dojo/_base/lang"],function(g,lang){var m=g.matrix={};var _15b={};m._degToRad=function(_15c){return _15b[_15c]||(_15b[_15c]=(Math.PI*_15c/180));};m._radToDeg=function(_15d){return _15d/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _15e=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_15e,r=m.normalize(arg[i]);_15e=new m.Matrix2D();_15e.xx=l.xx*r.xx+l.xy*r.yx;_15e.xy=l.xx*r.xy+l.xy*r.yy;_15e.yx=l.yx*r.xx+l.yy*r.yx;_15e.yy=l.yx*r.xy+l.yy*r.yy;_15e.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_15e.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}lang.mixin(this,_15e);}}else{lang.mixin(this,arg);}}}};lang.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});lang.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_15f){var c=Math.cos(_15f);var s=Math.sin(_15f);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_160){return m.rotate(m._degToRad(_160));},skewX:function(_161){return new m.Matrix2D({xy:Math.tan(_161)});},skewXg:function(_162){return m.skewX(m._degToRad(_162));},skewY:function(_163){return new m.Matrix2D({yx:Math.tan(_163)});},skewYg:function(_164){return m.skewY(m._degToRad(_164));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_165){return (_165 instanceof m.Matrix2D)?_165:new m.Matrix2D(_165);},isIdentity:function(_166){return _166.xx==1&&_166.xy==0&&_166.yx==0&&_166.yy==1&&_166.dx==0&&_166.dy==0;},clone:function(_167){var obj=new m.Matrix2D();for(var i in _167){if(typeof (_167[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_167[i]){obj[i]=_167[i];}}return obj;},invert:function(_168){var M=m.normalize(_168),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_169,x,y){return {x:_169.xx*x+_169.xy*y+_169.dx,y:_169.yx*x+_169.yy*y+_169.dy};},multiplyPoint:function(_16a,a,b){var M=m.normalize(_16a);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiplyRectangle:function(_16b,rect){var M=m.normalize(_16b);rect=rect||{x:0,y:0,width:0,height:0};if(m.isIdentity(M)){return {x:rect.x,y:rect.y,width:rect.width,height:rect.height};}var p0=m.multiplyPoint(M,rect.x,rect.y),p1=m.multiplyPoint(M,rect.x,rect.y+rect.height),p2=m.multiplyPoint(M,rect.x+rect.width,rect.y),p3=m.multiplyPoint(M,rect.x+rect.width,rect.y+rect.height),minx=Math.min(p0.x,p1.x,p2.x,p3.x),miny=Math.min(p0.y,p1.y,p2.y,p3.y),maxx=Math.max(p0.x,p1.x,p2.x,p3.x),maxy=Math.max(p0.y,p1.y,p2.y,p3.y);return {x:minx,y:miny,width:maxx-minx,height:maxy-miny};},multiply:function(_16c){var M=m.normalize(_16c);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_16d,x,y){return m.multiply(m.translate(x,y),_16d,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_16e,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_16e),a,b);}return m._sandwich(m.rotate(_16e),a.x,a.y);},rotategAt:function(_16f,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_16f),a,b);}return m._sandwich(m.rotateg(_16f),a.x,a.y);},skewXAt:function(_170,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_170),a,b);}return m._sandwich(m.skewX(_170),a.x,a.y);},skewXgAt:function(_171,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_171),a,b);}return m._sandwich(m.skewXg(_171),a.x,a.y);},skewYAt:function(_172,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_172),a,b);}return m._sandwich(m.skewY(_172),a.x,a.y);},skewYgAt:function(_173,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_173),a,b);}return m._sandwich(m.skewYg(_173),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/charting/SimpleTheme":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_174,_175,dlu,dgg){var _176=_174("dojox.charting.SimpleTheme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_177){_177=_177||{};var def=_176.defaultTheme;arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_177[name]);},this);if(_177.seriesThemes&&_177.seriesThemes.length){this.colors=null;this.seriesThemes=_177.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_177.colors||_176.defaultColors).slice(0);}this.markerThemes=null;if(_177.markerThemes&&_177.markerThemes.length){this.markerThemes=_177.markerThemes.slice(0);}this.markers=_177.markers?lang.clone(_177.markers):lang.delegate(_176.defaultMarkers);this.noGradConv=_177.noGradConv;this.noRadialConv=_177.noRadialConv;if(_177.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _178=new this.constructor({chart:this.chart,plotarea:this.plotarea,axis:this.axis,grid:this.grid,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv,pieInnerRadius:this.pieInnerRadius});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_178[name]=this[name];}},this);return _178;},clear:function(){this._current=0;},next:function(_179,_17a,_17b){var _17c=dlu.merge,_17d,_17e;if(this.colors){_17d=lang.delegate(this.series);_17e=lang.delegate(this.marker);var _17f=new _175(this.colors[this._current%this.colors.length]),old;if(_17d.stroke&&_17d.stroke.color){_17d.stroke=lang.delegate(_17d.stroke);old=new _175(_17d.stroke.color);_17d.stroke.color=new _175(_17f);_17d.stroke.color.a=old.a;}else{_17d.stroke={color:_17f};}if(_17e.stroke&&_17e.stroke.color){_17e.stroke=lang.delegate(_17e.stroke);old=new _175(_17e.stroke.color);_17e.stroke.color=new _175(_17f);_17e.stroke.color.a=old.a;}else{_17e.stroke={color:_17f};}if(!_17d.fill||_17d.fill.type){_17d.fill=_17f;}else{old=new _175(_17d.fill);_17d.fill=new _175(_17f);_17d.fill.a=old.a;}if(!_17e.fill||_17e.fill.type){_17e.fill=_17f;}else{old=new _175(_17e.fill);_17e.fill=new _175(_17f);_17e.fill.a=old.a;}}else{_17d=this.seriesThemes?_17c(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_17e=this.markerThemes?_17c(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_17d;}var _180=_17e&&_17e.symbol||this._markers[this._current%this._markers.length];var _181={series:_17d,marker:_17e,symbol:_180};++this._current;if(_17a){_181=this.addMixin(_181,_179,_17a);}if(_17b){_181=this.post(_181,_179);}return _181;},skip:function(){++this._current;},addMixin:function(_182,_183,_184,_185){if(lang.isArray(_184)){arr.forEach(_184,function(m){_182=this.addMixin(_182,_183,m);},this);}else{var t={};if("color" in _184){if(_183=="line"||_183=="area"){lang.setObject("series.stroke.color",_184.color,t);lang.setObject("marker.stroke.color",_184.color,t);}else{lang.setObject("series.fill",_184.color,t);}}arr.forEach(["stroke","outline","shadow","fill","filter","font","fontColor","labelWiring"],function(name){var _186="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_186 in _184;if(name in _184){lang.setObject("series."+name,_184[name],t);if(!b){lang.setObject("marker."+name,_184[name],t);}}if(b){lang.setObject("marker."+name,_184[_186],t);}});if("marker" in _184){t.symbol=_184.marker;t.symbol=_184.marker;}_182=dlu.merge(_182,t);}if(_185){_182=this.post(_182,_183);}return _182;},post:function(_187,_188){var fill=_187.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_188=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_188=="slice"||_188=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_187,{series:{fill:t}});}}return _187;},getTick:function(name,_189){var tick=this.axis.tick,_18a=name+"Tick",_18b=dlu.merge;if(tick){if(this.axis[_18a]){tick=_18b(tick,this.axis[_18a]);}}else{tick=this.axis[_18a];}if(_189){if(tick){if(_189[_18a]){tick=_18b(tick,_189[_18a]);}}else{tick=_189[_18a];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_18c){this.markers[name]=_18c;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_176,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333",titleAlign:"middle"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",labelGap:4},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1},title:{gap:15,font:"normal normal normal 11pt Tahoma",fontColor:"#333",orientation:"axis"}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,lineFill:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}}});return _176;});},"dojox/lang/utils":function(){define(["..","dojo/_base/lang"],function(_18d,lang){var du=lang.getObject("lang.utils",true,_18d);var _18e={},opts=Object.prototype.toString;var _18f=function(o){if(o){switch(opts.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return lang.delegate(o);}}return o;};lang.mixin(du,{coerceType:function(_190,_191){switch(typeof _190){case "number":return Number(eval("("+_191+")"));case "string":return String(_191);case "boolean":return Boolean(eval("("+_191+")"));}return eval("("+_191+")");},updateWithObject:function(_192,_193,conv){if(!_193){return _192;}for(var x in _192){if(x in _193&&!(x in _18e)){var t=_192[x];if(t&&typeof t=="object"){du.updateWithObject(t,_193[x],conv);}else{_192[x]=conv?du.coerceType(t,_193[x]):_18f(_193[x]);}}}return _192;},updateWithPattern:function(_194,_195,_196,conv){if(!_195||!_196){return _194;}for(var x in _196){if(x in _195&&!(x in _18e)){_194[x]=conv?du.coerceType(_196[x],_195[x]):_18f(_195[x]);}}return _194;},merge:function(_197,_198){if(_198){var _199=opts.call(_197),_19a=opts.call(_198),t,i,l,m;switch(_19a){case "[object Array]":if(_19a==_199){t=new Array(Math.max(_197.length,_198.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_197[i],_198[i]);}return t;}return _198.slice(0);case "[object Object]":if(_19a==_199&&_197){t=lang.delegate(_197);for(i in _198){if(i in _197){l=_197[i];m=_198[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=lang.clone(_198[i]);}}return t;}return lang.clone(_198);}}return _198;}});return du;});},"dojox/gfx/gradutils":function(){define(["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_19b){var _19c=g.gradutils={};function _19d(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _19b.blendColors(new _19b(prev.color),new _19b(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_19c.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _19e=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_19f=m.rotate(-_19e),_1a0=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_1a0,pt),pf1=m.multiplyPoint(_1a0,fill.x1,fill.y1),pf2=m.multiplyPoint(_1a0,fill.x2,fill.y2),_1a1=m.multiplyPoint(_19f,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_19f,p.x-pf1.x,p.y-pf1.y).x/_1a1;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _19d(o,fill.colors);}return new _19b(fill||[0,0,0,0]);};_19c.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _19c;});},"dojox/charting/Series":function(){define(["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_1a2,_1a3){return _1a2("dojox.charting.Series",_1a3,{constructor:function(_1a4,data,_1a5){lang.mixin(this,_1a5);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/axis2d/common":function(){define(["dojo/_base/lang","dojo/_base/window","dojo/dom-geometry","dojox/gfx","dojo/has"],function(lang,win,_1a6,g,has){var _1a7=lang.getObject("dojox.charting.axis2d.common",true);var _1a8=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _1a9=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _1a6.getMarginBox(n).w;}};return lang.mixin(_1a7,{createText:{gfx:function(_1aa,_1ab,x,y,_1ac,text,font,_1ad){return _1ab.createText({x:x,y:y,text:text,align:_1ac}).setFont(font).setFill(_1ad);},html:function(_1ae,_1af,x,y,_1b0,text,font,_1b1,_1b2){var p=win.doc.createElement("div"),s=p.style,_1b3;if(_1ae.getTextDir){p.dir=_1ae.getTextDir(text);}_1a8(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_1b1;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_1b2){_1b3=_1a9(p);}if(p.dir=="rtl"){x+=_1b2?_1b2:_1b3;}win.body().removeChild(p);s.position="relative";if(_1b2){s.width=_1b2+"px";switch(_1b0){case "middle":s.textAlign="center";s.left=(x-_1b2/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_1b2)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_1b0){case "middle":s.left=Math.floor(x-_1b3/2)+"px";break;case "end":s.left=Math.floor(x-_1b3)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_1a8(w);w.width="0px";w.height="0px";wrap.appendChild(p);_1ae.node.insertBefore(wrap,_1ae.node.firstChild);if(has("dojo-bidi")){_1ae.htmlElementsRegistry.push([wrap,x,y,_1b0,text,font,_1b1]);}return wrap;}}});});},"dojox/charting/plot2d/common":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_1b4,g,df,sc){var _1b5=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_1b5,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_1b6){if(!_1b6){return _1b6;}if(typeof _1b6=="string"||_1b6 instanceof _1b4){_1b6={color:_1b6};}return g.makeParameters(g.defaultStroke,_1b6);},augmentColor:function(_1b7,_1b8){var t=new _1b4(_1b7),c=new _1b4(_1b8);c.a=t.a;return c;},augmentStroke:function(_1b9,_1ba){var s=_1b5.makeStroke(_1b9);if(s){s.color=_1b5.augmentColor(s.color,_1ba);}return s;},augmentFill:function(fill,_1bb){var fc,c=new _1b4(_1bb);if(typeof fill=="string"||fill instanceof _1b4){return _1b5.augmentColor(fill,_1bb);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_1bc,_1bd){var _1be=lang.delegate(_1b5.defaultStats);for(var i=0;i<_1bc.length;++i){var run=_1bc[i];for(var j=0;j<run.data.length;j++){if(!_1bd(run.data[j])){if(typeof run.data[j]=="number"){var _1bf=_1be.vmin,_1c0=_1be.vmax;arr.forEach(run.data,function(val,i){if(!_1bd(val)){var x=i+1,y=val;if(isNaN(y)){y=0;}_1be.hmin=Math.min(_1be.hmin,x);_1be.hmax=Math.max(_1be.hmax,x);_1be.vmin=Math.min(_1be.vmin,y);_1be.vmax=Math.max(_1be.vmax,y);}});if("ymin" in run){_1be.vmin=Math.min(_1bf,run.ymin);}if("ymax" in run){_1be.vmax=Math.max(_1c0,run.ymax);}}else{var _1c1=_1be.hmin,_1c2=_1be.hmax,_1bf=_1be.vmin,_1c0=_1be.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(!_1bd(val)){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_1be.hmin=Math.min(_1be.hmin,x);_1be.hmax=Math.max(_1be.hmax,x);_1be.vmin=Math.min(_1be.vmin,y);_1be.vmax=Math.max(_1be.vmax,y);}});}if("xmin" in run){_1be.hmin=Math.min(_1c1,run.xmin);}if("xmax" in run){_1be.hmax=Math.max(_1c2,run.xmax);}if("ymin" in run){_1be.vmin=Math.min(_1bf,run.ymin);}if("ymax" in run){_1be.vmax=Math.max(_1c0,run.ymax);}}break;}}}return _1be;},calculateBarSize:function(_1c3,opt,_1c4){if(!_1c4){_1c4=1;}var gap=opt.gap,size=(_1c3-2*gap)/_1c4;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_1c3-size*_1c4)/2;return {size:size,gap:gap};},collectStackedStats:function(_1c5){var _1c6=lang.clone(_1b5.defaultStats);if(_1c5.length){_1c6.hmin=Math.min(_1c6.hmin,1);_1c6.hmax=df.foldl(_1c5,"seed, run -> Math.max(seed, run.data.length)",_1c6.hmax);for(var i=0;i<_1c6.hmax;++i){var v=_1c5[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_1c6.vmin=Math.min(_1c6.vmin,v);for(var j=1;j<_1c5.length;++j){var t=_1c5[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_1c6.vmax=Math.max(_1c6.vmax,v);}}return _1c6;},curve:function(a,_1c7){var _1c8=a.slice(0);if(_1c7=="x"){_1c8[_1c8.length]=_1c8[0];}var p=arr.map(_1c8,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_1c7)){var dx=item.x-_1c8[i-1].x,dy=_1c8[i-1].y;return "C"+(item.x-(_1c7-1)*(dx/_1c7))+","+dy+" "+(item.x-(dx/_1c7))+","+item.y+" "+item.x+","+item.y;}else{if(_1c7=="X"||_1c7=="x"||_1c7=="S"){var p0,p1=_1c8[i-1],p2=_1c8[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_1c7=="x"){p0=_1c8[_1c8.length-2];}else{p0=p1;}f=1/3;}else{p0=_1c8[i-2];}if(i==(_1c8.length-1)){if(_1c7=="x"){p3=_1c8[1];}else{p3=p2;}f=1/3;}else{p3=_1c8[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _1c9=p0p2*f;var _1ca=p1p3*f;if(_1c9>p1p2/2&&_1ca>p1p2/2){_1c9=p1p2/2;_1ca=p1p2/2;}else{if(_1c9>p1p2/2){_1c9=p1p2/2;_1ca=p1p2/2*p1p3/p0p2;}else{if(_1ca>p1p2/2){_1ca=p1p2/2;_1c9=p1p2/2*p0p2/p1p3;}}}if(_1c7=="S"){if(p0==p1){_1c9=0;}if(p2==p3){_1ca=0;}}bz1x=p1.x+_1c9*(p2.x-p0.x)/p0p2;bz1y=p1.y+_1c9*(p2.y-p0.y)/p0p2;bz2x=p2.x-_1ca*(p3.x-p1.x)/p1p3;bz2y=p2.y-_1ca*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_1cb,_1cc,_1cd){return sc.doIfLoaded("dojo/number",function(_1ce){return (_1cc?_1ce.format(_1cb,{places:_1cd}):_1ce.format(_1cb))||"";},function(){return _1cc?_1cb.toFixed(_1cd):_1cb.toString();});},purgeGroup:function(item){return item.purgeGroup();}});});},"dojox/lang/functional":function(){define(["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/lang/functional/lambda":function(){define(["../..","dojo/_base/lang","dojo/_base/array"],function(_1cf,lang,arr){var df=lang.getObject("lang.functional",true,_1cf);var _1d0={};var _1d1="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _1d2=function(s){var args=[],_1d3=_1d1.call(s,/\s*->\s*/m);if(_1d3.length>1){while(_1d3.length){s=_1d3.pop();args=_1d3.pop().split(/\s*,\s*|\s+/m);if(_1d3.length){_1d3.push("(function("+args.join(", ")+"){ return ("+s+"); })");}}}else{if(s.match(/\b_\b/)){args=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){args.push("$1");s="$1"+s;}if(r){args.push("$2");s=s+"$2";}}else{var vars=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(vars,function(v){if(!t.hasOwnProperty(v)){args.push(v);t[v]=1;}});}}}return {args:args,body:s};};var _1d4=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};lang.mixin(df,{rawLambda:function(s){return _1d2(s);},buildLambda:function(s){var l=_1d2(s);return "function("+l.args.join(",")+"){return ("+l.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _1d4(s);}if(_1d0.hasOwnProperty(s)){return _1d0[s];}var l=_1d2(s);return _1d0[s]=new Function(l.args,"return ("+l.body+");");},clearLambdaCache:function(){_1d0={};}});return df;});},"dojox/lang/functional/array":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","./lambda"],function(_1d5,lang,arr,df){var _1d6={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _1d6)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _1d6)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _1d6)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _1d6)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _1d6)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/lang/functional/object":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_1d7,lang,df){var _1d8={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _1d8)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _1d8)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _1d8)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);for(var i in obj){if(!(i in _1d8)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _1d8)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojox/charting/scaler/common":function(){define(["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _1d9=lang.getObject("dojox.charting.scaler.common",true);var _1da={};return lang.mixin(_1d9,{doIfLoaded:function(_1db,_1dc,_1dd){if(_1da[_1db]===undefined){try{_1da[_1db]=require(_1db);}catch(e){_1da[_1db]=null;}}if(_1da[_1db]){return _1dc(_1da[_1db]);}else{return _1dd();}},getNumericLabel:function(_1de,_1df,_1e0){var def="";_1d9.doIfLoaded("dojo/number",function(_1e1){def=(_1e0.fixed?_1e1.format(_1de,{places:_1df<0?-_1df:0}):_1e1.format(_1de))||"";},function(){def=_1e0.fixed?_1de.toFixed(_1df<0?-_1df:0):_1de.toString();});if(_1e0.labelFunc){var r=_1e0.labelFunc(def,_1de,_1df);if(r){return r;}}if(_1e0.labels){var l=_1e0.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_1de){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}}return def;}});});},"dojox/lang/functional/fold":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/kernel","./lambda"],function(lang,arr,_1e2,df){var _1e3={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _1e3)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _1e4=true;for(i in a){if(!(i in _1e3)){if(_1e4){z=a[i];_1e4=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||_1e2.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"dojox/lang/functional/reversed":function(){define(["dojo/_base/lang","dojo/_base/kernel","./lambda"],function(lang,_1e5,df){lang.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojox/charting/axis2d/Default":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/sniff","dojo/_base/declare","dojo/_base/connect","dojo/dom-geometry","./Invisible","../scaler/linear","./common","dojox/gfx","dojox/lang/utils","dojox/lang/functional","dojo/has!dojo-bidi?../bidi/axis2d/Default"],function(lang,arr,has,_1e6,_1e7,_1e8,_1e9,lin,_1ea,g,du,df,_1eb){var _1ec=45;var _1ed=_1e6(has("dojo-bidi")?"dojox.charting.axis2d.NonBidiDefault":"dojox.charting.axis2d.Default",_1e9,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true,enableCache:false,dropLabels:true,labelSizeChange:false,position:"leftOrBottom"},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:"",title:"",titleGap:0,titleFont:"",titleFontColor:"",titleOrientation:""},constructor:function(_1ee,_1ef){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_1ef);du.updateWithPattern(this.opt,_1ef,this.optionalParams);if(this.opt.enableCache){this._textFreePool=[];this._lineFreePool=[];this._textUsePool=[];this._lineUsePool=[];}this._invalidMaxLabelSize=true;if(!(_1ef&&("position" in _1ef))){this.opt.position=this.opt.leftBottom?"leftOrBottom":"rightOrTop";}this.renderingOptions={"shape-rendering":"crispEdges"};},setWindow:function(_1f0,_1f1){if(_1f0!=this.scale){this._invalidMaxLabelSize=true;}return this.inherited(arguments);},_groupLabelWidth:function(_1f2,font,_1f3){if(!_1f2.length){return 0;}if(_1f2.length>50){_1f2.length=50;}if(lang.isObject(_1f2[0])){_1f2=df.map(_1f2,function(_1f4){return _1f4.text;});}if(_1f3){_1f2=df.map(_1f2,function(_1f5){return lang.trim(_1f5).length==0?"":_1f5.substring(0,_1f3)+this.trailingSymbol;},this);}var s=_1f2.join("<br>");return g._base._getTextBox(s,{font:font}).w||0;},_getMaxLabelSize:function(min,max,span,_1f6,font,size){if(this._maxLabelSize==null&&arguments.length==6){var o=this.opt;this.scaler.minMinorStep=this._prevMinMinorStep=0;var ob=lang.clone(o);delete ob.to;delete ob.from;var sb=lin.buildScaler(min,max,span,ob,o.to-o.from);sb.minMinorStep=0;this._majorStart=sb.major.start;var tb=lin.buildTicks(sb,o);if(size&&tb){var _1f7=0,_1f8=0;var _1f9=function(tick){if(tick.label){this.push(tick.label);}};var _1fa=[];if(this.opt.majorLabels){arr.forEach(tb.major,_1f9,_1fa);_1f7=this._groupLabelWidth(_1fa,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_1f7=Math.min(ob.maxLabelSize,_1f7);}}_1fa=[];if(this.opt.dropLabels&&this.opt.minorLabels){arr.forEach(tb.minor,_1f9,_1fa);_1f8=this._groupLabelWidth(_1fa,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_1f8=Math.min(ob.maxLabelSize,_1f8);}}this._maxLabelSize={majLabelW:_1f7,minLabelW:_1f8,majLabelH:size,minLabelH:size};}else{this._maxLabelSize=null;}}return this._maxLabelSize;},calculate:function(min,max,span){this.inherited(arguments);this.scaler.minMinorStep=this._prevMinMinorStep;if((this._invalidMaxLabelSize||span!=this._oldSpan)&&(min!=Infinity&&max!=-Infinity)){this._invalidMaxLabelSize=false;if(this.opt.labelSizeChange){this._maxLabelSize=null;}this._oldSpan=span;var o=this.opt;var ta=this.chart.theme.axis,_1fb=o.rotation%360,_1fc=this.chart.theme.axis.tick.labelGap,font=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),size=font?g.normalizedLength(g.splitFontString(font).size):0,_1fd=this._getMaxLabelSize(min,max,span,_1fb,font,size);if(typeof _1fc!="number"){_1fc=4;}if(_1fd&&o.dropLabels){var cosr=Math.abs(Math.cos(_1fb*Math.PI/180)),sinr=Math.abs(Math.sin(_1fb*Math.PI/180));var _1fe,_1ff;if(_1fb<0){_1fb+=360;}switch(_1fb){case 0:case 180:if(this.vertical){_1fe=_1ff=size;}else{_1fe=_1fd.majLabelW;_1ff=_1fd.minLabelW;}break;case 90:case 270:if(this.vertical){_1fe=_1fd.majLabelW;_1ff=_1fd.minLabelW;}else{_1fe=_1ff=size;}break;default:_1fe=this.vertical?Math.min(_1fd.majLabelW,size/cosr):Math.min(_1fd.majLabelW,size/sinr);var gap1=Math.sqrt(_1fd.minLabelW*_1fd.minLabelW+size*size),gap2=this.vertical?size*cosr+_1fd.minLabelW*sinr:_1fd.minLabelW*cosr+size*sinr;_1ff=Math.min(gap1,gap2);break;}this.scaler.minMinorStep=this._prevMinMinorStep=Math.max(_1fe,_1ff)+_1fc;var _200=this.scaler.minMinorStep<=this.scaler.minor.tick*this.scaler.bounds.scale;if(!_200){this._skipInterval=Math.floor((_1fe+_1fc)/(this.scaler.major.tick*this.scaler.bounds.scale));}else{this._skipInterval=0;}}else{this._skipInterval=0;}}this.ticks=lin.buildTicks(this.scaler,this.opt);return this;},getOffsets:function(){var s=this.scaler,_201={l:0,r:0,t:0,b:0};if(!s){return _201;}var o=this.opt,ta=this.chart.theme.axis,_202=this.chart.theme.axis.tick.labelGap,_203=o.titleFont||(ta.title&&ta.title.font),_204=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap),_205=this.chart.theme.getTick("major",o),_206=this.chart.theme.getTick("minor",o),_207=_203?g.normalizedLength(g.splitFontString(_203).size):0,_208=o.rotation%360,_209=o.position,_20a=_209!=="rightOrTop",cosr=Math.abs(Math.cos(_208*Math.PI/180)),sinr=Math.abs(Math.sin(_208*Math.PI/180));this.trailingSymbol=(o.trailingSymbol===undefined||o.trailingSymbol===null)?this.trailingSymbol:o.trailingSymbol;if(typeof _202!="number"){_202=4;}if(_208<0){_208+=360;}var _20b=this._getMaxLabelSize();if(_20b){var side;var _20c=Math.ceil(Math.max(_20b.majLabelW,_20b.minLabelW))+1,size=Math.ceil(Math.max(_20b.majLabelH,_20b.minLabelH))+1;if(this.vertical){side=_20a?"l":"r";switch(_208){case 0:case 180:_201[side]=_209==="center"?0:_20c;_201.t=_201.b=size/2;break;case 90:case 270:_201[side]=size;_201.t=_201.b=_20c/2;break;default:if(_208<=_1ec||(180<_208&&_208<=(180+_1ec))){_201[side]=size*sinr/2+_20c*cosr;_201[_20a?"t":"b"]=size*cosr/2+_20c*sinr;_201[_20a?"b":"t"]=size*cosr/2;}else{if(_208>(360-_1ec)||(180>_208&&_208>(180-_1ec))){_201[side]=size*sinr/2+_20c*cosr;_201[_20a?"b":"t"]=size*cosr/2+_20c*sinr;_201[_20a?"t":"b"]=size*cosr/2;}else{if(_208<90||(180<_208&&_208<270)){_201[side]=size*sinr+_20c*cosr;_201[_20a?"t":"b"]=size*cosr+_20c*sinr;}else{_201[side]=size*sinr+_20c*cosr;_201[_20a?"b":"t"]=size*cosr+_20c*sinr;}}}break;}if(_209==="center"){_201[side]=0;}else{_201[side]+=_202+Math.max(_205.length>0?_205.length:0,_206.length>0?_206.length:0)+(o.title?(_207+_204):0);}}else{side=_20a?"b":"t";switch(_208){case 0:case 180:_201[side]=_209==="center"?0:size;_201.l=_201.r=_20c/2;break;case 90:case 270:_201[side]=_20c;_201.l=_201.r=size/2;break;default:if((90-_1ec)<=_208&&_208<=90||(270-_1ec)<=_208&&_208<=270){_201[side]=size*cosr/2+_20c*sinr;_201[_20a?"r":"l"]=size*sinr/2+_20c*cosr;_201[_20a?"l":"r"]=size*sinr/2;}else{if(90<=_208&&_208<=(90+_1ec)||270<=_208&&_208<=(270+_1ec)){_201[side]=size*cosr/2+_20c*sinr;_201[_20a?"l":"r"]=size*sinr/2+_20c*cosr;_201[_20a?"r":"l"]=size*sinr/2;}else{if(_208<_1ec||(180<_208&&_208<(180+_1ec))){_201[side]=size*cosr+_20c*sinr;_201[_20a?"r":"l"]=size*sinr+_20c*cosr;}else{_201[side]=size*cosr+_20c*sinr;_201[_20a?"l":"r"]=size*sinr+_20c*cosr;}}}break;}if(_209==="center"){_201[side]=0;}else{_201[side]+=_202+Math.max(_205.length>0?_205.length:0,_206.length>0?_206.length:0)+(o.title?(_207+_204):0);}}}return _201;},cleanGroup:function(_20d){if(this.opt.enableCache&&this.group){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._textFreePool=this._textFreePool.concat(this._textUsePool);this._textUsePool=[];}this.inherited(arguments);},createText:function(_20e,_20f,x,y,_210,_211,font,_212,_213){if(!this.opt.enableCache||_20e=="html"){return _1ea.createText[_20e](this.chart,_20f,x,y,_210,_211,font,_212,_213);}var text;if(this._textFreePool.length>0){text=this._textFreePool.pop();text.setShape({x:x,y:y,text:_211,align:_210});_20f.add(text);}else{text=_1ea.createText[_20e](this.chart,_20f,x,y,_210,_211,font,_212);}this._textUsePool.push(text);return text;},createLine:function(_214,_215){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_215);_214.add(line);}else{line=_214.createLine(_215);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_216){var _217=this._isRtl();if(!this.dirty||!this.scaler){return this;}var o=this.opt,ta=this.chart.theme.axis,_218=o.position,_219=_218!=="rightOrTop",_21a=o.rotation%360,_21b,stop,_21c,_21d=0,_21e,_21f,_220,_221,_222,_223,_224=this.chart.theme.axis.tick.labelGap,_225=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_226=o.titleFont||(ta.title&&ta.title.font),_227=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_228=o.titleFontColor||(ta.title&&ta.title.fontColor)||"black",_229=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap)||15,_22a=o.titleOrientation||(ta.title&&ta.title.orientation)||"axis",_22b=this.chart.theme.getTick("major",o),_22c=this.chart.theme.getTick("minor",o),_22d=this.chart.theme.getTick("micro",o),_22e="stroke" in o?o.stroke:ta.stroke,size=_225?g.normalizedLength(g.splitFontString(_225).size):0,cosr=Math.abs(Math.cos(_21a*Math.PI/180)),sinr=Math.abs(Math.sin(_21a*Math.PI/180)),_22f=_226?g.normalizedLength(g.splitFontString(_226).size):0;if(typeof _224!="number"){_224=4;}if(_21a<0){_21a+=360;}var _230=this._getMaxLabelSize();_230=_230&&_230.majLabelW;if(this.vertical){_21b={y:dim.height-_216.b};stop={y:_216.t};_21c={y:(dim.height-_216.b+_216.t)/2};_21e=size*sinr+(_230||0)*cosr+_224+Math.max(_22b.length>0?_22b.length:0,_22c.length>0?_22c.length:0)+_22f+_229;_21f={x:0,y:-1};_222={x:0,y:0};_220={x:1,y:0};_221={x:_224,y:0};switch(_21a){case 0:_223="end";_222.y=size*0.4;break;case 90:_223="middle";_222.x=-size;break;case 180:_223="start";_222.y=-size*0.4;break;case 270:_223="middle";break;default:if(_21a<_1ec){_223="end";_222.y=size*0.4;}else{if(_21a<90){_223="end";_222.y=size*0.4;}else{if(_21a<(180-_1ec)){_223="start";}else{if(_21a<(180+_1ec)){_223="start";_222.y=-size*0.4;}else{if(_21a<270){_223="start";_222.x=_219?0:size*0.4;}else{if(_21a<(360-_1ec)){_223="end";_222.x=_219?0:size*0.4;}else{_223="end";_222.y=size*0.4;}}}}}}}if(_219){_21b.x=stop.x=_218==="center"?dim.width/2:_216.l;_21d=(_22a&&_22a=="away")?90:270;_21c.x=_216.l-_21e+(_21d==270?_22f:0);_220.x=-1;_221.x=-_221.x;}else{_21b.x=stop.x=dim.width-_216.r;_21d=(_22a&&_22a=="axis")?90:270;_21c.x=dim.width-_216.r+_21e-(_21d==270?0:_22f);switch(_223){case "start":_223="end";break;case "end":_223="start";break;case "middle":_222.x+=size;break;}}}else{_21b={x:_216.l};stop={x:dim.width-_216.r};_21c={x:(dim.width-_216.r+_216.l)/2};_21e=size*cosr+(_230||0)*sinr+_224+Math.max(_22b.length>0?_22b.length:0,_22c.length>0?_22c.length:0)+_22f+_229;_21f={x:_217?-1:1,y:0};_222={x:0,y:0};_220={x:0,y:1};_221={x:0,y:_224};switch(_21a){case 0:_223="middle";_222.y=size;break;case 90:_223="start";_222.x=-size*0.4;break;case 180:_223="middle";break;case 270:_223="end";_222.x=size*0.4;break;default:if(_21a<(90-_1ec)){_223="start";_222.y=_219?size:0;}else{if(_21a<(90+_1ec)){_223="start";_222.x=-size*0.4;}else{if(_21a<180){_223="start";_222.y=_219?0:-size;}else{if(_21a<(270-_1ec)){_223="end";_222.y=_219?0:-size;}else{if(_21a<(270+_1ec)){_223="end";_222.y=_219?size*0.4:0;}else{_223="end";_222.y=_219?size:0;}}}}}}if(_219){_21b.y=stop.y=_218==="center"?dim.height/2:dim.height-_216.b;_21d=(_22a&&_22a=="axis")?180:0;_21c.y=dim.height-_216.b+_21e-(_21d?_22f:0);}else{_21b.y=stop.y=_216.t;_21d=(_22a&&_22a=="away")?180:0;_21c.y=_216.t-_21e+(_21d?0:_22f);_220.y=-1;_221.y=-_221.y;switch(_223){case "start":_223="end";break;case "end":_223="start";break;case "middle":_222.y-=size;break;}}}this.cleanGroup();var s=this.group,c=this.scaler,t=this.ticks,f=lin.getTransformerFromModel(this.scaler),_231=(!o.title||!_21d)&&!_21a&&this.opt.htmlLabels&&!has("ie")&&!has("opera")?"html":"gfx",dx=_220.x*_22b.length,dy=_220.y*_22b.length,skip=this._skipInterval;s.createLine({x1:_21b.x,y1:_21b.y,x2:stop.x,y2:stop.y}).setStroke(_22e);if(o.title){var _232=_1ea.createText[_231](this.chart,s,_21c.x,_21c.y,"middle",o.title,_226,_228);if(_231=="html"){this.htmlElements.push(_232);}else{_232.setTransform(g.matrix.rotategAt(_21d,_21c.x,_21c.y));}}if(t==null){this.dirty=false;return this;}var rel=(t.major.length>0)?(t.major[0].value-this._majorStart)/c.major.tick:0;var _233=this.opt.majorLabels;arr.forEach(t.major,function(tick,i){var _234=f(tick.value),elem,x=(_217?stop.x:_21b.x)+_21f.x*_234,y=_21b.y+_21f.y*_234;i+=rel;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_22b);if(tick.label&&(!skip||(i-(1+skip))%(1+skip)==0)){var _235=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_225,o.maxLabelCharCount):{text:tick.label,truncated:false};_235=o.maxLabelSize?this.getTextWithLimitLength(_235.text,_225,o.maxLabelSize,_235.truncated):_235;elem=this.createText(_231,s,x+(_22b.length>0?dx:0)+_221.x+(_21a?0:_222.x),y+(_22b.length>0?dy:0)+_221.y+(_21a?0:_222.y),_223,_235.text,_225,_227);if(_235.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_231);}_235.truncated&&this.labelTooltip(elem,this.chart,tick.label,_235.text,_225,_231);if(_231=="html"){this.htmlElements.push(elem);}else{if(_21a){elem.setTransform([{dx:_222.x,dy:_222.y},g.matrix.rotategAt(_21a,x+(_22b.length>0?dx:0)+_221.x,y+(_22b.length>0?dy:0)+_221.y)]);}}}},this);dx=_220.x*_22c.length;dy=_220.y*_22c.length;_233=this.opt.minorLabels&&c.minMinorStep<=c.minor.tick*c.bounds.scale;arr.forEach(t.minor,function(tick){var _236=f(tick.value),elem,x=(_217?stop.x:_21b.x)+_21f.x*_236,y=_21b.y+_21f.y*_236;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_22c);if(_233&&tick.label){var _237=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_225,o.maxLabelCharCount):{text:tick.label,truncated:false};_237=o.maxLabelSize?this.getTextWithLimitLength(_237.text,_225,o.maxLabelSize,_237.truncated):_237;elem=this.createText(_231,s,x+(_22c.length>0?dx:0)+_221.x+(_21a?0:_222.x),y+(_22c.length>0?dy:0)+_221.y+(_21a?0:_222.y),_223,_237.text,_225,_227);if(_237.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_231);}_237.truncated&&this.labelTooltip(elem,this.chart,tick.label,_237.text,_225,_231);if(_231=="html"){this.htmlElements.push(elem);}else{if(_21a){elem.setTransform([{dx:_222.x,dy:_222.y},g.matrix.rotategAt(_21a,x+(_22c.length>0?dx:0)+_221.x,y+(_22c.length>0?dy:0)+_221.y)]);}}}},this);dx=_220.x*_22d.length;dy=_220.y*_22d.length;arr.forEach(t.micro,function(tick){var _238=f(tick.value),x=_21b.x+_21f.x*_238,y=_21b.y+_21f.y*_238;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_22d);},this);this.dirty=false;return this;},labelTooltip:function(elem,_239,_23a,_23b,font,_23c){var _23d=["dijit/Tooltip"];var _23e={type:"rect"},_23f=["above","below"],_240=g._base._getTextBox(_23b,{font:font}).w||0,_241=font?g.normalizedLength(g.splitFontString(font).size):0;if(_23c=="html"){lang.mixin(_23e,_1e8.position(elem.firstChild,true));_23e.width=Math.ceil(_240);_23e.height=Math.ceil(_241);this._events.push({shape:dojo,handle:_1e7.connect(elem.firstChild,"onmouseover",this,function(e){require(_23d,function(_242){_242.show(_23a,_23e,_23f);});})});this._events.push({shape:dojo,handle:_1e7.connect(elem.firstChild,"onmouseout",this,function(e){require(_23d,function(_243){_243.hide(_23e);});})});}else{var shp=elem.getShape(),lt=_239.getCoords();_23e=lang.mixin(_23e,{x:shp.x-_240/2,y:shp.y});_23e.x+=lt.x;_23e.y+=lt.y;_23e.x=Math.round(_23e.x);_23e.y=Math.round(_23e.y);_23e.width=Math.ceil(_240);_23e.height=Math.ceil(_241);this._events.push({shape:elem,handle:elem.connect("onmouseenter",this,function(e){require(_23d,function(_244){_244.show(_23a,_23e,_23f);});})});this._events.push({shape:elem,handle:elem.connect("onmouseleave",this,function(e){require(_23d,function(_245){_245.hide(_23e);});})});}},_isRtl:function(){return false;}});return has("dojo-bidi")?_1e6("dojox.charting.axis2d.Default",[_1ed,_1eb]):_1ed;});},"dojox/charting/axis2d/Invisible":function(){define(["dojo/_base/lang","dojo/_base/declare","./Base","../scaler/linear","dojox/lang/utils"],function(lang,_246,Base,lin,du){return _246("dojox.charting.axis2d.Invisible",Base,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1},constructor:function(_247,_248){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_248);du.updateWithPattern(this.opt,_248,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_249,_24a){this.scale=_249;this.offset=_24a;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},calculate:function(min,max,span,_24b){if(this.initialized()){return this;}var o=this.opt;this.labels=o.labels;this.scaler=(_24b||lin).buildScaler(min,max,span,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=(_24b||lin).buildScaler(min,max,span,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});});},"dojox/charting/axis2d/Base":function(){define(["dojo/_base/declare","../Element"],function(_24c,_24d){return _24c("dojox.charting.axis2d.Base",_24d,{constructor:function(_24e,_24f){this.vertical=_24f&&_24f.vertical;this.opt={};this.opt.min=_24f&&_24f.min;this.opt.max=_24f&&_24f.max;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_250){this.dirty=false;return this;},isNullValue:function(_251){return false;},naturalBaseline:0});});},"dojox/charting/scaler/linear":function(){define(["dojo/_base/lang","./common"],function(lang,_252){var _253=lang.getObject("dojox.charting.scaler.linear",true);var _254=3,_255=_252.getNumericLabel;function _256(val,text){val=val.toLowerCase();for(var i=text.length-1;i>=0;--i){if(val===text[i]){return true;}}return false;};var _257=function(min,max,_258,_259,_25a,_25b,span){_258=lang.delegate(_258);if(!_259){if(_258.fixUpper=="major"){_258.fixUpper="minor";}if(_258.fixLower=="major"){_258.fixLower="minor";}}if(!_25a){if(_258.fixUpper=="minor"){_258.fixUpper="micro";}if(_258.fixLower=="minor"){_258.fixLower="micro";}}if(!_25b){if(_258.fixUpper=="micro"){_258.fixUpper="none";}if(_258.fixLower=="micro"){_258.fixLower="none";}}var _25c=_256(_258.fixLower,["major"])?Math.floor(_258.min/_259)*_259:_256(_258.fixLower,["minor"])?Math.floor(_258.min/_25a)*_25a:_256(_258.fixLower,["micro"])?Math.floor(_258.min/_25b)*_25b:_258.min,_25d=_256(_258.fixUpper,["major"])?Math.ceil(_258.max/_259)*_259:_256(_258.fixUpper,["minor"])?Math.ceil(_258.max/_25a)*_25a:_256(_258.fixUpper,["micro"])?Math.ceil(_258.max/_25b)*_25b:_258.max;if(_258.useMin){min=_25c;}if(_258.useMax){max=_25d;}var _25e=(!_259||_258.useMin&&_256(_258.fixLower,["major"]))?min:Math.ceil(min/_259)*_259,_25f=(!_25a||_258.useMin&&_256(_258.fixLower,["major","minor"]))?min:Math.ceil(min/_25a)*_25a,_260=(!_25b||_258.useMin&&_256(_258.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_25b)*_25b,_261=!_259?0:(_258.useMax&&_256(_258.fixUpper,["major"])?Math.round((max-_25e)/_259):Math.floor((max-_25e)/_259))+1,_262=!_25a?0:(_258.useMax&&_256(_258.fixUpper,["major","minor"])?Math.round((max-_25f)/_25a):Math.floor((max-_25f)/_25a))+1,_263=!_25b?0:(_258.useMax&&_256(_258.fixUpper,["major","minor","micro"])?Math.round((max-_260)/_25b):Math.floor((max-_260)/_25b))+1,_264=_25a?Math.round(_259/_25a):0,_265=_25b?Math.round(_25a/_25b):0,_266=_259?Math.floor(Math.log(_259)/Math.LN10):0,_267=_25a?Math.floor(Math.log(_25a)/Math.LN10):0,_268=span/(max-min);if(!isFinite(_268)){_268=1;}return {bounds:{lower:_25c,upper:_25d,from:min,to:max,scale:_268,span:span},major:{tick:_259,start:_25e,count:_261,prec:_266},minor:{tick:_25a,start:_25f,count:_262,prec:_267},micro:{tick:_25b,start:_260,count:_263,prec:0},minorPerMajor:_264,microPerMinor:_265,scaler:_253};};return lang.mixin(_253,{buildScaler:function(min,max,span,_269,_26a,_26b){var h={fixUpper:"none",fixLower:"none",natural:false};if(_269){if("fixUpper" in _269){h.fixUpper=String(_269.fixUpper);}if("fixLower" in _269){h.fixLower=String(_269.fixLower);}if("natural" in _269){h.natural=Boolean(_269.natural);}}_26b=!_26b||_26b<_254?_254:_26b;if("min" in _269){min=_269.min;}if("max" in _269){max=_269.max;}if(_269.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _269){min=_269.from;h.useMin=false;}if("to" in _269){max=_269.to;h.useMax=false;}if(max<=min){return _257(min,max,h,0,0,0,span);}if(!_26a){_26a=max-min;}var mag=Math.floor(Math.log(_26a)/Math.LN10),_26c=_269&&("majorTickStep" in _269)?_269.majorTickStep:Math.pow(10,mag),_26d=0,_26e=0,_26f;if(_269&&("minorTickStep" in _269)){_26d=_269.minorTickStep;}else{do{_26d=_26c/10;if(!h.natural||_26d>0.9){_26f=_257(min,max,h,_26c,_26d,0,span);if(_26f.bounds.scale*_26f.minor.tick>_26b){break;}}_26d=_26c/5;if(!h.natural||_26d>0.9){_26f=_257(min,max,h,_26c,_26d,0,span);if(_26f.bounds.scale*_26f.minor.tick>_26b){break;}}_26d=_26c/2;if(!h.natural||_26d>0.9){_26f=_257(min,max,h,_26c,_26d,0,span);if(_26f.bounds.scale*_26f.minor.tick>_26b){break;}}return _257(min,max,h,_26c,0,0,span);}while(false);}if(_269&&("microTickStep" in _269)){_26e=_269.microTickStep;_26f=_257(min,max,h,_26c,_26d,_26e,span);}else{do{_26e=_26d/10;if(!h.natural||_26e>0.9){_26f=_257(min,max,h,_26c,_26d,_26e,span);if(_26f.bounds.scale*_26f.micro.tick>_254){break;}}_26e=_26d/5;if(!h.natural||_26e>0.9){_26f=_257(min,max,h,_26c,_26d,_26e,span);if(_26f.bounds.scale*_26f.micro.tick>_254){break;}}_26e=_26d/2;if(!h.natural||_26e>0.9){_26f=_257(min,max,h,_26c,_26d,_26e,span);if(_26f.bounds.scale*_26f.micro.tick>_254){break;}}_26e=0;}while(false);}return _26e?_26f:_257(min,max,h,_26c,_26d,0,span);},buildTicks:function(_270,_271){var step,next,tick,_272=_270.major.start,_273=_270.minor.start,_274=_270.micro.start;if(_271.microTicks&&_270.micro.tick){step=_270.micro.tick,next=_274;}else{if(_271.minorTicks&&_270.minor.tick){step=_270.minor.tick,next=_273;}else{if(_270.major.tick){step=_270.major.tick,next=_272;}else{return null;}}}var _275=1/_270.bounds.scale;if(_270.bounds.to<=_270.bounds.from||isNaN(_275)||!isFinite(_275)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _276=[],_277=[],_278=[];while(next<=_270.bounds.to+_275){if(Math.abs(_272-next)<step/2){tick={value:_272};if(_271.majorLabels){tick.label=_255(_272,_270.major.prec,_271);}_276.push(tick);_272+=_270.major.tick;_273+=_270.minor.tick;_274+=_270.micro.tick;}else{if(Math.abs(_273-next)<step/2){if(_271.minorTicks){tick={value:_273};if(_271.minorLabels&&(_270.minMinorStep<=_270.minor.tick*_270.bounds.scale)){tick.label=_255(_273,_270.minor.prec,_271);}_277.push(tick);}_273+=_270.minor.tick;_274+=_270.micro.tick;}else{if(_271.microTicks){_278.push({value:_274});}_274+=_270.micro.tick;}}next+=step;}return {major:_276,minor:_277,micro:_278};},getTransformerFromModel:function(_279){var _27a=_279.bounds.from,_27b=_279.bounds.scale;return function(x){return (x-_27a)*_27b;};},getTransformerFromPlot:function(_27c){var _27d=_27c.bounds.from,_27e=_27c.bounds.scale;return function(x){return x/_27e+_27d;};}});});},"dojox/charting/plot2d/ClusteredBars":function(){define(["dojo/_base/declare","dojo/_base/array","./Bars","./common"],function(_27f,_280,Bars,dc){return _27f("dojox.charting.plot2d.ClusteredBars",Bars,{getBarProperties:function(){var _281=this.series.length;_280.forEach(this.series,function(_282){if(_282.hidden){_281--;}});var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,_281);return {gap:f.gap,height:f.size,thickness:f.size};}});});},"dojox/charting/plot2d/Bars":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/gfx/fx","dojox/lang/utils","dojox/lang/functional"],function(lang,arr,_283,has,_284,_285,dc,fx,du,df){var _286=function(){return false;};return _283("dojox.charting.plot2d.Bars",[_284,_285],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_287,_288){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_288);du.updateWithPattern(this.opt,_288,this.optionalParams);this.animate=this.opt.animate;this.renderingOptions={"shape-rendering":"crispEdges"};},getSeriesStats:function(){var _289=dc.collectSimpleStats(this.series,lang.hitch(this,"isNullValue")),t;_289.hmin-=0.5;_289.hmax+=0.5;t=_289.hmin,_289.hmin=_289.vmin,_289.vmin=t;t=_289.hmax,_289.hmax=_289.vmax,_289.vmax=t;return _289;},createRect:function(run,_28a,_28b){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_28b);_28a.add(rect);}else{rect=_28a.createRect(_28b);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},createLabel:function(_28c,_28d,bbox,_28e){if(this.opt.labels&&this.opt.labelStyle=="outside"){var y=bbox.y+bbox.height/2;var x=bbox.x+bbox.width+this.opt.labelOffset;this.renderLabel(_28c,x,y,this._getLabel(isNaN(_28d.y)?_28d:_28d.y),_28e,"start");}else{this.inherited(arguments);}},render:function(dim,_28f){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_28f);}this.dirty=this.isDirty();this.resetEvents();var s;if(this.dirty){arr.forEach(this.series,dc.purgeGroup);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_290=Math.max(this._hScaler.bounds.lower,this._hAxis?this._hAxis.naturalBaseline:0),_291=ht(_290),_292=this.events();var bar=this.getBarProperties();var _293=this.series.length;arr.forEach(this.series,function(_294){if(_294.hidden){_293--;}});var z=_293;var _295=this.extractValues(this._vScaler);_295=this.rearrangeValues(_295,ht,_291);for(var i=0;i<this.series.length;i++){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _296=t.next("bar",[this.opt,run]);if(run.hidden){run.dyn.fill=_296.series.fill;run.dyn.stroke=_296.series.stroke;continue;}z--;var _297=new Array(run.data.length);s=run.group;var _298=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_298?Math.max(0,Math.floor(this._vScaler.bounds.from-1)):0;var max=_298?Math.min(run.data.length,Math.ceil(this._vScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _299=run.data[j];if(!this.isNullValue(_299)){var val=this.getValue(_299,j,i,_298),w=_295[i][j],_29a,_29b;if(this.opt.styleFunc||typeof _299!="number"){var _29c=typeof _299!="number"?[_299]:[];if(this.opt.styleFunc){_29c.push(this.opt.styleFunc(_299));}_29a=t.addMixin(_296,"bar",_29c,true);}else{_29a=t.post(_296,"bar");}if(w&&bar.height>=1){var rect={x:_28f.l+_291+Math.min(w,0),y:dim.height-_28f.b-vt(val.x+1.5)+bar.gap+bar.thickness*(_293-z-1),width:Math.abs(w),height:bar.height};if(_29a.series.shadow){var _29d=lang.clone(rect);_29d.x+=_29a.series.shadow.dx;_29d.y+=_29a.series.shadow.dy;_29b=this.createRect(run,s,_29d).setFill(_29a.series.shadow.color).setStroke(_29a.series.shadow);if(this.animate){this._animateBar(_29b,_28f.l+_291,-w);}}var _29e=this._plotFill(_29a.series.fill,dim,_28f);_29e=this._shapeFill(_29e,rect);var _29f=this.createRect(run,s,rect).setFill(_29e).setStroke(_29a.series.stroke);if(_29f.setFilter&&_29a.series.filter){_29f.setFilter(_29a.series.filter);}run.dyn.fill=_29f.getFill();run.dyn.stroke=_29f.getStroke();if(_292){var o={element:"bar",index:j,run:run,shape:_29f,shadow:_29b,cx:val.y,cy:val.x+1.5,x:_298?j:run.data[j].x,y:_298?run.data[j]:run.data[j].y};this._connectEvents(o);_297[j]=o;}if(!isNaN(val.py)&&val.py>_290){rect.x+=ht(val.py);rect.width-=ht(val.py);}this.createLabel(s,_299,rect,_29a);if(this.animate){this._animateBar(_29f,_28f.l+_291,-Math.abs(w));}}}}this._eventSeries[run.name]=_297;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_28f);}return this;},getValue:function(_2a0,j,_2a1,_2a2){var y,x;if(_2a2){if(typeof _2a0=="number"){y=_2a0;}else{y=_2a0.y;}x=j;}else{y=_2a0.y;x=_2a0.x-1;}return {y:y,x:x};},extractValues:function(_2a3){var _2a4=[];for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}var _2a5=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));}),min=_2a5?Math.max(0,Math.floor(_2a3.bounds.from-1)):0,max=_2a5?Math.min(run.data.length,Math.ceil(_2a3.bounds.to)):run.data.length,_2a6=_2a4[i]=[];_2a6.min=min;_2a6.max=max;for(var j=min;j<max;++j){var _2a7=run.data[j];_2a6[j]=this.isNullValue(_2a7)?0:(typeof _2a7=="number"?_2a7:_2a7.y);}}return _2a4;},rearrangeValues:function(_2a8,_2a9,_2aa){for(var i=0,n=_2a8.length;i<n;++i){var _2ab=_2a8[i];if(_2ab){for(var j=_2ab.min,k=_2ab.max;j<k;++j){var _2ac=_2ab[j];_2ab[j]=this.isNullValue(_2ac)?0:_2a9(_2ac)-_2aa;}}}return _2a8;},isNullValue:function(_2ad){if(_2ad===null||typeof _2ad=="undefined"){return true;}var h=this._hAxis?this._hAxis.isNullValue:_286,v=this._vAxis?this._vAxis.isNullValue:_286;if(typeof _2ad=="number"){return v(0.5)||h(_2ad);}return v(isNaN(_2ad.x)?0.5:_2ad.x+0.5)||_2ad.y===null||h(_2ad.y);},getBarProperties:function(){var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);return {gap:f.gap,height:f.size,thickness:0};},_animateBar:function(_2ae,_2af,_2b0){if(_2b0==0){_2b0=1;}fx.animateTransform(lang.delegate({shape:_2ae,duration:1200,transform:[{name:"translate",start:[_2af-(_2af/_2b0),0],end:[0,0]},{name:"scale",start:[1/_2b0,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/plot2d/CartesianBase":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/has","./Base","../scaler/primitive","dojox/gfx","dojox/gfx/fx","dojox/lang/utils"],function(lang,_2b1,hub,has,Base,_2b2,gfx,fx,du){var _2b3=function(){return false;};return _2b1("dojox.charting.plot2d.CartesianBase",Base,{baseParams:{hAxis:"x",vAxis:"y",labels:false,labelOffset:10,fixed:true,precision:1,labelStyle:"inside",htmlLabels:true,omitLabels:true,labelFunc:null},constructor:function(_2b4,_2b5){this.axes=["hAxis","vAxis"];this.zoom=null;this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};this.hAxis=(_2b5&&_2b5.hAxis)||"x";this.vAxis=(_2b5&&_2b5.vAxis)||"y";this.series=[];this.opt=lang.clone(this.baseParams);du.updateWithObject(this.opt,_2b5);},clear:function(){this.inherited(arguments);this._hAxis=null;this._vAxis=null;return this;},cleanGroup:function(_2b6,_2b7){this.inherited(arguments);if(!_2b7&&this.chart._nativeClip){var _2b8=this.chart.offsets,dim=this.chart.dim;var w=Math.max(0,dim.width-_2b8.l-_2b8.r),h=Math.max(0,dim.height-_2b8.t-_2b8.b);this.group.setClip({x:_2b8.l,y:_2b8.t,width:w,height:h});if(!this._clippedGroup){this._clippedGroup=this.group.createGroup();}}},purgeGroup:function(){this.inherited(arguments);this._clippedGroup=null;},getGroup:function(){return this._clippedGroup||this.group;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},toPage:function(_2b9){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromModel(sh),tv=sv.scaler.getTransformerFromModel(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_2ba){var r={};r.x=th(_2ba[ah.name])+c.x+o.l;r.y=c.y+dim.height-o.b-tv(_2ba[av.name]);return r;};return _2b9?t(_2b9):t;},toData:function(_2bb){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromPlot(sh),tv=sv.scaler.getTransformerFromPlot(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_2bc){var r={};r[ah.name]=th(_2bc.x-c.x-o.l);r[av.name]=tv(c.y+dim.height-_2bc.y-o.b);return r;};return _2bb?t(_2bb):t;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},createLabel:function(_2bd,_2be,bbox,_2bf){if(this.opt.labels){var x,y,_2c0=this.opt.labelFunc?this.opt.labelFunc.apply(this,[_2be,this.opt.fixed,this.opt.precision]):this._getLabel(isNaN(_2be.y)?_2be:_2be.y);if(this.opt.labelStyle=="inside"){var lbox=gfx._base._getTextBox(_2c0,{font:_2bf.series.font});x=bbox.x+bbox.width/2;y=bbox.y+bbox.height/2+lbox.h/4;if(lbox.w>bbox.width||lbox.h>bbox.height){return;}}else{x=bbox.x+bbox.width/2;y=bbox.y-this.opt.labelOffset;}this.renderLabel(_2bd,x,y,_2c0,_2bf,this.opt.labelStyle=="inside");}},performZoom:function(dim,_2c1){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_2c2=dim.height-_2c1.b,_2c3=this._hScaler.bounds,_2c4=(_2c3.from-_2c3.lower)*_2c3.scale,_2c5=this._vScaler.bounds,_2c6=(_2c5.from-_2c5.lower)*_2c5.scale,_2c7=vs/this.lastWindow.vscale,_2c8=hs/this.lastWindow.hscale,_2c9=(this.lastWindow.xoffset-_2c4)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_2ca=(_2c6-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_2cb=this.getGroup(),anim=fx.animateTransform(lang.delegate({shape:_2cb,duration:1200,transform:[{name:"translate",start:[0,0],end:[_2c1.l*(1-_2c8),_2c2*(1-_2c7)]},{name:"scale",start:[1,1],end:[_2c8,_2c7]},{name:"original"},{name:"translate",start:[0,0],end:[_2c9,_2ca]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_2c4,yoffset:_2c6});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},initializeScalers:function(dim,_2cc){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_2cc.hmin,_2cc.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_2b2.buildScaler(_2cc.hmin,_2cc.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_2cc.vmin,_2cc.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_2b2.buildScaler(_2cc.vmin,_2cc.vmax,dim.height);}return this;},isNullValue:function(_2cd){if(_2cd===null||typeof _2cd=="undefined"){return true;}var h=this._hAxis?this._hAxis.isNullValue:_2b3,v=this._vAxis?this._vAxis.isNullValue:_2b3;if(typeof _2cd=="number"){return h(1)||v(_2cd);}return h(isNaN(_2cd.x)?1:_2cd.x)||_2cd.y===null||v(_2cd.y);}});});},"dojox/charting/plot2d/Base":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojox/gfx","../Element","./common","../axis2d/common","dojo/has"],function(_2ce,arr,lang,gfx,_2cf,_2d0,ac,has){var Base=_2ce("dojox.charting.plot2d.Base",_2cf,{constructor:function(_2d1,_2d2){if(_2d2&&_2d2.tooltipFunc){this.tooltipFunc=_2d2.tooltipFunc;}},clear:function(){this.series=[];this.dirty=true;return this;},setAxis:function(axis){return this;},assignAxes:function(axes){arr.forEach(this.axes,function(axis){if(this[axis]){this.setAxis(axes[this[axis]]);}},this);},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _2d0.collectSimpleStats(this.series,lang.hitch(this,"isNullValue"));},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},initializeScalers:function(){return this;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},render:function(dim,_2d3){return this;},renderLabel:function(_2d4,x,y,_2d5,_2d6,_2d7,_2d8){var elem=ac.createText[this.opt.htmlLabels&&gfx.renderer!="vml"?"html":"gfx"](this.chart,_2d4,x,y,_2d8?_2d8:"middle",_2d5,_2d6.series.font,_2d6.series.fontColor);if(_2d7){if(this.opt.htmlLabels&&gfx.renderer!="vml"){elem.style.pointerEvents="none";}else{if(elem.rawNode){elem.rawNode.style.pointerEvents="none";}}}if(this.opt.htmlLabels&&gfx.renderer!="vml"){this.htmlElements.push(elem);}return elem;},getRequiredColors:function(){return this.series.length;},_getLabel:function(_2d9){return _2d0.getLabel(_2d9,this.opt.fixed,this.opt.precision);}});if(has("dojo-bidi")){Base.extend({_checkOrientation:function(_2da,dim,_2db){this.chart.applyMirroring(this.group,dim,_2db);}});}return Base;});},"dojox/charting/scaler/primitive":function(){define(["dojo/_base/lang"],function(lang){var _2dc=lang.getObject("dojox.charting.scaler.primitive",true);return lang.mixin(_2dc,{buildScaler:function(min,max,span,_2dd){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:span/(max-min),span:span},scaler:_2dc};},buildTicks:function(_2de,_2df){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_2e0){var _2e1=_2e0.bounds.from,_2e2=_2e0.bounds.scale;return function(x){return (x-_2e1)*_2e2;};},getTransformerFromPlot:function(_2e3){var _2e4=_2e3.bounds.from,_2e5=_2e3.bounds.scale;return function(x){return x/_2e5+_2e4;};}});});},"dojox/gfx/fx":function(){define(["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect","dojo/sniff"],function(lang,g,m,_2e6,arr,fx,Hub,has){var fxg=g.fx={};function _2e7(_2e8,end){this.start=_2e8,this.end=end;};_2e7.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _2e9(_2ea,end,_2eb){this.start=_2ea,this.end=end;this.units=_2eb;};_2e9.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _2ec(_2ed,end){this.start=_2ed,this.end=end;this.temp=new _2e6();};_2ec.prototype.getValue=function(r){return _2e6.blendColors(this.start,this.end,r,this.temp);};function _2ee(_2ef){this.values=_2ef;this.length=_2ef.length;};_2ee.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _2f0(_2f1,def){this.values=_2f1;this.def=def?def:{};};_2f0.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _2f2(_2f3,_2f4){this.stack=_2f3;this.original=_2f4;};_2f2.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(t.name=="matrix"){if((t.start instanceof m.Matrix2D)&&(t.end instanceof m.Matrix2D)){var _2f5=new m.Matrix2D();for(var p in t.start){_2f5[p]=(t.end[p]-t.start[p])*r+t.start[p];}ret.push(_2f5);}return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_2f6=f.apply(m,val);if(_2f6 instanceof m.Matrix2D){ret.push(_2f6);}},this);return ret;};var _2f7=new _2e6(0,0,0,0);function _2f8(prop,obj,name,def){if(prop.values){return new _2ee(prop.values);}var _2f9,_2fa,end;if(prop.start){_2fa=g.normalizeColor(prop.start);}else{_2fa=_2f9=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_2f9){_2f9=obj?(name?obj[name]:obj):def;}end=_2f9;}return new _2ec(_2fa,end);};function _2fb(prop,obj,name,def){if(prop.values){return new _2ee(prop.values);}var _2fc,_2fd,end;if(prop.start){_2fd=prop.start;}else{_2fd=_2fc=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _2fc!="number"){_2fc=obj?obj[name]:def;}end=_2fc;}return new _2e7(_2fd,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_2fe=args.shape,_2ff;Hub.connect(anim,"beforeBegin",anim,function(){_2ff=_2fe.getStroke();var prop=args.color,_300={},_301,_302,end;if(prop){_300.color=_2f8(prop,_2ff,"color",_2f7);}prop=args.style;if(prop&&prop.values){_300.style=new _2ee(prop.values);}prop=args.width;if(prop){_300.width=_2fb(prop,_2ff,"width",1);}prop=args.cap;if(prop&&prop.values){_300.cap=new _2ee(prop.values);}prop=args.join;if(prop){if(prop.values){_300.join=new _2ee(prop.values);}else{_302=prop.start?prop.start:(_2ff&&_2ff.join||0);end=prop.end?prop.end:(_2ff&&_2ff.join||0);if(typeof _302=="number"&&typeof end=="number"){_300.join=new _2e7(_302,end);}}}this.curve=new _2f0(_300,_2ff);});Hub.connect(anim,"onAnimate",_2fe,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_303=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=_303.getFill();var prop=args.color,_304={};if(prop){this.curve=_2f8(prop,fill,"",_2f7);}});Hub.connect(anim,"onAnimate",_303,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_305=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=_305.getFont();var prop=args.style,_306={},_307,_308,end;if(prop&&prop.values){_306.style=new _2ee(prop.values);}prop=args.variant;if(prop&&prop.values){_306.variant=new _2ee(prop.values);}prop=args.weight;if(prop&&prop.values){_306.weight=new _2ee(prop.values);}prop=args.family;if(prop&&prop.values){_306.family=new _2ee(prop.values);}prop=args.size;if(prop&&prop.units){_308=parseFloat(prop.start?prop.start:(_305.font&&_305.font.size||"0"));end=parseFloat(prop.end?prop.end:(_305.font&&_305.font.size||"0"));_306.size=new _2e9(_308,end,prop.units);}this.curve=new _2f0(_306,font);});Hub.connect(anim,"onAnimate",_305,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_309=args.shape,_30a;Hub.connect(anim,"beforeBegin",anim,function(){_30a=_309.getTransform();this.curve=new _2f2(args.transform,_30a);});Hub.connect(anim,"onAnimate",_309,"setTransform");if(g.renderer==="svg"&&(has("ie")>=9||has("ff"))){var _30b=[Hub.connect(anim,"onBegin",anim,function(){var _30c=_309.getParent();while(_30c&&_30c.getParent){_30c=_30c.getParent();}if(_30c){_309.__svgContainer=_30c.rawNode.parentNode;_309.__svgRoot=_30c.rawNode;if(_309.__svgRoot&&_309.__svgRoot.getAttribute){_309.__svgWidth=parseInt(_309.__svgRoot.getAttribute("width"),10);if(isNaN(_309.__svgWidth)){delete _309.__svgWidth;}}}}),Hub.connect(anim,"onAnimate",anim,function(){try{if(_309.__svgContainer){var ov=_309.__svgContainer.style.visibility;_309.__svgContainer.style.visibility="visible";var _30d=_309.__svgContainer.offsetHeight;_309.__svgContainer.style.visibility=ov;var _30e=_309.__svgWidth;if(!isNaN(_30e)){try{_309.__svgRoot.setAttribute("width",_30e-0.000005);_309.__svgRoot.setAttribute("width",_30e);}catch(ignore){}}}}catch(e){}}),Hub.connect(anim,"onEnd",anim,function(){arr.forEach(_30b,Hub.disconnect);if(_309.__svgContainer){var sn=_309.__svgContainer;if(sn.getAttribute("__gotVis")==null){sn.setAttribute("__gotVis",true);var ov=_309.__svgContainer.style.visibility;var root=_309.__svgRoot;var _30f=_309.__svgWidth;sn.style.visibility="visible";setTimeout(function(){try{sn.style.visibility=ov;sn.removeAttribute("__gotVis");sn=null;try{if(!isNaN(_30f)){root.setAttribute("width",_30f-0.000005);root.setAttribute("width",_30f);}}catch(ignore){}}catch(e){}},100);}}delete _309.__svgContainer;delete _309.__svgRoot;delete _309.__svgWidth;})];}return anim;};return fxg;});},"dojox/charting/plot2d/_PlotEvents":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(lang,arr,_310,hub){return _310("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=lang.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";arr.forEach(this.chart.stack,function(plot){if(plot!==this&&plot.plotEvent){t.plot=plot;plot.plotEvent(t);}},this);},connect:function(_311,_312){this.dirty=true;return hub.connect(this,"plotEvent",_311,_312);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){arr.forEach(this._shapeEvents,function(item){item.shape.disconnect(item.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_313){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_313,this,function(e){o.type=_313;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_314){var a=this._eventSeries[_314];if(a){arr.forEach(a,this._connectEvents,this);}},fireEvent:function(_315,_316,_317,_318){var s=this._eventSeries[_315];if(s&&s.length&&_317<s.length){var o=s[_317];o.type=_316;o.event=_318||null;this.raiseEvent(o);o.event=null;}}});});},"dojox/charting/plot2d/ClusteredColumns":function(){define(["dojo/_base/declare","dojo/_base/array","./Columns","./common"],function(_319,_31a,_31b,dc){return _319("dojox.charting.plot2d.ClusteredColumns",_31b,{getBarProperties:function(){var _31c=this.series.length;_31a.forEach(this.series,function(_31d){if(_31d.hidden){_31c--;}});var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,_31c);return {gap:f.gap,width:f.size,thickness:f.size,clusterSize:_31c};}});});},"dojox/charting/plot2d/Columns":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_31e,has,_31f,_320,dc,df,du,fx){var _321=function(){return false;};return _31e("dojox.charting.plot2d.Columns",[_31f,_320],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_322,_323){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_323);du.updateWithPattern(this.opt,_323,this.optionalParams);this.animate=this.opt.animate;this.renderingOptions={"shape-rendering":"crispEdges"};},getSeriesStats:function(){var _324=dc.collectSimpleStats(this.series,lang.hitch(this,"isNullValue"));_324.hmin-=0.5;_324.hmax+=0.5;return _324;},createRect:function(run,_325,_326){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_326);_325.add(rect);}else{rect=_325.createRect(_326);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_327){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_327);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,dc.purgeGroup);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_328=Math.max(this._vScaler.bounds.lower,this._vAxis?this._vAxis.naturalBaseline:0),_329=vt(_328),_32a=this.events(),bar=this.getBarProperties();var z=0;var _32b=this.extractValues(this._hScaler);_32b=this.rearrangeValues(_32b,vt,_329);for(var i=0;i<this.series.length;i++){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _32c=t.next("column",[this.opt,run]),_32d=new Array(run.data.length);if(run.hidden){run.dyn.fill=_32c.series.fill;continue;}s=run.group;var _32e=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_32e?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0;var max=_32e?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _32f=run.data[j];if(!this.isNullValue(_32f)){var val=this.getValue(_32f,j,i,_32e),vv=vt(val.y),h=_32b[i][j],_330,_331;if(this.opt.styleFunc||typeof _32f!="number"){var _332=typeof _32f!="number"?[_32f]:[];if(this.opt.styleFunc){_332.push(this.opt.styleFunc(_32f));}_330=t.addMixin(_32c,"column",_332,true);}else{_330=t.post(_32c,"column");}if(bar.width>=1){var rect={x:_327.l+ht(val.x+0.5)+bar.gap+bar.thickness*z,y:dim.height-_327.b-_329-Math.max(h,0),width:bar.width,height:Math.abs(h)};if(_330.series.shadow){var _333=lang.clone(rect);_333.x+=_330.series.shadow.dx;_333.y+=_330.series.shadow.dy;_331=this.createRect(run,s,_333).setFill(_330.series.shadow.color).setStroke(_330.series.shadow);if(this.animate){this._animateColumn(_331,dim.height-_327.b+_329,h);}}var _334=this._plotFill(_330.series.fill,dim,_327);_334=this._shapeFill(_334,rect);var _335=this.createRect(run,s,rect).setFill(_334).setStroke(_330.series.stroke);this.overrideShape(_335,{index:j,value:val});if(_335.setFilter&&_330.series.filter){_335.setFilter(_330.series.filter);}run.dyn.fill=_335.getFill();run.dyn.stroke=_335.getStroke();if(_32a){var o={element:"column",index:j,run:run,shape:_335,shadow:_331,cx:val.x+0.5,cy:val.y,x:_32e?j:run.data[j].x,y:_32e?run.data[j]:run.data[j].y};this._connectEvents(o);_32d[j]=o;}if(!isNaN(val.py)&&val.py>_328){rect.height=h-vt(val.py);}this.createLabel(s,_32f,rect,_330);if(this.animate){this._animateColumn(_335,dim.height-_327.b-_329,h);}}}}this._eventSeries[run.name]=_32d;run.dirty=false;z++;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_327);}return this;},getValue:function(_336,j,_337,_338){var y,x;if(_338){if(typeof _336=="number"){y=_336;}else{y=_336.y;}x=j;}else{y=_336.y;x=_336.x-1;}return {x:x,y:y};},extractValues:function(_339){var _33a=[];for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}var _33b=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));}),min=_33b?Math.max(0,Math.floor(_339.bounds.from-1)):0,max=_33b?Math.min(run.data.length,Math.ceil(_339.bounds.to)):run.data.length,_33c=_33a[i]=[];_33c.min=min;_33c.max=max;for(var j=min;j<max;++j){var _33d=run.data[j];_33c[j]=this.isNullValue(_33d)?0:(typeof _33d=="number"?_33d:_33d.y);}}return _33a;},rearrangeValues:function(_33e,_33f,_340){for(var i=0,n=_33e.length;i<n;++i){var _341=_33e[i];if(_341){for(var j=_341.min,k=_341.max;j<k;++j){var _342=_341[j];_341[j]=this.isNullValue(_342)?0:_33f(_342)-_340;}}}return _33e;},isNullValue:function(_343){if(_343===null||typeof _343=="undefined"){return true;}var h=this._hAxis?this._hAxis.isNullValue:_321,v=this._vAxis?this._vAxis.isNullValue:_321;if(typeof _343=="number"){return v(0.5)||h(_343);}return v(isNaN(_343.x)?0.5:_343.x+0.5)||_343.y===null||h(_343.y);},getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);return {gap:f.gap,width:f.size,thickness:0};},_animateColumn:function(_344,_345,_346){if(_346===0){_346=1;}fx.animateTransform(lang.delegate({shape:_344,duration:1200,transform:[{name:"translate",start:[0,_345-(_345/_346)],end:[0,0]},{name:"scale",start:[1,1/_346],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/plot2d/Default":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/utils","dojox/gfx/fx"],function(lang,_347,arr,has,_348,_349,dc,df,du,fx){var _34a=1200;return _347("dojox.charting.plot2d.Default",[_348,_349],{defaultParams:{lines:true,areas:false,markers:false,tension:"",animate:false,enableCache:false,interpolate:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",marker:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:"",zeroLine:0},constructor:function(_34b,_34c){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_34c);du.updateWithPattern(this.opt,_34c,this.optionalParams);this.animate=this.opt.animate;},createPath:function(run,_34d,_34e){var path;if(this.opt.enableCache&&run._pathFreePool.length>0){path=run._pathFreePool.pop();path.setShape(_34e);_34d.add(path);}else{path=_34d.createPath(_34e);}if(this.opt.enableCache){run._pathUsePool.push(path);}return path;},buildSegments:function(i,_34f){var run=this.series[i],min=_34f?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_34f?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length,rseg=null,_350=[];for(var j=min;j<max;j++){if(!this.isNullValue(run.data[j])){if(!rseg){rseg=[];_350.push({index:j,rseg:rseg});}rseg.push((_34f&&run.data[j].hasOwnProperty("y"))?run.data[j].y:run.data[j]);}else{if(!this.opt.interpolate||_34f){rseg=null;}}}return _350;},render:function(dim,_351){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_351);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,dc.purgeGroup);this._eventSeries={};this.cleanGroup();this.getGroup().setTransform(null);s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_352,_353,_354=this.events();for(var i=0;i<this.series.length;i++){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._pathFreePool=(run._pathFreePool?run._pathFreePool:[]).concat(run._pathUsePool?run._pathUsePool:[]);run._pathUsePool=[];}if(!run.data.length){run.dirty=false;t.skip();continue;}var _355=t.next(this.opt.areas?"area":"line",[this.opt,run],true),_356,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_357=this._eventSeries[run.name]=new Array(run.data.length);s=run.group;if(run.hidden){if(this.opt.lines){run.dyn.stroke=_355.series.stroke;}if(run.markers||(run.markers===undefined&&this.opt.markers)){run.dyn.markerFill=_355.marker.fill;run.dyn.markerStroke=_355.marker.stroke;run.dyn.marker=_355.symbol;}if(this.opt.areas){run.dyn.fill=_355.series.fill;}continue;}var _358=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var _359=this.buildSegments(i,_358);for(var seg=0;seg<_359.length;seg++){var _35a=_359[seg];if(_358){_356=arr.map(_35a.rseg,function(v,i){return {x:ht(i+_35a.index+1)+_351.l,y:dim.height-_351.b-vt(v),data:v};},this);}else{_356=arr.map(_35a.rseg,function(v){return {x:ht(v.x)+_351.l,y:dim.height-_351.b-vt(v.y),data:v};},this);}if(_358&&this.opt.interpolate){while(seg<_359.length){seg++;_35a=_359[seg];if(_35a){_356=_356.concat(arr.map(_35a.rseg,function(v,i){return {x:ht(i+_35a.index+1)+_351.l,y:dim.height-_351.b-vt(v),data:v};},this));}}}var _35b=this.opt.tension?dc.curve(_356,this.opt.tension):"";if(this.opt.areas&&_356.length>1){var fill=this._plotFill(_355.series.fill,dim,_351),_35c=lang.clone(_356),_35d=dim.height-_351.b;if(!isNaN(this.opt.zeroLine)){_35d=Math.max(_351.t,Math.min(dim.height-_351.b-vt(this.opt.zeroLine),_35d));}if(this.opt.tension){var _35e="L"+_35c[_35c.length-1].x+","+_35d+" L"+_35c[0].x+","+_35d+" L"+_35c[0].x+","+_35c[0].y;run.dyn.fill=s.createPath(_35b+" "+_35e).setFill(fill).getFill();}else{_35c.push({x:_356[_356.length-1].x,y:_35d});_35c.push({x:_356[0].x,y:_35d});_35c.push(_356[0]);run.dyn.fill=s.createPolyline(_35c).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_352=_355.series.stroke;if(_355.series.outline){_353=run.dyn.outline=dc.makeStroke(_355.series.outline);_353.width=2*_353.width+(_352&&_352.width||0);}}if(this.opt.markers){run.dyn.marker=_355.symbol;}var _35f=null,_360=null,_361=null;if(_352&&_355.series.shadow&&_356.length>1){var _362=_355.series.shadow,_363=arr.map(_356,function(c){return {x:c.x+_362.dx,y:c.y+_362.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_363,this.opt.tension)).setStroke(_362).getStroke();}else{run.dyn.shadow=s.createPolyline(_363).setStroke(_362).getStroke();}}if(this.opt.markers&&_355.marker.shadow){_362=_355.marker.shadow;_361=arr.map(_363,function(c){return this.createPath(run,s,"M"+c.x+" "+c.y+" "+_355.symbol).setStroke(_362).setFill(_362.color);},this);}}if(this.opt.lines&&_356.length>1){var _364;if(_353){if(this.opt.tension){run.dyn.outline=s.createPath(_35b).setStroke(_353).getStroke();}else{run.dyn.outline=s.createPolyline(_356).setStroke(_353).getStroke();}}if(this.opt.tension){run.dyn.stroke=(_364=s.createPath(_35b)).setStroke(_352).getStroke();}else{run.dyn.stroke=(_364=s.createPolyline(_356)).setStroke(_352).getStroke();}if(_364.setFilter&&_355.series.filter){_364.setFilter(_355.series.filter);}}var _365=null;if(this.opt.markers){var _366=_355;_35f=new Array(_356.length);_360=new Array(_356.length);_353=null;if(_366.marker.outline){_353=dc.makeStroke(_366.marker.outline);_353.width=2*_353.width+(_366.marker.stroke?_366.marker.stroke.width:0);}arr.forEach(_356,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _367=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_367.push(this.opt.styleFunc(c.data));}_366=t.addMixin(_355,"marker",_367,true);}else{_366=t.post(_355,"marker");}var path="M"+c.x+" "+c.y+" "+_366.symbol;if(_353){_360[i]=this.createPath(run,s,path).setStroke(_353);}_35f[i]=this.createPath(run,s,path).setStroke(_366.marker.stroke).setFill(_366.marker.fill);},this);run.dyn.markerFill=_366.marker.fill;run.dyn.markerStroke=_366.marker.stroke;if(!_365&&this.opt.labels){_365=_35f[0].getBoundingBox();}if(_354){arr.forEach(_35f,function(s,i){var o={element:"marker",index:i+_35a.index,run:run,shape:s,outline:_360[i]||null,shadow:_361&&_361[i]||null,cx:_356[i].x,cy:_356[i].y};if(_358){o.x=i+_35a.index+1;o.y=run.data[i+_35a.index];}else{o.x=_35a.rseg[i].x;o.y=run.data[i+_35a.index].y;}this._connectEvents(o);_357[i+_35a.index]=o;},this);}else{delete this._eventSeries[run.name];}}if(this.opt.labels){var _368=_365?_365.width:2;var _369=_365?_365.height:2;arr.forEach(_356,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _36a=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_36a.push(this.opt.styleFunc(c.data));}_366=t.addMixin(_355,"marker",_36a,true);}else{_366=t.post(_355,"marker");}this.createLabel(s,_35a.rseg[i],{x:c.x-_368/2,y:c.y-_369/2,width:_368,height:_369},_366);},this);}}run.dirty=false;}if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_351);}if(this.animate){var _36b=this.getGroup();fx.animateTransform(lang.delegate({shape:_36b,duration:_34a,transform:[{name:"translate",start:[0,dim.height-_351.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});});},"dojox/charting/plot2d/StackedAreas":function(){define(["dojo/_base/declare","./Stacked"],function(_36c,_36d){return _36c("dojox.charting.plot2d.StackedAreas",_36d,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojox/charting/plot2d/Stacked":function(){define(["dojo/_base/declare","dojo/_base/lang","./Default","./commonStacked"],function(_36e,lang,_36f,_370){return _36e("dojox.charting.plot2d.Stacked",_36f,{getSeriesStats:function(){var _371=_370.collectStats(this.series,lang.hitch(this,"isNullValue"));return _371;},buildSegments:function(i,_372){var run=this.series[i],min=_372?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_372?Math.min(run.data.length-1,Math.ceil(this._hScaler.bounds.to)):run.data.length-1,rseg=null,_373=[],_374=lang.hitch(this,"isNullValue");for(var j=min;j<=max;j++){var _375=_372?_370.getIndexValue(this.series,i,j,_374):_370.getValue(this.series,i,run.data[j]?run.data[j].x:null,_374);if(!_374(_375[0])&&(_372||_375[0].y!=null)){if(!rseg){rseg=[];_373.push({index:j,rseg:rseg});}rseg.push(_375[0]);}else{if(!this.opt.interpolate||_372){rseg=null;}}}return _373;}});});},"dojox/charting/plot2d/commonStacked":function(){define(["dojo/_base/lang","dojox/lang/functional","./common"],function(lang,df,_376){var _377=lang.getObject("dojox.charting.plot2d.commonStacked",true);return lang.mixin(_377,{collectStats:function(_378,_379){var _37a=lang.delegate(_376.defaultStats);for(var i=0;i<_378.length;++i){var run=_378[i];for(var j=0;j<run.data.length;j++){var x,y;if(run.data[j]!==null){if(typeof run.data[j]=="number"||!run.data[j].hasOwnProperty("x")){y=_377.getIndexValue(_378,i,j,_379)[0];x=j+1;}else{x=run.data[j].x;if(x!==null){y=_377.getValue(_378,i,x,_379)[0];y=y!=null&&y.y?y.y:null;}}_37a.hmin=Math.min(_37a.hmin,x);_37a.hmax=Math.max(_37a.hmax,x);_37a.vmin=Math.min(_37a.vmin,y);_37a.vmax=Math.max(_37a.vmax,y);}}}return _37a;},rearrangeValues:function(_37b,_37c,_37d){var sets=df.filter(_37b,"x"),n=sets.length;if(!n){return _37b;}var _37e={};for(var i=0;i<n;++i){var _37f=sets[i];for(var j=_37f.min,k=_37f.max;j<k;++j){_37f[j]=(_37f[j]||0)+(_37e[j]||0);}_37e=_37f;}for(i=0;i<n;++i){_37f=sets[i];for(j=_37f.min,k=_37f.max;j<k;++j){_37f[j]=this.isNullValue(_37f[j])?0:_37c(_37f[j])-_37d;}}if(this.opt.minWidth){var _380=this.opt.minWidth;for(i=n-1;i;--i){_37f=sets[i];_37e=sets[i-1];for(j=_37f.min,k=_37f.max;j<k;++j){_37f[j]=_37f[j]-_37e[j];}}var min=_37f.min,max=_37f.max;for(var j=min;j<max;++j){var sum=0,_381=0;for(i=0;i<n;++i){var _382=sets[i][j];if(_382>0){sum+=_382;++_381;}}if(sum<=_381*_380){for(i=0;i<n;++i){_382=sets[i][j];if(_382>0){sets[i][j]=_380;}}continue;}var _383=0;for(i=0;i<n;++i){_37f=sets[i];_382=_37f[j];if(_382>0){if(_382<_380){_383+=_380-_382;_37f[j]=_380;}else{if(_383>0){var _384=_37f[j]-_380;if(_384>=_383){_37f[j]-=_383;_383=0;}else{if(_384>0){_37f[j]=_380;_383-=_384;}}}}}}if(_383>0){for(i=n-1;i>=0;--i){_37f=sets[i];_382=_37f[j];if(_382>0){_384=_37f[j]-_380;if(_384>=_383){_37f[j]-=_383;break;}else{if(_384>0){_37f[j]=_380;_383-=_384;}}}}}}for(i=1;i<n;++i){_37f=sets[i];_37e=sets[i-1];for(j=_37f.min,k=_37f.max;j<k;++j){_37f[j]=_37f[j]+_37e[j];}}}return _37b;},getIndexValue:function(_385,i,_386,_387){var _388=0,v,j,_389;for(j=0;j<=i;++j){if(_385[j].hidden){continue;}_389=_388;v=_385[j].data[_386];if(!_387(v)){if(isNaN(v)){v=v.y||0;}_388+=v;}}return [_388,_389];},getValue:function(_38a,i,x,_38b){var _38c=null,j,z,v,_38d;for(j=0;j<=i;++j){if(_38a[j].hidden){continue;}for(z=0;z<_38a[j].data.length;z++){_38d=_38c;v=_38a[j].data[z];if(!_38b(v)){if(v.x==x){if(!_38c){_38c={x:x};}if(v.y!=null){if(_38c.y==null){_38c.y=0;}_38c.y+=v.y;}break;}else{if(v.x>x){break;}}}}}return [_38c,_38d];}});});},"dojox/charting/plot2d/Bubble":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/utils","dojox/gfx/fx"],function(lang,_38e,arr,has,_38f,_390,dc,df,du,fx){return _38e("dojox.charting.plot2d.Bubble",[_38f,_390],{defaultParams:{animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelFunc:null},constructor:function(_391,_392){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_392);du.updateWithPattern(this.opt,_392,this.optionalParams);if(!this.opt.labelFunc){this.opt.labelFunc=function(_393,_394,_395){return this._getLabel(_393.size,_394,_395);};}this.animate=this.opt.animate;},render:function(dim,_396){var s;if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_396);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,dc.purgeGroup);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_397=this.events();for(var i=0;i<this.series.length;i++){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}var _398=t.next("circle",[this.opt,run]),_399=arr.map(run.data,function(v){return v?{x:ht(v.x)+_396.l,y:dim.height-_396.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);if(run.hidden){run.dyn.fill=_398.series.fill;run.dyn.stroke=_398.series.stroke;continue;}s=run.group;var _39a=null,_39b=null,_39c=null,_39d=this.opt.styleFunc;var _39e=function(item){if(_39d){return t.addMixin(_398,"circle",[item,_39d(item)],true);}return t.addMixin(_398,"circle",item,true);};if(_398.series.shadow){_39c=arr.map(_399,function(item,i){if(!this.isNullValue(item)){var _39f=_39e(run.data[i]),_3a0=_39f.series.shadow;var _3a1=s.createCircle({cx:item.x+_3a0.dx,cy:item.y+_3a0.dy,r:item.radius}).setStroke(_3a0).setFill(_3a0.color);if(this.animate){this._animateBubble(_3a1,dim.height-_396.b,item.radius);}return _3a1;}return null;},this);if(_39c.length){run.dyn.shadow=_39c[_39c.length-1].getStroke();}}if(_398.series.outline){_39b=arr.map(_399,function(item,i){if(!this.isNullValue(item)){var _3a2=_39e(run.data[i]),_3a3=dc.makeStroke(_3a2.series.outline);_3a3.width=2*_3a3.width+(_398.series.stroke&&_398.series.stroke.width||0);var _3a4=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_3a3);if(this.animate){this._animateBubble(_3a4,dim.height-_396.b,item.radius);}return _3a4;}return null;},this);if(_39b.length){run.dyn.outline=_39b[_39b.length-1].getStroke();}}_39a=arr.map(_399,function(item,i){if(!this.isNullValue(item)){var _3a5=_39e(run.data[i]),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var _3a6=this._plotFill(_3a5.series.fill,dim,_396);_3a6=this._shapeFill(_3a6,rect);var _3a7=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(_3a6).setStroke(_3a5.series.stroke);if(_3a7.setFilter&&_3a5.series.filter){_3a7.setFilter(_3a5.series.filter);}if(this.animate){this._animateBubble(_3a7,dim.height-_396.b,item.radius);}this.createLabel(s,run.data[i],rect,_3a5);return _3a7;}return null;},this);if(_39a.length){run.dyn.fill=_39a[_39a.length-1].getFill();run.dyn.stroke=_39a[_39a.length-1].getStroke();}if(_397){var _3a8=new Array(_39a.length);arr.forEach(_39a,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:_39b&&_39b[i]||null,shadow:_39c&&_39c[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_399[i].x,cy:_399[i].y,cr:_399[i].radius};this._connectEvents(o);_3a8[i]=o;}},this);this._eventSeries[run.name]=_3a8;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_396);}return this;},_animateBubble:function(_3a9,_3aa,size){fx.animateTransform(lang.delegate({shape:_3a9,duration:1200,transform:[{name:"translate",start:[0,_3aa],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/plot2d/Candlesticks":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/utils","dojox/gfx/fx"],function(lang,_3ab,arr,has,_3ac,_3ad,dc,df,du,fx){return _3ab("dojox.charting.plot2d.Candlesticks",[_3ac,_3ad],{defaultParams:{gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_3ae,_3af){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_3af);du.updateWithPattern(this.opt,_3af,this.optionalParams);this.animate=this.opt.animate;},collectStats:function(_3b0){var _3b1=lang.delegate(dc.defaultStats);for(var i=0;i<_3b0.length;i++){var run=_3b0[i];if(!run.data.length){continue;}var _3b2=_3b1.vmin,_3b3=_3b1.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(!this.isNullValue(val)){var x=val.x||idx+1;_3b1.hmin=Math.min(_3b1.hmin,x);_3b1.hmax=Math.max(_3b1.hmax,x);_3b1.vmin=Math.min(_3b1.vmin,val.open,val.close,val.high,val.low);_3b1.vmax=Math.max(_3b1.vmax,val.open,val.close,val.high,val.low);}},this);}if("ymin" in run){_3b1.vmin=Math.min(_3b2,run.ymin);}if("ymax" in run){_3b1.vmax=Math.max(_3b3,run.ymax);}}return _3b1;},getSeriesStats:function(){var _3b4=this.collectStats(this.series);_3b4.hmin-=0.5;_3b4.hmax+=0.5;return _3b4;},render:function(dim,_3b5){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_3b5);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,dc.purgeGroup);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_3b6,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3b7=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_3b6=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _3b8=t.next("candlestick",[this.opt,run]),_3b9=new Array(run.data.length);if(run.hidden){run.dyn.fill=_3b8.series.fill;run.dyn.stroke=_3b8.series.stroke;continue;}s=run.group;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(!this.isNullValue(v)){var _3ba=t.addMixin(_3b8,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_3b5.l+gap,y=dim.height-_3b5.b,open=vt(v.open),_3bb=vt(v.close),high=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>high){var tmp=high;high=low;low=tmp;}if(_3b6>=1){var _3bc=open>_3bb;var line={x1:_3b6/2,x2:_3b6/2,y1:y-high,y2:y-low},rect={x:0,y:y-Math.max(open,_3bb),width:_3b6,height:Math.max(_3bc?open-_3bb:_3bb-open,1)};var _3bd=s.createGroup();_3bd.setTransform({dx:x,dy:0});var _3be=_3bd.createGroup();_3be.createLine(line).setStroke(_3ba.series.stroke);_3be.createRect(rect).setStroke(_3ba.series.stroke).setFill(_3bc?_3ba.series.fill:"white");if("mid" in v){_3be.createLine({x1:(_3ba.series.stroke?_3ba.series.stroke.width||1:1),x2:_3b6-(_3ba.series.stroke?_3ba.series.stroke.width||1:1),y1:y-mid,y2:y-mid}).setStroke(_3bc?"white":_3ba.series.stroke);}run.dyn.fill=_3ba.series.fill;run.dyn.stroke=_3ba.series.stroke;if(_3b7){var o={element:"candlestick",index:j,run:run,shape:_3be,x:x,y:y-Math.max(open,_3bb),cx:_3b6/2,cy:(y-Math.max(open,_3bb))+(Math.max(_3bc?open-_3bb:_3bb-open,1)/2),width:_3b6,height:Math.max(_3bc?open-_3bb:_3bb-open,1),data:v};this._connectEvents(o);_3b9[j]=o;}}if(this.animate){this._animateCandlesticks(_3bd,y-low,high-low);}}}this._eventSeries[run.name]=_3b9;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3b5);}return this;},tooltipFunc:function(o){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";},_animateCandlesticks:function(_3bf,_3c0,_3c1){fx.animateTransform(lang.delegate({shape:_3bf,duration:1200,transform:[{name:"translate",start:[0,_3c0-(_3c0/_3c1)],end:[0,0]},{name:"scale",start:[1,1/_3c1],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/plot2d/OHLC":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_3c2,has,_3c3,_3c4,dc,df,du,fx){return _3c2("dojox.charting.plot2d.OHLC",[_3c3,_3c4],{defaultParams:{gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_3c5,_3c6){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_3c6);du.updateWithPattern(this.opt,_3c6,this.optionalParams);this.animate=this.opt.animate;},collectStats:function(_3c7){var _3c8=lang.delegate(dc.defaultStats);for(var i=0;i<_3c7.length;i++){var run=_3c7[i];if(!run.data.length){continue;}var _3c9=_3c8.vmin,_3ca=_3c8.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(!this.isNullValue(val)){var x=val.x||idx+1;_3c8.hmin=Math.min(_3c8.hmin,x);_3c8.hmax=Math.max(_3c8.hmax,x);_3c8.vmin=Math.min(_3c8.vmin,val.open,val.close,val.high,val.low);_3c8.vmax=Math.max(_3c8.vmax,val.open,val.close,val.high,val.low);}},this);}if("ymin" in run){_3c8.vmin=Math.min(_3c9,run.ymin);}if("ymax" in run){_3c8.vmax=Math.max(_3ca,run.ymax);}}return _3c8;},getSeriesStats:function(){var _3cb=this.collectStats(this.series);_3cb.hmin-=0.5;_3cb.hmax+=0.5;return _3cb;},render:function(dim,_3cc){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_3cc);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,dc.purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_3cd,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3ce=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_3cd=f.size;for(var i=0;i<this.series.length;i++){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _3cf=t.next("candlestick",[this.opt,run]),s=run.group,_3d0=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(!this.isNullValue(v)){var _3d1=t.addMixin(_3cf,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_3cc.l+gap,y=dim.height-_3cc.b,open=vt(v.open),_3d2=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_3cd>=1){var hl={x1:_3cd/2,x2:_3cd/2,y1:y-high,y2:y-low},op={x1:0,x2:((_3cd/2)+((_3d1.series.stroke?_3d1.series.stroke.width||1:1)/2)),y1:y-open,y2:y-open},cl={x1:((_3cd/2)-((_3d1.series.stroke?_3d1.series.stroke.width||1:1)/2)),x2:_3cd,y1:y-_3d2,y2:y-_3d2};var _3d3=s.createGroup();_3d3.setTransform({dx:x,dy:0});var _3d4=_3d3.createGroup();_3d4.createLine(hl).setStroke(_3d1.series.stroke);_3d4.createLine(op).setStroke(_3d1.series.stroke);_3d4.createLine(cl).setStroke(_3d1.series.stroke);run.dyn.stroke=_3d1.series.stroke;if(_3ce){var o={element:"candlestick",index:j,run:run,shape:_3d4,x:x,y:y-Math.max(open,_3d2),cx:_3cd/2,cy:(y-Math.max(open,_3d2))+(Math.max(open>_3d2?open-_3d2:_3d2-open,1)/2),width:_3cd,height:Math.max(open>_3d2?open-_3d2:_3d2-open,1),data:v};this._connectEvents(o);_3d0[j]=o;}}if(this.animate){this._animateOHLC(_3d3,y-low,high-low);}}}this._eventSeries[run.name]=_3d0;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3cc);}return this;},_animateOHLC:function(_3d5,_3d6,_3d7){fx.animateTransform(lang.delegate({shape:_3d5,duration:1200,transform:[{name:"translate",start:[0,_3d6-(_3d6/_3d7)],end:[0,0]},{name:"scale",start:[1,1/_3d7],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/plot2d/Pie":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-geometry","dojo/_base/Color","./Base","./_PlotEvents","./common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils","dojo/has"],function(lang,arr,_3d8,_3d9,_3da,Base,_3db,dc,g,m,df,du,has){var _3dc=0.2;return _3d8("dojox.charting.plot2d.Pie",[Base,_3db],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0,innerRadius:0,minWidth:0,zeroDataMessage:""},optionalParams:{radius:0,omitLabels:false,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelWiring:{}},constructor:function(_3dd,_3de){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_3de);du.updateWithPattern(this.opt,_3de,this.optionalParams);this.axes=[];this.run=null;this.dyn=[];this.runFilter=[];if(_3de&&_3de.hasOwnProperty("innerRadius")){this._plotSetInnerRadius=true;}},clear:function(){this.inherited(arguments);this.dyn=[];this.run=null;return this;},setAxis:function(axis){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_3df){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this._plotSetInnerRadius&&t&&t.pieInnerRadius){this.opt.innerRadius=t.pieInnerRadius;}var rx=(dim.width-_3df.l-_3df.r)/2,ry=(dim.height-_3df.t-_3df.b)/2,r=Math.min(rx,ry),_3e0="font" in this.opt?this.opt.font:t.axis.tick.titleFont||"",size=_3e0?g.normalizedLength(g.splitFontString(_3e0).size):0,_3e1=this.opt.hasOwnProperty("fontColor")?this.opt.fontColor:t.axis.tick.fontColor,_3e2=m._degToRad(this.opt.startAngle),_3e3=_3e2,_3e4,_3e5,_3e6,_3e7,_3e8,run=this.run.data,_3e9=this.events();var _3ea=lang.hitch(this,function(){var ct=t.clone();var _3eb=df.map(run,function(v){var _3ec=[this.opt,this.run];if(v!==null&&typeof v!="number"){_3ec.push(v);}if(this.opt.styleFunc){_3ec.push(this.opt.styleFunc(v));}return ct.next("slice",_3ec,true);},this);if("radius" in this.opt){r=this.opt.radius<r?this.opt.radius:r;}var _3ed={cx:_3df.l+rx,cy:_3df.t+ry,r:r};var _3ee=new _3da(_3e1);if(this.opt.innerRadius){_3ee.a=0.1;}var ring=this._createRing(s,_3ed).setStroke(_3ee);if(this.opt.innerRadius){ring.setFill(_3ee);}if(this.opt.zeroDataMessage){this.renderLabel(s,_3ed.cx,_3ed.cy+size/3,this.opt.zeroDataMessage,{series:{font:_3e0,fontColor:_3e1}},null,"middle");}this.dyn=[];arr.forEach(run,function(item,i){this.dyn.push({fill:this._plotFill(_3eb[i].series.fill,dim,_3df),stroke:_3eb[i].series.stroke});},this);});if(!this.run&&!this.run.data.ength){_3ea();return this;}if(typeof run[0]=="number"){_3e4=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_3e4,"<= 0")){_3ea();return this;}_3e5=df.map(_3e4,"/this",df.foldl(_3e4,"+",0));if(this.opt.labels){_3e6=arr.map(_3e5,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{_3e4=df.map(run,"x ? Math.max(x.y, 0) : 0");if(!_3e4.length||df.every(_3e4,"<= 0")){_3ea();return this;}_3e5=df.map(_3e4,"/this",df.foldl(_3e4,"+",0));if(this.opt.labels){_3e6=arr.map(_3e5,function(x,i){if(x<0){return "";}var v=run[i];return v.hasOwnProperty("text")?v.text:this._getLabel(x*100)+"%";},this);}}var _3ef=df.map(run,function(v){var _3f0=[this.opt,this.run];if(v!==null&&typeof v!="number"){_3f0.push(v);}if(this.opt.styleFunc){_3f0.push(this.opt.styleFunc(v));}return t.next("slice",_3f0,true);},this);if(this.opt.labels){_3e7=df.foldl1(df.map(_3e6,function(_3f1,i){var font=_3ef[i].series.font;return g._base._getTextBox(_3f1,{font:font}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_3e7,ry-size)+this.opt.labelOffset;}}if(this.opt.hasOwnProperty("radius")){r=this.opt.radius<r*0.9?this.opt.radius:r*0.9;}if(!this.opt.radius&&this.opt.labels&&this.opt.labelStyle=="columns"){r=r/2;if(rx>ry&&rx>r*2){r*=rx/(r*2);}if(r>=ry*0.8){r=ry*0.8;}}else{if(r>=ry*0.9){r=ry*0.9;}}_3e8=r-this.opt.labelOffset;var _3f2={cx:_3df.l+rx,cy:_3df.t+ry,r:r};this.dyn=[];var _3f3=new Array(_3e5.length);var _3f4=[],_3f5=_3e3;var _3f6=this.opt.minWidth;arr.forEach(_3e5,function(_3f7,i){if(_3f7===0){_3f4[i]={step:0,end:_3f5,start:_3f5,weak:false};return;}var end=_3f5+_3f7*2*Math.PI;if(i===_3e5.length-1){end=_3e2+2*Math.PI;}var step=end-_3f5,dist=step*r;_3f4[i]={step:step,start:_3f5,end:end,weak:dist<_3f6};_3f5=end;});if(_3f6>0){var _3f8=0,_3f9=_3f6/r,_3fa=0,i;for(i=_3f4.length-1;i>=0;i--){if(_3f4[i].weak){++_3f8;_3fa+=_3f4[i].step;_3f4[i].step=_3f9;}}var _3fb=_3f8*_3f9;if(_3fb>Math.PI){_3f9=Math.PI/_3f8;for(i=0;i<_3f4.length;++i){if(_3f4[i].weak){_3f4[i].step=_3f9;}}_3fb=Math.PI;}if(_3f8>0){_3f9=1-(_3fb-_3fa)/2/Math.PI;for(i=0;i<_3f4.length;++i){if(!_3f4[i].weak){_3f4[i].step=_3f9*_3f4[i].step;}}}for(i=0;i<_3f4.length;++i){_3f4[i].start=i?_3f4[i].end:_3f5;_3f4[i].end=_3f4[i].start+_3f4[i].step;}for(i=_3f4.length-1;i>=0;--i){if(_3f4[i].step!==0){_3f4[i].end=_3f5+2*Math.PI;break;}}}_3f5=_3e3;var o,_3fc;arr.some(_3e5,function(_3fd,i){var _3fe;var v=run[i],_3ff=_3ef[i];if(_3fd>=1){_3fc=this._plotFill(_3ff.series.fill,dim,_3df);_3fc=this._shapeFill(_3fc,{x:_3f2.cx-_3f2.r,y:_3f2.cy-_3f2.r,width:2*_3f2.r,height:2*_3f2.r});_3fc=this._pseudoRadialFill(_3fc,{x:_3f2.cx,y:_3f2.cy},_3f2.r);_3fe=this._createRing(s,_3f2).setFill(_3fc).setStroke(_3ff.series.stroke);this.dyn.push({fill:_3fc,stroke:_3ff.series.stroke});if(_3e9){o={element:"slice",index:i,run:this.run,shape:_3fe,x:i,y:typeof v=="number"?v:v.y,cx:_3f2.cx,cy:_3f2.cy,cr:r};this._connectEvents(o);_3f3[i]=o;}var k;for(k=i+1;k<_3e5.length;k++){_3ff=_3ef[k];this.dyn.push({fill:_3ff.series.fill,stroke:_3ff.series.stroke});}return true;}if(_3f4[i].step===0){this.dyn.push({fill:_3ff.series.fill,stroke:_3ff.series.stroke});return false;}var step=_3f4[i].step,x1=_3f2.cx+r*Math.cos(_3f5),y1=_3f2.cy+r*Math.sin(_3f5),x2=_3f2.cx+r*Math.cos(_3f5+step),y2=_3f2.cy+r*Math.sin(_3f5+step);var _400=m._degToRad(this.opt.fanSize),_401;if(_3ff.series.fill&&_3ff.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&step>_400){var _402=s.createGroup(),_403=Math.ceil(step/_400),_404=step/_403;_3fc=this._shapeFill(_3ff.series.fill,{x:_3f2.cx-_3f2.r,y:_3f2.cy-_3f2.r,width:2*_3f2.r,height:2*_3f2.r});var j,_405,beta,_406,_407,_408,_409;for(j=0;j<_403;++j){_405=_3f5+(j-_3dc)*_404;beta=_3f5+(j+1+_3dc)*_404;_406=j==0?x1:_3f2.cx+r*Math.cos(_405);_407=j==0?y1:_3f2.cy+r*Math.sin(_405);_408=j==_403-1?x2:_3f2.cx+r*Math.cos(beta);_409=j==_403-1?y2:_3f2.cy+r*Math.sin(beta);this._createSlice(_402,_3f2,r,_406,_407,_408,_409,_405,_404).setFill(this._pseudoRadialFill(_3fc,{x:_3f2.cx,y:_3f2.cy},r,_3f5+(j+0.5)*_404,_3f5+(j+0.5)*_404));}_401=_3ff.series.stroke;this._createSlice(_402,_3f2,r,x1,y1,x2,y2,_3f5,step).setStroke(_401);_3fe=_402;}else{_401=_3ff.series.stroke;_3fe=this._createSlice(s,_3f2,r,x1,y1,x2,y2,_3f5,step).setStroke(_401);_3fc=_3ff.series.fill;if(_3fc&&_3fc.type==="radial"){_3fc=this._shapeFill(_3fc,{x:_3f2.cx-_3f2.r,y:_3f2.cy-_3f2.r,width:2*_3f2.r,height:2*_3f2.r});if(this.opt.radGrad==="linear"){_3fc=this._pseudoRadialFill(_3fc,{x:_3f2.cx,y:_3f2.cy},r,_3f5,_3f5+step);}}else{if(_3fc&&_3fc.type==="linear"){var bbox=lang.clone(_3fe.getBoundingBox());if(g.renderer==="svg"){var pos={w:0,h:0};try{pos=_3d9.position(_3fe.rawNode);}catch(ignore){}if(pos.h>bbox.height){bbox.height=pos.h;}if(pos.w>bbox.width){bbox.width=pos.w;}}_3fc=this._plotFill(_3fc,dim,_3df);_3fc=this._shapeFill(_3fc,bbox);}}_3fe.setFill(_3fc);}this.dyn.push({fill:_3fc,stroke:_3ff.series.stroke});if(_3e9){o={element:"slice",index:i,run:this.run,shape:_3fe,x:i,y:typeof v=="number"?v:v.y,cx:_3f2.cx,cy:_3f2.cy,cr:r};this._connectEvents(o);_3f3[i]=o;}_3f5=_3f5+step;return false;},this);if(this.opt.labels){var _40a=has("dojo-bidi")&&this.chart.isRightToLeft();if(this.opt.labelStyle=="default"){_3e3=_3e2;_3f5=_3e3;arr.some(_3e5,function(_40b,i){if(_40b<=0&&!this.opt.minWidth){return false;}var _40c=_3ef[i];if(_40b>=1){this.renderLabel(s,_3f2.cx,_3f2.cy+size/2,_3e6[i],_40c,this.opt.labelOffset>0);return true;}var end=_3e3+_40b*2*Math.PI;if(i+1==_3e5.length){end=_3e2+2*Math.PI;}if(this.opt.omitLabels&&end-_3e3<0.001){return false;}var _40d=_3f5+(_3f4[i].step/2),x=_3f2.cx+_3e8*Math.cos(_40d),y=_3f2.cy+_3e8*Math.sin(_40d)+size/2;this.renderLabel(s,_40a?dim.width-x:x,y,_3e6[i],_40c,this.opt.labelOffset>0);_3f5+=_3f4[i].step;_3e3=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){var _40e=this.opt.omitLabels;_3e3=_3e2;_3f5=_3e3;var _40f=[],_410=0,k;for(k=_3e5.length-1;k>=0;--k){if(_3e5[k]){++_410;}}arr.forEach(_3e5,function(_411,i){var end=_3e3+_411*2*Math.PI;if(i+1==_3e5.length){end=_3e2+2*Math.PI;}if(this.minWidth!==0||end-_3e3>=0.001){var _412=_3f5+(_3f4[i].step/2);if(_410===1&&!this.opt.minWidth){_412=(_3e3+end)/2;}_40f.push({angle:_412,left:Math.cos(_412)<0,theme:_3ef[i],index:i,omit:_40e?end-_3e3<0.001:false});}_3e3=end;_3f5+=_3f4[i].step;},this);var _413=g._base._getTextBox("a",{font:_3e0,whiteSpace:"nowrap"}).h;this._getProperLabelRadius(_40f,_413,_3f2.r*1.1);var _414=_3f2.cx-_3f2.r*2,_415=_3f2.cx+_3f2.r*2;arr.forEach(_40f,function(_416){if(_416.omit){return;}var _417=_3ef[_416.index],_418=0;if(_417&&_417.axis&&_417.axis.tick&&_417.axis.tick.labelGap){_418=_417.axis.tick.labelGap;}var _419=g._base._getTextBox(_3e6[_416.index],{font:_417.series.font,whiteSpace:"nowrap",paddingLeft:_418+"px"}).w,x=_3f2.cx+_416.labelR*Math.cos(_416.angle),y=_3f2.cy+_416.labelR*Math.sin(_416.angle),_41a=(_416.left)?(_414+_419):(_415-_419),_41b=(_416.left)?_414:_41a+_418,_41c=_3f2.r,_41d=s.createPath().moveTo(_3f2.cx+_41c*Math.cos(_416.angle),_3f2.cy+_41c*Math.sin(_416.angle));if(Math.abs(_416.labelR*Math.cos(_416.angle))<_3f2.r*2-_419){_41d.lineTo(x,y);}_41d.lineTo(_41a,y).setStroke(_416.theme.series.labelWiring);_41d.moveToBack();var mid=_413/3+y;var elem=this.renderLabel(s,_41b,mid||0,_3e6[_416.index],_417,false,"left");if(_3e9&&!this.opt.htmlLabels){var _41e=g._base._getTextBox(_3e6[_416.index],{font:_416.theme.series.font}).w||0,_41f=g.normalizedLength(g.splitFontString(_416.theme.series.font).size);o={element:"labels",index:_416.index,run:this.run,shape:elem,x:_41b,y:y,label:_3e6[_416.index]};var shp=elem.getShape(),lt=_3d9.position(this.chart.node,true),_420=lang.mixin({type:"rect"},{x:shp.x,y:shp.y-2*_41f});_420.x+=lt.x;_420.y+=lt.y;_420.x=Math.round(_420.x);_420.y=Math.round(_420.y);_420.width=Math.ceil(_41e);_420.height=Math.ceil(_41f);o.aroundRect=_420;this._connectEvents(o);_3f3[_3e5.length+_416.index]=o;}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_3f3[esi++];});if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3df);}return this;},_getProperLabelRadius:function(_421,_422,_423){if(_421.length==1){_421[0].labelR=_423;return;}var _424={},_425={},_426=2,_427=2,i;var _428;for(i=0;i<_421.length;++i){_428=Math.abs(Math.sin(_421[i].angle));if(_421[i].left){if(_426>_428){_426=_428;_424=_421[i];}}else{if(_427>_428){_427=_428;_425=_421[i];}}}_424.labelR=_425.labelR=_423;this._caculateLabelR(_424,_421,_422);this._caculateLabelR(_425,_421,_422);},_caculateLabelR:function(_429,_42a,_42b){var i,j,k,_42c=_42a.length,_42d=_429.labelR,_42e,step=_42a[_429.index].left?-_42b:_42b;for(k=0,i=_429.index,j=(i+1)%_42c;k<_42c&&_42a[i].left===_42a[j].left;++k){_42e=(Math.sin(_42a[i].angle)*_42d+step)/Math.sin(_42a[j].angle);_42d=Math.max(_429.labelR,_42e);_42a[j].labelR=_42d;i=(i+1)%_42c;j=(j+1)%_42c;}if(k>=_42c){_42a[0].labelR=_429.labelR;}for(k=0,i=_429.index,j=(i||_42c)-1;k<_42c&&_42a[i].left===_42a[j].left;++k){_42e=(Math.sin(_42a[i].angle)*_42d-step)/Math.sin(_42a[j].angle);_42d=Math.max(_429.labelR,_42e);_42a[j].labelR=_42d;i=(i||_42c)-1;j=(j||_42c)-1;}},_createRing:function(_42f,_430){var r=this.opt.innerRadius;if(r>0){r=_430.r*(r/100);}else{if(r<0){r=-r;}}if(r){return _42f.createPath({}).setAbsoluteMode(true).moveTo(_430.cx,_430.cy-_430.r).arcTo(_430.r,_430.r,0,false,true,_430.cx+_430.r,_430.cy).arcTo(_430.r,_430.r,0,true,true,_430.cx,_430.cy-_430.r).closePath().moveTo(_430.cx,_430.cy-r).arcTo(r,r,0,false,true,_430.cx+r,_430.cy).arcTo(r,r,0,true,true,_430.cx,_430.cy-r).closePath();}return _42f.createCircle(_430);},_createSlice:function(_431,_432,R,x1,y1,x2,y2,_433,_434){var r=this.opt.innerRadius;if(r>0){r=_432.r*(r/100);}else{if(r<0){r=-r;}}if(r){var _435=_432.cx+r*Math.cos(_433),_436=_432.cy+r*Math.sin(_433),_437=_432.cx+r*Math.cos(_433+_434),_438=_432.cy+r*Math.sin(_433+_434);return _431.createPath({}).setAbsoluteMode(true).moveTo(_435,_436).lineTo(x1,y1).arcTo(R,R,0,_434>Math.PI,true,x2,y2).lineTo(_437,_438).arcTo(r,r,0,_434>Math.PI,false,_435,_436).closePath();}return _431.createPath({}).setAbsoluteMode(true).moveTo(_432.cx,_432.cy).lineTo(x1,y1).arcTo(R,R,0,_434>Math.PI,true,x2,y2).lineTo(_432.cx,_432.cy).closePath();}});});}}});require(["dojo/_base/window","dojo/dom","dojo/dom-construct","dojo/dom-style","dojo/ready","dojo/on","dojo/query","dojox/charting/Chart","dojox/charting/axis2d/Default","dojox/charting/plot2d/ClusteredBars","dojox/charting/plot2d/ClusteredColumns","dojox/charting/plot2d/Default","dojox/charting/plot2d/StackedAreas","dojox/charting/plot2d/Bubble","dojox/charting/plot2d/Candlesticks","dojox/charting/plot2d/OHLC","dojox/charting/plot2d/Pie"],function(win,dom,_439,_43a,_43b,on,_43c,_43d,_43e,_43f,_440,_441,_442,_443,_444,OHLC,Pie){var _445={},_446,_447,_448,_449="";function _44a(name){var _44b=dom.byId("themeChooser"),_44c=dom.byId("pageStyleChooser").checked;var test=false;if(name){for(var i=0,l=_44b.options.length;i<l;i++){if(_44b.options[i].value==name){_44b.options[i].selected=true;test=true;break;}}}if(!test){name=_44b.options[_44b.selectedIndex].value;}require(["dojox/charting/themes/"+name.replace(".","/")],function(_44d){var _44e=_44d.chart;if(_44c&&_44e.pageStyle){_43a.set(win.body(),_44e.pageStyle);}else{_43a.set(win.body(),{backgroundColor:_447,backgroundImage:_446,color:_448});}if(_449!=name){_449=name;if(_44d){for(var _44f in _445){_445[_44f].setTheme(_44d).render();}}}});};function init(){_446=_43a.get(win.body(),"backgroundImage");_447=_43a.get(win.body(),"backgroundColor");_448=_43a.get(win.body(),"color");_445.bars=new _43d("bars").addAxis("y",{fixLower:"minor",fixUpper:"minor",natural:true}).addAxis("x",{vertical:true,fixLower:"major",fixUpper:"major",includeZero:true}).addPlot("default",{type:_43f,gap:5}).addSeries("Series A",[0.53,0.51]).addSeries("Series B",[0.84,0.79]).addSeries("Series C",[0.68,0.95]).addSeries("Series D",[0.77,0.66]);_445.columns=new _43d("columns").addAxis("x",{fixLower:"minor",fixUpper:"minor",natural:true}).addAxis("y",{vertical:true,fixLower:"major",fixUpper:"major",includeZero:true}).addPlot("default",{type:_440,gap:5}).addSeries("Series A",[0.53,0.51]).addSeries("Series B",[0.84,0.79]).addSeries("Series C",[0.68,0.95]).addSeries("Series D",[0.77,0.66]);_445.lines=new _43d("lines").addAxis("x",{min:0,max:6,fixLower:"minor",fixUpper:"minor",natural:true}).addAxis("y",{vertical:true,fixLower:"major",fixUpper:"major",includeZero:true,max:1}).addPlot("default",{type:_441,lines:true,markers:true,tension:"X"}).addSeries("Series A",[{x:0.5,y:0.2},{x:1.5,y:0.4},{x:2,y:0.1},{x:5,y:0.9}]).addSeries("Series B",[{x:0.3,y:0.6},{x:3,y:0.5},{x:4,y:0.9},{x:5.5,y:0.7}]).addSeries("Series C",[{x:0.8,y:0.8},{x:3.4,y:0.2},{x:5.3,y:0.3}]).addSeries("Series D",[{x:0.6,y:0.9},{x:3.2,y:0.8},{x:5,y:0.1}]);_445.pieFan=new _43d("pieFan").addPlot("default",{type:Pie,radius:60,labelOffset:-20,radGrad:dojox.gfx.renderer=="vml"?"fan":"native"}).addSeries("Series A",[0.35,0.25,0.42,0.53,0.69]);_445.bubbles=new _43d("bubbles").addAxis("x",{min:0,max:6,fixLower:"minor",fixUpper:"minor",natural:true}).addAxis("y",{vertical:true,fixLower:"major",fixUpper:"major",includeZero:true}).addPlot("default",{type:_443}).addSeries("Series A",[{x:0.5,y:5,size:1.4},{x:1.5,y:1.5,size:4.5},{x:2,y:9,size:1.5},{x:5,y:0.3,size:0.8}]).addSeries("Series B",[{x:0.3,y:8,size:2.5},{x:4,y:6,size:2.1},{x:5.5,y:2,size:3.2}]).addSeries("Series C",[{x:2,y:5.5,size:2.5},{x:3.5,y:2.5,size:3.5},{x:5.2,y:7,size:3}]).addSeries("Series D",[{x:3.2,y:8,size:2}]);_445.area=new _43d("area").addAxis("x",{fixLower:"major",fixUpper:"major"}).addAxis("y",{vertical:true,fixLower:"major",fixUpper:"major",min:0}).addPlot("default",{type:_442,tension:"X"}).addSeries("Series A",[-2,1.1,1.2,1.3,1.4,1.5,-1.6]).addSeries("Series B",[1,1.6,1.3,1.4,1.1,1.5,1.1]).addSeries("Series C",[1,1.1,1.2,1.3,1.4,1.5,1.6]);_445.pieLin=new _43d("pieLin").addPlot("default",{type:Pie,radius:60,labelOffset:-20,radGrad:"linear"}).addSeries("Series A",[0.35,0.25,0.42,0.53,0.69]);_445.candle=new _43d("candle").addPlot("default",{type:_444,gap:1}).addAxis("x",{fixLower:"major",fixUpper:"major",includeZero:true}).addAxis("y",{vertical:true,fixLower:"major",fixUpper:"major",natural:true}).addSeries("Series A",[{open:20,close:16,high:22,low:8},{open:16,close:22,high:26,low:6,mid:18},{open:22,close:18,high:22,low:11,mid:21},{open:18,close:29,high:32,low:14,mid:27},{open:29,close:24,high:29,low:13,mid:27},{open:24,close:8,high:24,low:5},{open:8,close:16,high:22,low:2},{open:16,close:12,high:19,low:7},{open:12,close:20,high:22,low:8},{open:20,close:16,high:22,low:8},{open:16,close:22,high:26,low:6,mid:18},{open:22,close:18,high:22,low:11,mid:21},{open:18,close:29,high:32,low:14,mid:27},{open:29,close:24,high:29,low:13,mid:27},{open:24,close:8,high:24,low:5},{open:8,close:16,high:22,low:2},{open:16,close:12,high:19,low:7},{open:12,close:20,high:22,low:8},{open:20,close:16,high:22,low:8},{open:16,close:22,high:26,low:6},{open:22,close:18,high:22,low:11},{open:18,close:29,high:32,low:14},{open:29,close:24,high:29,low:13},{open:24,close:8,high:24,low:5},{open:8,close:16,high:22,low:2},{open:16,close:12,high:19,low:7},{open:12,close:20,high:22,low:8},{open:20,close:16,high:22,low:8}]);_445.ohlc=new _43d("ohlc").addPlot("default",{type:OHLC,gap:1}).addAxis("x",{fixLower:"major",fixUpper:"major",includeZero:true}).addAxis("y",{vertical:true,fixLower:"major",fixUpper:"major",natural:true}).addSeries("Series A",[{open:20,close:16,high:22,low:8},{open:16,close:22,high:26,low:6},{open:22,close:18,high:22,low:11},{open:18,close:29,high:32,low:14},{open:29,close:24,high:29,low:13},{open:24,close:8,high:24,low:5},{open:8,close:16,high:22,low:2},{open:16,close:12,high:19,low:7},{open:12,close:20,high:22,low:8},{open:20,close:16,high:22,low:8},{open:16,close:22,high:26,low:6},{open:22,close:18,high:22,low:11},{open:18,close:29,high:32,low:14},{open:29,close:24,high:29,low:13},{open:24,close:8,high:24,low:5},{open:8,close:16,high:22,low:2},{open:16,close:12,high:19,low:7},{open:12,close:20,high:22,low:8},{open:20,close:16,high:22,low:8},{open:16,close:22,high:26,low:6},{open:22,close:18,high:22,low:11},{open:18,close:29,high:32,low:14},{open:29,close:24,high:29,low:13},{open:24,close:8,high:24,low:5},{open:8,close:16,high:22,low:2},{open:16,close:12,high:19,low:7},{open:12,close:20,high:22,low:8},{open:20,close:16,high:22,low:8}]);var name;if(window.location.search.indexOf("?")>-1){name=window.location.search.substring(1);_439.create("span",{style:"display: inline-block; margin-left: 1em;",innerHTML:"<a href=\"theme_preview-amd.html\">Back to the Theme Previewer &raquo;&raquo;</a>"},_43c("p.controls")[0]);}_44a(name);on(dom.byId("themeChooser"),"change",_44a);on(dom.byId("pageStyleChooser"),"click",_44a);};_43b(init);});