//>>built
require({cache:{"dojox/charting/Chart":function(){define(["../main","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-style","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/sniff","./Element","./SimpleTheme","./Series","./axis2d/common","./plot2d/common","dojox/gfx/shape","dojox/gfx","dojo/has!dojo-bidi?./bidi/Chart","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e,_f,_10,g,_11,_12){var dc=_2.getObject("charting",true,_1),_13={l:10,t:10,r:10,b:10};function _14(_15){return _15.clear();};function _16(_17){return _17.destroy();};function _18(_19){_19.dirty=false;return false;};function _1a(_1b){_1b.dirty=true;return true;};function _1c(_1d){return _1d.name;};var _1e=_4(_a("dojo-bidi")?"dojox.charting.NonBidiChart":"dojox.charting.Chart",null,{constructor:function(_1f,_20){if(!_20){_20={};}this.margins=_20.margins||_13;this._customMargins=!!_20.margins;this.stroke=_20.stroke;this.fill=_20.fill;this.delayInMs=_20.delayInMs||200;this.title=_20.title;this.titleGap=_20.titleGap;this.titlePos=_20.titlePos;this.titleFont=_20.titleFont;this.titleFontColor=_20.titleFontColor;this.titleAlign=_20.titleAlign;this.chartTitle=null;this.htmlLabels=true;if("htmlLabels" in _20){this.htmlLabels=_20.htmlLabels;}this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.node=_6.byId(_1f);var box=_7.getMarginBox(_1f);this.surface=g.createSurface(this.node,box.w||400,box.h||300);if(this.surface.declaredClass.indexOf("vml")==-1){this._nativeClip=true;}},destroy:function(){_3.forEach(this.series,_16);_3.forEach(this.stack,_16);_12.forIn(this.axes,_16);this.surface.destroy();if(this.chartTitle&&this.chartTitle.tagName){_8.destroy(this.chartTitle);}},getCoords:function(){var _21=this.node;var s=_5.getComputedStyle(_21),_22=_7.getMarginBox(_21,s);var abs=_7.position(_21,true);_22.x=abs.x;_22.y=abs.y;return _22;},setTheme:function(_23){this.theme=_23.clone();if(!this._customMargins){this.margins=this.theme.chart.margins||_13;}this.dirty=true;return this;},addAxis:function(_24,_25){var _26,_27=_25&&_25.type||"Default";if(typeof _27=="string"){if(!dc.axis2d||!dc.axis2d[_27]){throw Error("Can't find axis: "+_27+" - Check "+"require() dependencies.");}_26=new dc.axis2d[_27](this,_25);}else{_26=new _27(this,_25);}_26.name=_24;_26.dirty=true;if(_24 in this.axes){this.axes[_24].destroy();}this.axes[_24]=_26;this.dirty=true;return this;},getAxis:function(_28){return this.axes[_28];},removeAxis:function(_29){if(_29 in this.axes){this.axes[_29].destroy();delete this.axes[_29];this.dirty=true;}return this;},addPlot:function(_2a,_2b){var _2c,_2d=_2b&&_2b.type||"Default";if(typeof _2d=="string"){if(!dc.plot2d||!dc.plot2d[_2d]){throw Error("Can't find plot: "+_2d+" - didn't you forget to dojo"+".require() it?");}_2c=new dc.plot2d[_2d](this,_2b);}else{_2c=new _2d(this,_2b);}_2c.name=_2a;_2c.dirty=true;if(_2a in this.plots){this.stack[this.plots[_2a]].destroy();this.stack[this.plots[_2a]]=_2c;}else{this.plots[_2a]=this.stack.length;this.stack.push(_2c);}this.dirty=true;return this;},getPlot:function(_2e){return this.stack[this.plots[_2e]];},removePlot:function(_2f){if(_2f in this.plots){var _30=this.plots[_2f];delete this.plots[_2f];this.stack[_30].destroy();this.stack.splice(_30,1);_12.forIn(this.plots,function(idx,_31,_32){if(idx>_30){_32[_31]=idx-1;}});var ns=_3.filter(this.series,function(run){return run.plot!=_2f;});if(ns.length<this.series.length){_3.forEach(this.series,function(run){if(run.plot==_2f){run.destroy();}});this.runs={};_3.forEach(ns,function(run,_33){this.runs[run.plot]=_33;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return _12.map(this.stack,_1c);},setPlotOrder:function(_34){var _35={},_36=_12.filter(_34,function(_37){if(!(_37 in this.plots)||(_37 in _35)){return false;}_35[_37]=1;return true;},this);if(_36.length<this.stack.length){_12.forEach(this.stack,function(_38){var _39=_38.name;if(!(_39 in _35)){_36.push(_39);}});}var _3a=_12.map(_36,function(_3b){return this.stack[this.plots[_3b]];},this);_12.forEach(_3a,function(_3c,i){this.plots[_3c.name]=i;},this);this.stack=_3a;this.dirty=true;return this;},movePlotToFront:function(_3d){if(_3d in this.plots){var _3e=this.plots[_3d];if(_3e){var _3f=this.getPlotOrder();_3f.splice(_3e,1);_3f.unshift(_3d);return this.setPlotOrder(_3f);}}return this;},movePlotToBack:function(_40){if(_40 in this.plots){var _41=this.plots[_40];if(_41<this.stack.length-1){var _42=this.getPlotOrder();_42.splice(_41,1);_42.push(_40);return this.setPlotOrder(_42);}}return this;},addSeries:function(_43,_44,_45){var run=new _d(this,_44,_45);run.name=_43;if(_43 in this.runs){this.series[this.runs[_43]].destroy();this.series[this.runs[_43]]=run;}else{this.runs[_43]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(_46){return this.series[this.runs[_46]];},removeSeries:function(_47){if(_47 in this.runs){var _48=this.runs[_47];delete this.runs[_47];this.series[_48].destroy();this.series.splice(_48,1);_12.forIn(this.runs,function(idx,_49,_4a){if(idx>_48){_4a[_49]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(_4b,_4c,_4d){if(_4b in this.runs){var run=this.series[this.runs[_4b]];run.update(_4c);if(_4d){this.dirty=true;}else{this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}}return this;},getSeriesOrder:function(_4e){return _12.map(_12.filter(this.series,function(run){return run.plot==_4e;}),_1c);},setSeriesOrder:function(_4f){var _50,_51={},_52=_12.filter(_4f,function(_53){if(!(_53 in this.runs)||(_53 in _51)){return false;}var run=this.series[this.runs[_53]];if(_50){if(run.plot!=_50){return false;}}else{_50=run.plot;}_51[_53]=1;return true;},this);_12.forEach(this.series,function(run){var _54=run.name;if(!(_54 in _51)&&run.plot==_50){_52.push(_54);}});var _55=_12.map(_52,function(_56){return this.series[this.runs[_56]];},this);this.series=_55.concat(_12.filter(this.series,function(run){return run.plot!=_50;}));_12.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(_57){if(_57 in this.runs){var _58=this.runs[_57],_59=this.getSeriesOrder(this.series[_58].plot);if(_57!=_59[0]){_59.splice(_58,1);_59.unshift(_57);return this.setSeriesOrder(_59);}}return this;},moveSeriesToBack:function(_5a){if(_5a in this.runs){var _5b=this.runs[_5a],_5c=this.getSeriesOrder(this.series[_5b].plot);if(_5a!=_5c[_5c.length-1]){_5c.splice(_5b,1);_5c.push(_5a);return this.setSeriesOrder(_5c);}}return this;},resize:function(_5d,_5e){switch(arguments.length){case 1:_7.setMarginBox(this.node,_5d);break;case 2:_7.setMarginBox(this.node,{w:_5d,h:_5e});break;}var box=_7.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;return this.render();}else{return this;}},getGeometry:function(){var ret={};_12.forIn(this.axes,function(_5f){if(_5f.initialized()){ret[_5f.name]={name:_5f.name,vertical:_5f.vertical,scaler:_5f.scaler,ticks:_5f.ticks};}});return ret;},setAxisWindow:function(_60,_61,_62,_63){var _64=this.axes[_60];if(_64){_64.setWindow(_61,_62);_3.forEach(this.stack,function(_65){if(_65.hAxis==_60||_65.vAxis==_60){_65.zoom=_63;}});}return this;},setWindow:function(sx,sy,dx,dy,_66){if(!("plotArea" in this)){this.calculateGeometry();}_12.forIn(this.axes,function(_67){var _68,_69,_6a=_67.getScaler().bounds,s=_6a.span/(_6a.upper-_6a.lower);if(_67.vertical){_68=sy;_69=dy/s/_68;}else{_68=sx;_69=dx/s/_68;}_67.setWindow(_68,_69);});_3.forEach(this.stack,function(_6b){_6b.zoom=_66;});return this;},zoomIn:function(_6c,_6d,_6e){var _6f=this.axes[_6c];if(_6f){var _70,_71,_72=_6f.getScaler().bounds;var _73=Math.min(_6d[0],_6d[1]);var _74=Math.max(_6d[0],_6d[1]);_73=_6d[0]<_72.lower?_72.lower:_73;_74=_6d[1]>_72.upper?_72.upper:_74;_70=(_72.upper-_72.lower)/(_74-_73);_71=_73-_72.lower;this.setAxisWindow(_6c,_70,_71);if(_6e){this.delayedRender();}else{this.render();}}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _75=_3.filter(this.stack,function(_76){return _76.dirty||(_76.hAxis&&this.axes[_76.hAxis].dirty)||(_76.vAxis&&this.axes[_76.vAxis].dirty);},this);_77(_75,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();_3.forEach(this.stack,_14);if(!this.theme){this.setTheme(new _c());}_3.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var _78=new dc.plot2d.Default(this,{});_78.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(_78);}this.stack[this.plots[run.plot]].addSeries(run);},this);_3.forEach(this.stack,function(_79){if(_79.assignAxes){_79.assignAxes(this.axes);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);_12.forIn(this.axes,_14);_77(this.stack,dim);var _7a=this.offsets={l:0,r:0,t:0,b:0};var _7b=this;_12.forIn(this.axes,function(_7c){if(_a("dojo-bidi")){_7b._resetLeftBottom(_7c);}_12.forIn(_7c.getOffsets(),function(o,i){_7a[i]=Math.max(o,_7a[i]);});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";this.titleAlign=this.titleAlign||this.theme&&this.theme.chart&&this.theme.chart.titleAlign||"middle";var _7d=g.normalizedLength(g.splitFontString(this.titleFont).size);_7a[this.titlePos=="top"?"t":"b"]+=(_7d+this.titleGap);}_12.forIn(this.margins,function(o,i){_7a[i]+=o;});this.plotArea={width:dim.width-_7a.l-_7a.r,height:dim.height-_7a.t-_7a.b};_12.forIn(this.axes,_14);_77(this.stack,this.plotArea);return this;},render:function(){if(this._delayedRenderHandle){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;}if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();_12.forEachRev(this.stack,function(_7e){_7e.render(this.dim,this.offsets);},this);_12.forIn(this.axes,function(_7f){_7f.render(this.dim,this.offsets);},this);this._makeClean();return this;},fullRender:function(){this.fullGeometry();var _80=this.offsets,dim=this.dim;var w=Math.max(0,dim.width-_80.l-_80.r),h=Math.max(0,dim.height-_80.t-_80.b);_3.forEach(this.series,_f.purgeGroup);_12.forIn(this.axes,_f.purgeGroup);_3.forEach(this.stack,_f.purgeGroup);var _81=this.surface.children;if(_10.dispose){for(var i=0;i<_81.length;++i){_10.dispose(_81[i]);}}if(this.chartTitle&&this.chartTitle.tagName){_8.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;this._renderChartBackground(dim,_80);if(this._nativeClip){this._renderPlotBackground(dim,_80,w,h);}else{this._renderPlotBackground(dim,_80,w,h);}_12.foldr(this.stack,function(z,_82){return _82.render(dim,_80),0;},0);if(!this._nativeClip){this._renderChartBackground(dim,_80);}if(this.title){this._renderTitle(dim,_80);}_12.forIn(this.axes,function(_83){_83.render(dim,_80);});this._makeClean();return this;},_renderTitle:function(dim,_84){var _85=(g.renderer=="canvas")&&this.htmlLabels,_86=_85||!_a("ie")&&!_a("opera")&&this.htmlLabels?"html":"gfx",_87=g.normalizedLength(g.splitFontString(this.titleFont).size),_88=g._base._getTextBox(this.title,{font:this.titleFont});var _89=this.titleAlign;var _8a=_a("dojo-bidi")&&this.isRightToLeft();var _8b=dim.width/2;if(_89==="edge"){_89="left";if(_8a){_8b=dim.width-(_84.r+_88.w);}else{_8b=_84.l;}}else{if(_89!="middle"){if(_8a){_89=_89==="left"?"right":"left";}if(_89==="left"){_8b=this.margins.l;}else{if(_89==="right"){_89="left";_8b=dim.width-(this.margins.l+_88.w);}}}}this.chartTitle=_e.createText[_86](this,this.surface,_8b,this.titlePos=="top"?_87+this.margins.t:dim.height-this.margins.b,_89,this.title,this.titleFont,this.titleFontColor);},_renderChartBackground:function(dim,_8c){var t=this.theme,_8d;var _8e=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);var _8f=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(_8e=="inherit"){var _90=this.node;_8e=new _9(_5.get(_90,"backgroundColor"));while(_8e.a==0&&_90!=document.documentElement){_8e=new _9(_5.get(_90,"backgroundColor"));_90=_90.parentNode;}}if(_8e){if(this._nativeClip){_8e=_b.prototype._shapeFill(_b.prototype._plotFill(_8e,dim),{x:0,y:0,width:dim.width+1,height:dim.height+1});this.surface.createRect({width:dim.width+1,height:dim.height+1}).setFill(_8e);}else{_8e=_b.prototype._plotFill(_8e,dim,_8c);if(_8c.l){_8d={x:0,y:0,width:_8c.l,height:dim.height+1};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.r){_8d={x:dim.width-_8c.r,y:0,width:_8c.r+1,height:dim.height+2};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.t){_8d={x:0,y:0,width:dim.width+1,height:_8c.t};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.b){_8d={x:0,y:dim.height-_8c.b,width:dim.width+1,height:_8c.b+2};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}}}if(_8f){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_8f);}},_renderPlotBackground:function(dim,_91,w,h){var t=this.theme;var _92=t.plotarea&&t.plotarea.fill;var _93=t.plotarea&&t.plotarea.stroke;var _94={x:_91.l-1,y:_91.t-1,width:w+2,height:h+2};if(_92){_92=_b.prototype._shapeFill(_b.prototype._plotFill(_92,dim,_91),_94);this.surface.createRect(_94).setFill(_92);}if(_93){this.surface.createRect({x:_91.l,y:_91.t,width:w+1,height:h+1}).setStroke(_93);}},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(_2.hitch(this,function(){this.render();}),this.delayInMs);}return this;},connectToPlot:function(_95,_96,_97){return _95 in this.plots?this.stack[this.plots[_95]].connect(_96,_97):null;},fireEvent:function(_98,_99,_9a){if(_98 in this.runs){var _9b=this.series[this.runs[_98]].plot;if(_9b in this.plots){var _9c=this.stack[this.plots[_9b]];if(_9c){_9c.fireEvent(_98,_99,_9a);}}}return this;},_makeClean:function(){_3.forEach(this.axes,_18);_3.forEach(this.stack,_18);_3.forEach(this.series,_18);this.dirty=false;},_makeDirty:function(){_3.forEach(this.axes,_1a);_3.forEach(this.stack,_1a);_3.forEach(this.series,_1a);this.dirty=true;},_invalidateDependentPlots:function(_9d,_9e){if(_9d in this.plots){var _9f=this.stack[this.plots[_9d]],_a0,_a1=_9e?"vAxis":"hAxis";if(_9f[_a1]){_a0=this.axes[_9f[_a1]];if(_a0&&_a0.dependOnData()){_a0.dirty=true;_3.forEach(this.stack,function(p){if(p[_a1]&&p[_a1]==_9f[_a1]){p.dirty=true;}});}}else{_9f.dirty=true;}}},setDir:function(dir){return this;},_resetLeftBottom:function(_a2){},formatTruncatedLabel:function(_a3,_a4,_a5){}});function _a6(_a7){return {min:_a7.hmin,max:_a7.hmax};};function _a8(_a9){return {min:_a9.vmin,max:_a9.vmax};};function _aa(_ab,h){_ab.hmin=h.min;_ab.hmax=h.max;};function _ac(_ad,v){_ad.vmin=v.min;_ad.vmax=v.max;};function _ae(_af,_b0){if(_af&&_b0){_af.min=Math.min(_af.min,_b0.min);_af.max=Math.max(_af.max,_b0.max);}return _af||_b0;};function _77(_b1,_b2){var _b3={},_b4={};_3.forEach(_b1,function(_b5){var _b6=_b3[_b5.name]=_b5.getSeriesStats();if(_b5.hAxis){_b4[_b5.hAxis]=_ae(_b4[_b5.hAxis],_a6(_b6));}if(_b5.vAxis){_b4[_b5.vAxis]=_ae(_b4[_b5.vAxis],_a8(_b6));}});_3.forEach(_b1,function(_b7){var _b8=_b3[_b7.name];if(_b7.hAxis){_aa(_b8,_b4[_b7.hAxis]);}if(_b7.vAxis){_ac(_b8,_b4[_b7.vAxis]);}_b7.initializeScalers(_b2,_b8);});};return _a("dojo-bidi")?_4("dojox.charting.Chart",[_1e,_11]):_1e;});},"dojox/main":function(){define(["dojo/_base/kernel"],function(_b9){return _b9.dojox;});},"dojox/charting/Element":function(){define(["dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx","dojox/gfx/shape"],function(arr,_ba,_bb,gfx,_bc){return _bb("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,renderingOptions:null,constructor:function(_bd,_be){this.chart=_bd;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];if(_be&&_be.renderingOptions){this.renderingOptions=_be.renderingOptions;}},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.getGroup().removeShape();var _bf=this.getGroup().children;if(_bc.dispose){for(var i=0;i<_bf.length;++i){_bc.dispose(_bf[i],true);}}if(this.getGroup().rawNode){_ba.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_bc.dispose){_bc.dispose(this.getGroup(),true);}if(this.getGroup()!=this.group){if(this.group.rawNode){_ba.empty(this.group.rawNode);}this.group.clear();if(_bc.dispose){_bc.dispose(this.group,true);}}this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(_c0){_c0.shape.disconnect(_c0.handle);});this._events=[];}return this;},cleanGroup:function(_c1){this.destroyHtmlElements();if(!_c1){_c1=this.chart.surface;}if(this.group){var _c2;var _c3=this.getGroup().children;if(_bc.dispose){for(var i=0;i<_c3.length;++i){_bc.dispose(_c3[i],true);}}if(this.getGroup().rawNode){_c2=this.getGroup().bgNode;_ba.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_c2){this.getGroup().rawNode.appendChild(_c2);}}else{this.group=_c1.createGroup();if(this.renderingOptions&&this.group.rawNode&&this.group.rawNode.namespaceURI=="http://www.w3.org/2000/svg"){for(var key in this.renderingOptions){this.group.rawNode.setAttribute(key,this.renderingOptions[key]);}}}this.dirty=true;return this;},getGroup:function(){return this.group;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_ba.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},overrideShape:function(_c4,_c5){},getTextWidth:function(s,_c6){return gfx._base._getTextBox(s,{font:_c6}).w||0;},getTextWithLimitLength:function(s,_c7,_c8,_c9){if(!s||s.length<=0){return {text:"",truncated:_c9||false};}if(!_c8||_c8<=0){return {text:s,truncated:_c9||false};}var _ca=2,_cb=0.618,_cc=s.substring(0,1)+this.trailingSymbol,_cd=this.getTextWidth(_cc,_c7);if(_c8<=_cd){return {text:_cc,truncated:true};}var _ce=this.getTextWidth(s,_c7);if(_ce<=_c8){return {text:s,truncated:_c9||false};}else{var _cf=0,end=s.length;while(_cf<end){if(end-_cf<=_ca){while(this.getTextWidth(s.substring(0,_cf)+this.trailingSymbol,_c7)>_c8){_cf-=1;}return {text:(s.substring(0,_cf)+this.trailingSymbol),truncated:true};}var _d0=_cf+Math.round((end-_cf)*_cb),_d1=this.getTextWidth(s.substring(0,_d0),_c7);if(_d1<_c8){_cf=_d0;end=end;}else{_cf=_cf;end=_d0;}}}},getTextWithLimitCharCount:function(s,_d2,_d3,_d4){if(!s||s.length<=0){return {text:"",truncated:_d4||false};}if(!_d3||_d3<=0||s.length<=_d3){return {text:s,truncated:_d4||false};}return {text:s.substring(0,_d3)+this.trailingSymbol,truncated:true};},_plotFill:function(_d5,dim,_d6){if(!_d5||!_d5.type||!_d5.space){return _d5;}var _d7=_d5.space,_d8;switch(_d5.type){case "linear":if(_d7==="plot"||_d7==="shapeX"||_d7==="shapeY"){_d5=gfx.makeParameters(gfx.defaultLinearGradient,_d5);_d5.space=_d7;if(_d7==="plot"||_d7==="shapeX"){_d8=dim.height-_d6.t-_d6.b;_d5.y1=_d6.t+_d8*_d5.y1/100;_d5.y2=_d6.t+_d8*_d5.y2/100;}if(_d7==="plot"||_d7==="shapeY"){_d8=dim.width-_d6.l-_d6.r;_d5.x1=_d6.l+_d8*_d5.x1/100;_d5.x2=_d6.l+_d8*_d5.x2/100;}}break;case "radial":if(_d7==="plot"){_d5=gfx.makeParameters(gfx.defaultRadialGradient,_d5);_d5.space=_d7;var _d9=dim.width-_d6.l-_d6.r,_da=dim.height-_d6.t-_d6.b;_d5.cx=_d6.l+_d9*_d5.cx/100;_d5.cy=_d6.t+_da*_d5.cy/100;_d5.r=_d5.r*Math.sqrt(_d9*_d9+_da*_da)/200;}break;case "pattern":if(_d7==="plot"||_d7==="shapeX"||_d7==="shapeY"){_d5=gfx.makeParameters(gfx.defaultPattern,_d5);_d5.space=_d7;if(_d7==="plot"||_d7==="shapeX"){_d8=dim.height-_d6.t-_d6.b;_d5.y=_d6.t+_d8*_d5.y/100;_d5.height=_d8*_d5.height/100;}if(_d7==="plot"||_d7==="shapeY"){_d8=dim.width-_d6.l-_d6.r;_d5.x=_d6.l+_d8*_d5.x/100;_d5.width=_d8*_d5.width/100;}}break;}return _d5;},_shapeFill:function(_db,_dc){if(!_db||!_db.space){return _db;}var _dd=_db.space,_de;switch(_db.type){case "linear":if(_dd==="shape"||_dd==="shapeX"||_dd==="shapeY"){_db=gfx.makeParameters(gfx.defaultLinearGradient,_db);_db.space=_dd;if(_dd==="shape"||_dd==="shapeX"){_de=_dc.width;_db.x1=_dc.x+_de*_db.x1/100;_db.x2=_dc.x+_de*_db.x2/100;}if(_dd==="shape"||_dd==="shapeY"){_de=_dc.height;_db.y1=_dc.y+_de*_db.y1/100;_db.y2=_dc.y+_de*_db.y2/100;}}break;case "radial":if(_dd==="shape"){_db=gfx.makeParameters(gfx.defaultRadialGradient,_db);_db.space=_dd;_db.cx=_dc.x+_dc.width/2;_db.cy=_dc.y+_dc.height/2;_db.r=_db.r*_dc.width/200;}break;case "pattern":if(_dd==="shape"||_dd==="shapeX"||_dd==="shapeY"){_db=gfx.makeParameters(gfx.defaultPattern,_db);_db.space=_dd;if(_dd==="shape"||_dd==="shapeX"){_de=_dc.width;_db.x=_dc.x+_de*_db.x/100;_db.width=_de*_db.width/100;}if(_dd==="shape"||_dd==="shapeY"){_de=_dc.height;_db.y=_dc.y+_de*_db.y/100;_db.height=_de*_db.height/100;}}break;}return _db;},_pseudoRadialFill:function(_df,_e0,_e1,_e2,end){if(!_df||_df.type!=="radial"||_df.space!=="shape"){return _df;}var _e3=_df.space;_df=gfx.makeParameters(gfx.defaultRadialGradient,_df);_df.space=_e3;if(arguments.length<4){_df.cx=_e0.x;_df.cy=_e0.y;_df.r=_df.r*_e1/100;return _df;}var _e4=arguments.length<5?_e2:(end+_e2)/2;return {type:"linear",x1:_e0.x,y1:_e0.y,x2:_e0.x+_df.r*_e1*Math.cos(_e4)/100,y2:_e0.y+_df.r*_e1*Math.sin(_e4)/100,colors:_df.colors};}});});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(_e5,_e6,_e7){_e6.switchTo(_e7);return _e6;});},"dojox/gfx/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_e8,_e9,_ea,has,win,arr,dom,_eb,_ec){var g=_e9.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(_ed,_ee){var cls=_ed.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_ee+" ")>=0;};g._addClass=function(_ef,_f0){var cls=_ef.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_f0+" ")<0){_ef.setAttribute("className",cls+(cls?" ":"")+_f0);}};g._removeClass=function(_f1,_f2){var cls=_f1.getAttribute("className");if(cls){_f1.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_f2+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _f3={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p,_f4;if(has("ie")){_f4=win.doc.documentElement.style.fontSize||"";if(!_f4){win.doc.documentElement.style.fontSize="100%";}}var div=_eb.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _f3){div.style.fontSize=p;_f3[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}if(has("ie")){win.doc.documentElement.style.fontSize=_f4;}win.body().removeChild(div);return _f3;};var _f5=null;b._getCachedFontMeasurements=function(_f6){if(_f6||!_f5){_f5=b._getFontMeasurements();}return _f5;};var _f7=null,_f8={};b._getTextBox=function(_f9,_fa,_fb){var m,s,al=arguments.length;var i,box;if(!_f7){_f7=_eb.create("div",{style:{position:"absolute",top:"-10000px",left:"0",visibility:"hidden"}},win.body());}m=_f7;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_fa){for(i in _fa){if(i in _f8){continue;}s[i]=_fa[i];}}if(al>2&&_fb){m.className=_fb;}m.innerHTML=_f9;if(m.getBoundingClientRect){var bcr=m.getBoundingClientRect();box={l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{box=_ec.getMarginBox(m);}m.innerHTML="";return box;};b._computeTextLocation=function(_fc,_fd,_fe,_ff){var loc={},_100=_fc.align;switch(_100){case "end":loc.x=_fc.x-_fd;break;case "middle":loc.x=_fc.x-_fd/2;break;default:loc.x=_fc.x;break;}var c=_ff?0.75:1;loc.y=_fc.y-_fe*c;return loc;};b._computeTextBoundingBox=function(s){if(!g._base._isRendered(s)){return {x:0,y:0,width:0,height:0};}var loc,_101=s.getShape(),font=s.getFont()||g.defaultFont,w=s.getTextWidth(),h=g.normalizedLength(font.size);loc=b._computeTextLocation(_101,w,h,true);return {x:loc.x,y:loc.y,width:w,height:h};};b._isRendered=function(s){var p=s.parent;while(p&&p.getParent){p=p.parent;}return p!==null;};var _102=0;b._getUniqueId=function(){var id;do{id=_e8._scopeName+"xUnique"+(++_102);}while(dom.byId(id));return id;};var _103=has("pointer-events")?"touchAction":has("MSPointer")?"msTouchAction":null;b._fixMsTouchAction=_103?function(_104){_104.rawNode.style[_103]="none";}:function(){};_e9.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _105={};return function(type){var t=_105[type];if(t){return new t();}t=_105[type]=function(){};t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_106){return (_106 instanceof _ea)?_106:new _ea(_106);},normalizeParameters:function(_107,_108){var x;if(_108){var _109={};for(x in _107){if(x in _108&&!(x in _109)){_107[x]=_108[x];}}}return _107;},makeParameters:function(_10a,_10b){var i=null;if(!_10b){return _e9.delegate(_10a);}var _10c={};for(i in _10a){if(!(i in _10c)){_10c[i]=_e9.clone((i in _10b)?_10b[i]:_10a[i]);}}return _10c;},formatNumber:function(x,_10d){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _10e=val.indexOf(".");if(_10e>=0&&val.length-_10e>5){val=x.toFixed(4);}}if(x<0){return val;}return _10d?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _10f=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_10f;case "in":return val*72*_10f;case "pc":return val*12*_10f;case "mm":return val*g.mm_in_pt*_10f;case "cm":return val*g.cm_in_pt*_10f;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-DF-Za-df-z])|([-+]?\d*[.]?\d+(?:[eE][-+]?\d+)?)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_110){var ns=typeof _110=="string"?g[_110]:_110;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});if(typeof _110=="string"){g.renderer=_110;}else{arr.some(["svg","vml","canvas","canvasWithEvents","silverlight"],function(r){return (g.renderer=g[r]&&g[r].Surface===g.Surface?r:null);});}}}});return g;});},"dojox/gfx/renderer":function(){define(["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_111){var _112=null;has.add("vml",function(_113,_114,_115){_115.innerHTML="<v:shape adj=\"1\"/>";var _116=("adj" in _115.firstChild);_115.innerHTML="";return _116;});return {load:function(id,_117,load){if(_112&&id!="force"){load(_112);return;}var _118=_111.forceGfxRenderer,_119=!_118&&(lang.isString(_111.gfxRenderer)?_111.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_11a,_11b;while(!_118&&_119.length){switch(_119.shift()){case "svg":if("SVGAngle" in win.global){_118="svg";}break;case "vml":if(has("vml")){_118="vml";}break;case "silverlight":try{if(has("ie")){_11a=new ActiveXObject("AgControl.AgControl");if(_11a&&_11a.IsVersionSupported("1.0")){_11b=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_11b=true;}}}catch(e){_11b=false;}finally{_11a=null;}if(_11b){_118="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_118="canvas";}break;}}if(_118==="canvas"&&_111.canvasEvents!==false){_118="canvasWithEvents";}if(_111.isDebug){}function _11c(){_117(["dojox/gfx/"+_118],function(_11d){g.renderer=_118;_112=_11d;load(_11d);});};if(_118=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_11c);}else{_11c();}}};});},"dojox/gfx/shape":function(){define(["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/on","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,lang,_11e,_11f,has,on,arr,_120,_121,_122){function _123(a,_124){var len=(a.length-1);while(_124<len){a[_124]=a[++_124];}a.length=len;};var _125=g.shape={};_125.Shape=_11e("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;if(has("gfxRegistry")){var uid=_125.register(this);this.getUID=function(){return uid;};}},destroy:function(){if(has("gfxRegistry")){_125.dispose(this);}if(this.rawNode&&"__gfxObject__" in this.rawNode){this.rawNode.__gfxObject__=null;}this.rawNode=null;},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_122;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(clip){this.clip=clip;},getClip:function(){return this.clip;},setShape:function(_126){this.shape=g.makeParameters(this.shape,_126);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}var f=null;if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);break;}}else{f=g.normalizeColor(fill);}this.fillStyle=f;return this;},setStroke:function(_127){if(!_127){this.strokeStyle=null;return this;}if(typeof _127=="string"||lang.isArray(_127)||_127 instanceof _121){_127={color:_127};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_127);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_128){this.matrix=_122.clone(_128?_122.normalize(_128):_122.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_129){return _129?this.setTransform([this.matrix,_129]):this;},applyLeftTransform:function(_12a){return _12a?this.setTransform([_12a,this.matrix]):this;},applyTransform:function(_12b){return _12b?this.setTransform([this.matrix,_12b]):this;},removeShape:function(_12c){if(this.parent){this.parent.remove(this,_12c);}return this;},_setParent:function(_12d,_12e){this.parent=_12d;return this._updateParentMatrix(_12e);},_updateParentMatrix:function(_12f){this.parentMatrix=_12f?_122.clone(_12f):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_122.multiply(p.matrix,m);}p=p.parent;}return m;}});_125._eventsProcessing={on:function(type,_130){return on(this.getEventSource(),type,_125.fixCallback(this,g.fixTarget,_130));},connect:function(name,_131,_132){if(name.substring(0,2)=="on"){name=name.substring(2);}return this.on(name,_132?lang.hitch(_131,_132):_131);},disconnect:function(_133){return _133.remove();}};_125.fixCallback=function(_134,_135,_136,_137){if(!_137){_137=_136;_136=null;}if(lang.isString(_137)){_136=_136||_11f.global;if(!_136[_137]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_137,"\"] is null (scope=\"",_136,"\")"].join(""));}return function(e){return _135(e,_134)?_136[_137].apply(_136,arguments||[]):undefined;};}return !_136?function(e){return _135(e,_134)?_137.apply(_136,arguments):undefined;}:function(e){return _135(e,_134)?_137.apply(_136,arguments||[]):undefined;};};lang.extend(_125.Shape,_125._eventsProcessing);_125.Container={_init:function(){this.children=[];this._batch=0;},openBatch:function(){return this;},closeBatch:function(){return this;},add:function(_138){var _139=_138.getParent();if(_139){_139.remove(_138,true);}this.children.push(_138);return _138._setParent(this,this._getRealMatrix());},remove:function(_13a,_13b){for(var i=0;i<this.children.length;++i){if(this.children[i]==_13a){if(_13b){}else{_13a.parent=null;_13a.parentMatrix=null;}_123(this.children,i);break;}}return this;},clear:function(_13c){var _13d;for(var i=0;i<this.children.length;++i){_13d=this.children[i];_13d.parent=null;_13d.parentMatrix=null;if(_13c){_13d.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _13e=null;arr.forEach(this.children,function(_13f){var bb=_13f.getBoundingBox();if(bb){var ct=_13f.getTransform();if(ct){bb=_122.multiplyRectangle(ct,bb);}if(_13e){_13e.x=Math.min(_13e.x,bb.x);_13e.y=Math.min(_13e.y,bb.y);_13e.endX=Math.max(_13e.endX,bb.x+bb.width);_13e.endY=Math.max(_13e.endY,bb.y+bb.height);}else{_13e={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_13e){_13e.width=_13e.endX-_13e.x;_13e.height=_13e.endY-_13e.y;}return _13e;}return null;},_moveChildToFront:function(_140){for(var i=0;i<this.children.length;++i){if(this.children[i]==_140){_123(this.children,i);this.children.push(_140);break;}}return this;},_moveChildToBack:function(_141){for(var i=0;i<this.children.length;++i){if(this.children[i]==_141){_123(this.children,i);this.children.unshift(_141);break;}}return this;}};_125.Surface=_11e("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_120.destroy);this._nodes=[];arr.forEach(this._events,function(h){if(h){h.remove();}});this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_120.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_142){},whenLoaded:function(_143,_144){var f=lang.hitch(_143,_144);if(this.isLoaded){f(this);}else{on.once(this,"load",function(_145){f(_145);});}}});lang.extend(_125.Surface,_125._eventsProcessing);_125.Rect=_11e("dojox.gfx.shape.Rect",_125.Shape,{constructor:function(_146){this.shape=g.getDefault("Rect");this.rawNode=_146;},getBoundingBox:function(){return this.shape;}});_125.Ellipse=_11e("dojox.gfx.shape.Ellipse",_125.Shape,{constructor:function(_147){this.shape=g.getDefault("Ellipse");this.rawNode=_147;},getBoundingBox:function(){if(!this.bbox){var _148=this.shape;this.bbox={x:_148.cx-_148.rx,y:_148.cy-_148.ry,width:2*_148.rx,height:2*_148.ry};}return this.bbox;}});_125.Circle=_11e("dojox.gfx.shape.Circle",_125.Shape,{constructor:function(_149){this.shape=g.getDefault("Circle");this.rawNode=_149;},getBoundingBox:function(){if(!this.bbox){var _14a=this.shape;this.bbox={x:_14a.cx-_14a.r,y:_14a.cy-_14a.r,width:2*_14a.r,height:2*_14a.r};}return this.bbox;}});_125.Line=_11e("dojox.gfx.shape.Line",_125.Shape,{constructor:function(_14b){this.shape=g.getDefault("Line");this.rawNode=_14b;},getBoundingBox:function(){if(!this.bbox){var _14c=this.shape;this.bbox={x:Math.min(_14c.x1,_14c.x2),y:Math.min(_14c.y1,_14c.y2),width:Math.abs(_14c.x2-_14c.x1),height:Math.abs(_14c.y2-_14c.y1)};}return this.bbox;}});_125.Polyline=_11e("dojox.gfx.shape.Polyline",_125.Shape,{constructor:function(_14d){this.shape=g.getDefault("Polyline");this.rawNode=_14d;},setShape:function(_14e,_14f){if(_14e&&_14e instanceof Array){this.inherited(arguments,[{points:_14e}]);if(_14f&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_14e]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _150=[];for(var i=0;i<l;i+=2){_150.push({x:p[i],y:p[i+1]});}this.shape.points=_150;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_125.Image=_11e("dojox.gfx.shape.Image",_125.Shape,{constructor:function(_151){this.shape=g.getDefault("Image");this.rawNode=_151;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_125.Text=_11e(_125.Shape,{constructor:function(_152){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_152;},getFont:function(){return this.fontStyle;},setFont:function(_153){this.fontStyle=typeof _153=="string"?g.splitFontString(_153):g.makeParameters(g.defaultFont,_153);this._setFont();return this;},getBoundingBox:function(){var bbox=null,s=this.getShape();if(s.text){bbox=g._base._computeTextBoundingBox(this);}return bbox;}});_125.Creator={createShape:function(_154){switch(_154.type){case g.defaultPath.type:return this.createPath(_154);case g.defaultRect.type:return this.createRect(_154);case g.defaultCircle.type:return this.createCircle(_154);case g.defaultEllipse.type:return this.createEllipse(_154);case g.defaultLine.type:return this.createLine(_154);case g.defaultPolyline.type:return this.createPolyline(_154);case g.defaultImage.type:return this.createImage(_154);case g.defaultText.type:return this.createText(_154);case g.defaultTextPath.type:return this.createTextPath(_154);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_155){return this.createObject(g.Ellipse,_155);},createCircle:function(_156){return this.createObject(g.Circle,_156);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_157){return this.createObject(g.Polyline,_157);},createImage:function(_158){return this.createObject(g.Image,_158);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_159,_15a){return null;}};return _125;});},"dojox/gfx/matrix":function(){define(["./_base","dojo/_base/lang"],function(g,lang){var m=g.matrix={};var _15b={};m._degToRad=function(_15c){return _15b[_15c]||(_15b[_15c]=(Math.PI*_15c/180));};m._radToDeg=function(_15d){return _15d/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _15e=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_15e,r=m.normalize(arg[i]);_15e=new m.Matrix2D();_15e.xx=l.xx*r.xx+l.xy*r.yx;_15e.xy=l.xx*r.xy+l.xy*r.yy;_15e.yx=l.yx*r.xx+l.yy*r.yx;_15e.yy=l.yx*r.xy+l.yy*r.yy;_15e.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_15e.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}lang.mixin(this,_15e);}}else{lang.mixin(this,arg);}}}};lang.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});lang.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_15f){var c=Math.cos(_15f);var s=Math.sin(_15f);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_160){return m.rotate(m._degToRad(_160));},skewX:function(_161){return new m.Matrix2D({xy:Math.tan(_161)});},skewXg:function(_162){return m.skewX(m._degToRad(_162));},skewY:function(_163){return new m.Matrix2D({yx:Math.tan(_163)});},skewYg:function(_164){return m.skewY(m._degToRad(_164));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_165){return (_165 instanceof m.Matrix2D)?_165:new m.Matrix2D(_165);},isIdentity:function(_166){return _166.xx==1&&_166.xy==0&&_166.yx==0&&_166.yy==1&&_166.dx==0&&_166.dy==0;},clone:function(_167){var obj=new m.Matrix2D();for(var i in _167){if(typeof (_167[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_167[i]){obj[i]=_167[i];}}return obj;},invert:function(_168){var M=m.normalize(_168),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_169,x,y){return {x:_169.xx*x+_169.xy*y+_169.dx,y:_169.yx*x+_169.yy*y+_169.dy};},multiplyPoint:function(_16a,a,b){var M=m.normalize(_16a);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiplyRectangle:function(_16b,rect){var M=m.normalize(_16b);rect=rect||{x:0,y:0,width:0,height:0};if(m.isIdentity(M)){return {x:rect.x,y:rect.y,width:rect.width,height:rect.height};}var p0=m.multiplyPoint(M,rect.x,rect.y),p1=m.multiplyPoint(M,rect.x,rect.y+rect.height),p2=m.multiplyPoint(M,rect.x+rect.width,rect.y),p3=m.multiplyPoint(M,rect.x+rect.width,rect.y+rect.height),minx=Math.min(p0.x,p1.x,p2.x,p3.x),miny=Math.min(p0.y,p1.y,p2.y,p3.y),maxx=Math.max(p0.x,p1.x,p2.x,p3.x),maxy=Math.max(p0.y,p1.y,p2.y,p3.y);return {x:minx,y:miny,width:maxx-minx,height:maxy-miny};},multiply:function(_16c){var M=m.normalize(_16c);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_16d,x,y){return m.multiply(m.translate(x,y),_16d,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_16e,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_16e),a,b);}return m._sandwich(m.rotate(_16e),a.x,a.y);},rotategAt:function(_16f,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_16f),a,b);}return m._sandwich(m.rotateg(_16f),a.x,a.y);},skewXAt:function(_170,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_170),a,b);}return m._sandwich(m.skewX(_170),a.x,a.y);},skewXgAt:function(_171,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_171),a,b);}return m._sandwich(m.skewXg(_171),a.x,a.y);},skewYAt:function(_172,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_172),a,b);}return m._sandwich(m.skewY(_172),a.x,a.y);},skewYgAt:function(_173,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_173),a,b);}return m._sandwich(m.skewYg(_173),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/charting/SimpleTheme":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_174,_175,dlu,dgg){var _176=_174("dojox.charting.SimpleTheme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_177){_177=_177||{};var def=_176.defaultTheme;arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_177[name]);},this);if(_177.seriesThemes&&_177.seriesThemes.length){this.colors=null;this.seriesThemes=_177.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_177.colors||_176.defaultColors).slice(0);}this.markerThemes=null;if(_177.markerThemes&&_177.markerThemes.length){this.markerThemes=_177.markerThemes.slice(0);}this.markers=_177.markers?lang.clone(_177.markers):lang.delegate(_176.defaultMarkers);this.noGradConv=_177.noGradConv;this.noRadialConv=_177.noRadialConv;if(_177.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _178=new this.constructor({chart:this.chart,plotarea:this.plotarea,axis:this.axis,grid:this.grid,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv,pieInnerRadius:this.pieInnerRadius});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_178[name]=this[name];}},this);return _178;},clear:function(){this._current=0;},next:function(_179,_17a,_17b){var _17c=dlu.merge,_17d,_17e;if(this.colors){_17d=lang.delegate(this.series);_17e=lang.delegate(this.marker);var _17f=new _175(this.colors[this._current%this.colors.length]),old;if(_17d.stroke&&_17d.stroke.color){_17d.stroke=lang.delegate(_17d.stroke);old=new _175(_17d.stroke.color);_17d.stroke.color=new _175(_17f);_17d.stroke.color.a=old.a;}else{_17d.stroke={color:_17f};}if(_17e.stroke&&_17e.stroke.color){_17e.stroke=lang.delegate(_17e.stroke);old=new _175(_17e.stroke.color);_17e.stroke.color=new _175(_17f);_17e.stroke.color.a=old.a;}else{_17e.stroke={color:_17f};}if(!_17d.fill||_17d.fill.type){_17d.fill=_17f;}else{old=new _175(_17d.fill);_17d.fill=new _175(_17f);_17d.fill.a=old.a;}if(!_17e.fill||_17e.fill.type){_17e.fill=_17f;}else{old=new _175(_17e.fill);_17e.fill=new _175(_17f);_17e.fill.a=old.a;}}else{_17d=this.seriesThemes?_17c(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_17e=this.markerThemes?_17c(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_17d;}var _180=_17e&&_17e.symbol||this._markers[this._current%this._markers.length];var _181={series:_17d,marker:_17e,symbol:_180};++this._current;if(_17a){_181=this.addMixin(_181,_179,_17a);}if(_17b){_181=this.post(_181,_179);}return _181;},skip:function(){++this._current;},addMixin:function(_182,_183,_184,_185){if(lang.isArray(_184)){arr.forEach(_184,function(m){_182=this.addMixin(_182,_183,m);},this);}else{var t={};if("color" in _184){if(_183=="line"||_183=="area"){lang.setObject("series.stroke.color",_184.color,t);lang.setObject("marker.stroke.color",_184.color,t);}else{lang.setObject("series.fill",_184.color,t);}}arr.forEach(["stroke","outline","shadow","fill","filter","font","fontColor","labelWiring"],function(name){var _186="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_186 in _184;if(name in _184){lang.setObject("series."+name,_184[name],t);if(!b){lang.setObject("marker."+name,_184[name],t);}}if(b){lang.setObject("marker."+name,_184[_186],t);}});if("marker" in _184){t.symbol=_184.marker;t.symbol=_184.marker;}_182=dlu.merge(_182,t);}if(_185){_182=this.post(_182,_183);}return _182;},post:function(_187,_188){var fill=_187.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_188=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_188=="slice"||_188=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_187,{series:{fill:t}});}}return _187;},getTick:function(name,_189){var tick=this.axis.tick,_18a=name+"Tick",_18b=dlu.merge;if(tick){if(this.axis[_18a]){tick=_18b(tick,this.axis[_18a]);}}else{tick=this.axis[_18a];}if(_189){if(tick){if(_189[_18a]){tick=_18b(tick,_189[_18a]);}}else{tick=_189[_18a];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_18c){this.markers[name]=_18c;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_176,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333",titleAlign:"middle"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",labelGap:4},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1},title:{gap:15,font:"normal normal normal 11pt Tahoma",fontColor:"#333",orientation:"axis"}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,lineFill:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}}});return _176;});},"dojox/lang/utils":function(){define(["..","dojo/_base/lang"],function(_18d,lang){var du=lang.getObject("lang.utils",true,_18d);var _18e={},opts=Object.prototype.toString;var _18f=function(o){if(o){switch(opts.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return lang.delegate(o);}}return o;};lang.mixin(du,{coerceType:function(_190,_191){switch(typeof _190){case "number":return Number(eval("("+_191+")"));case "string":return String(_191);case "boolean":return Boolean(eval("("+_191+")"));}return eval("("+_191+")");},updateWithObject:function(_192,_193,conv){if(!_193){return _192;}for(var x in _192){if(x in _193&&!(x in _18e)){var t=_192[x];if(t&&typeof t=="object"){du.updateWithObject(t,_193[x],conv);}else{_192[x]=conv?du.coerceType(t,_193[x]):_18f(_193[x]);}}}return _192;},updateWithPattern:function(_194,_195,_196,conv){if(!_195||!_196){return _194;}for(var x in _196){if(x in _195&&!(x in _18e)){_194[x]=conv?du.coerceType(_196[x],_195[x]):_18f(_195[x]);}}return _194;},merge:function(_197,_198){if(_198){var _199=opts.call(_197),_19a=opts.call(_198),t,i,l,m;switch(_19a){case "[object Array]":if(_19a==_199){t=new Array(Math.max(_197.length,_198.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_197[i],_198[i]);}return t;}return _198.slice(0);case "[object Object]":if(_19a==_199&&_197){t=lang.delegate(_197);for(i in _198){if(i in _197){l=_197[i];m=_198[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=lang.clone(_198[i]);}}return t;}return lang.clone(_198);}}return _198;}});return du;});},"dojox/gfx/gradutils":function(){define(["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_19b){var _19c=g.gradutils={};function _19d(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _19b.blendColors(new _19b(prev.color),new _19b(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_19c.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _19e=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_19f=m.rotate(-_19e),_1a0=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_1a0,pt),pf1=m.multiplyPoint(_1a0,fill.x1,fill.y1),pf2=m.multiplyPoint(_1a0,fill.x2,fill.y2),_1a1=m.multiplyPoint(_19f,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_19f,p.x-pf1.x,p.y-pf1.y).x/_1a1;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _19d(o,fill.colors);}return new _19b(fill||[0,0,0,0]);};_19c.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _19c;});},"dojox/charting/Series":function(){define(["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_1a2,_1a3){return _1a2("dojox.charting.Series",_1a3,{constructor:function(_1a4,data,_1a5){lang.mixin(this,_1a5);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/axis2d/common":function(){define(["dojo/_base/lang","dojo/_base/window","dojo/dom-geometry","dojox/gfx","dojo/has"],function(lang,win,_1a6,g,has){var _1a7=lang.getObject("dojox.charting.axis2d.common",true);var _1a8=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _1a9=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _1a6.getMarginBox(n).w;}};return lang.mixin(_1a7,{createText:{gfx:function(_1aa,_1ab,x,y,_1ac,text,font,_1ad){return _1ab.createText({x:x,y:y,text:text,align:_1ac}).setFont(font).setFill(_1ad);},html:function(_1ae,_1af,x,y,_1b0,text,font,_1b1,_1b2){var p=win.doc.createElement("div"),s=p.style,_1b3;if(_1ae.getTextDir){p.dir=_1ae.getTextDir(text);}_1a8(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_1b1;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_1b2){_1b3=_1a9(p);}if(p.dir=="rtl"){x+=_1b2?_1b2:_1b3;}win.body().removeChild(p);s.position="relative";if(_1b2){s.width=_1b2+"px";switch(_1b0){case "middle":s.textAlign="center";s.left=(x-_1b2/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_1b2)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_1b0){case "middle":s.left=Math.floor(x-_1b3/2)+"px";break;case "end":s.left=Math.floor(x-_1b3)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_1a8(w);w.width="0px";w.height="0px";wrap.appendChild(p);_1ae.node.insertBefore(wrap,_1ae.node.firstChild);if(has("dojo-bidi")){_1ae.htmlElementsRegistry.push([wrap,x,y,_1b0,text,font,_1b1]);}return wrap;}}});});},"dojox/charting/plot2d/common":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_1b4,g,df,sc){var _1b5=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_1b5,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_1b6){if(!_1b6){return _1b6;}if(typeof _1b6=="string"||_1b6 instanceof _1b4){_1b6={color:_1b6};}return g.makeParameters(g.defaultStroke,_1b6);},augmentColor:function(_1b7,_1b8){var t=new _1b4(_1b7),c=new _1b4(_1b8);c.a=t.a;return c;},augmentStroke:function(_1b9,_1ba){var s=_1b5.makeStroke(_1b9);if(s){s.color=_1b5.augmentColor(s.color,_1ba);}return s;},augmentFill:function(fill,_1bb){var fc,c=new _1b4(_1bb);if(typeof fill=="string"||fill instanceof _1b4){return _1b5.augmentColor(fill,_1bb);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_1bc,_1bd){var _1be=lang.delegate(_1b5.defaultStats);for(var i=0;i<_1bc.length;++i){var run=_1bc[i];for(var j=0;j<run.data.length;j++){if(!_1bd(run.data[j])){if(typeof run.data[j]=="number"){var _1bf=_1be.vmin,_1c0=_1be.vmax;arr.forEach(run.data,function(val,i){if(!_1bd(val)){var x=i+1,y=val;if(isNaN(y)){y=0;}_1be.hmin=Math.min(_1be.hmin,x);_1be.hmax=Math.max(_1be.hmax,x);_1be.vmin=Math.min(_1be.vmin,y);_1be.vmax=Math.max(_1be.vmax,y);}});if("ymin" in run){_1be.vmin=Math.min(_1bf,run.ymin);}if("ymax" in run){_1be.vmax=Math.max(_1c0,run.ymax);}}else{var _1c1=_1be.hmin,_1c2=_1be.hmax,_1bf=_1be.vmin,_1c0=_1be.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(!_1bd(val)){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_1be.hmin=Math.min(_1be.hmin,x);_1be.hmax=Math.max(_1be.hmax,x);_1be.vmin=Math.min(_1be.vmin,y);_1be.vmax=Math.max(_1be.vmax,y);}});}if("xmin" in run){_1be.hmin=Math.min(_1c1,run.xmin);}if("xmax" in run){_1be.hmax=Math.max(_1c2,run.xmax);}if("ymin" in run){_1be.vmin=Math.min(_1bf,run.ymin);}if("ymax" in run){_1be.vmax=Math.max(_1c0,run.ymax);}}break;}}}return _1be;},calculateBarSize:function(_1c3,opt,_1c4){if(!_1c4){_1c4=1;}var gap=opt.gap,size=(_1c3-2*gap)/_1c4;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_1c3-size*_1c4)/2;return {size:size,gap:gap};},collectStackedStats:function(_1c5){var _1c6=lang.clone(_1b5.defaultStats);if(_1c5.length){_1c6.hmin=Math.min(_1c6.hmin,1);_1c6.hmax=df.foldl(_1c5,"seed, run -> Math.max(seed, run.data.length)",_1c6.hmax);for(var i=0;i<_1c6.hmax;++i){var v=_1c5[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_1c6.vmin=Math.min(_1c6.vmin,v);for(var j=1;j<_1c5.length;++j){var t=_1c5[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_1c6.vmax=Math.max(_1c6.vmax,v);}}return _1c6;},curve:function(a,_1c7){var _1c8=a.slice(0);if(_1c7=="x"){_1c8[_1c8.length]=_1c8[0];}var p=arr.map(_1c8,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_1c7)){var dx=item.x-_1c8[i-1].x,dy=_1c8[i-1].y;return "C"+(item.x-(_1c7-1)*(dx/_1c7))+","+dy+" "+(item.x-(dx/_1c7))+","+item.y+" "+item.x+","+item.y;}else{if(_1c7=="X"||_1c7=="x"||_1c7=="S"){var p0,p1=_1c8[i-1],p2=_1c8[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_1c7=="x"){p0=_1c8[_1c8.length-2];}else{p0=p1;}f=1/3;}else{p0=_1c8[i-2];}if(i==(_1c8.length-1)){if(_1c7=="x"){p3=_1c8[1];}else{p3=p2;}f=1/3;}else{p3=_1c8[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _1c9=p0p2*f;var _1ca=p1p3*f;if(_1c9>p1p2/2&&_1ca>p1p2/2){_1c9=p1p2/2;_1ca=p1p2/2;}else{if(_1c9>p1p2/2){_1c9=p1p2/2;_1ca=p1p2/2*p1p3/p0p2;}else{if(_1ca>p1p2/2){_1ca=p1p2/2;_1c9=p1p2/2*p0p2/p1p3;}}}if(_1c7=="S"){if(p0==p1){_1c9=0;}if(p2==p3){_1ca=0;}}bz1x=p1.x+_1c9*(p2.x-p0.x)/p0p2;bz1y=p1.y+_1c9*(p2.y-p0.y)/p0p2;bz2x=p2.x-_1ca*(p3.x-p1.x)/p1p3;bz2y=p2.y-_1ca*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_1cb,_1cc,_1cd){return sc.doIfLoaded("dojo/number",function(_1ce){return (_1cc?_1ce.format(_1cb,{places:_1cd}):_1ce.format(_1cb))||"";},function(){return _1cc?_1cb.toFixed(_1cd):_1cb.toString();});},purgeGroup:function(item){return item.purgeGroup();}});});},"dojox/lang/functional":function(){define(["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/lang/functional/lambda":function(){define(["../..","dojo/_base/lang","dojo/_base/array"],function(_1cf,lang,arr){var df=lang.getObject("lang.functional",true,_1cf);var _1d0={};var _1d1="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _1d2=function(s){var args=[],_1d3=_1d1.call(s,/\s*->\s*/m);if(_1d3.length>1){while(_1d3.length){s=_1d3.pop();args=_1d3.pop().split(/\s*,\s*|\s+/m);if(_1d3.length){_1d3.push("(function("+args.join(", ")+"){ return ("+s+"); })");}}}else{if(s.match(/\b_\b/)){args=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){args.push("$1");s="$1"+s;}if(r){args.push("$2");s=s+"$2";}}else{var vars=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(vars,function(v){if(!t.hasOwnProperty(v)){args.push(v);t[v]=1;}});}}}return {args:args,body:s};};var _1d4=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};lang.mixin(df,{rawLambda:function(s){return _1d2(s);},buildLambda:function(s){var l=_1d2(s);return "function("+l.args.join(",")+"){return ("+l.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _1d4(s);}if(_1d0.hasOwnProperty(s)){return _1d0[s];}var l=_1d2(s);return _1d0[s]=new Function(l.args,"return ("+l.body+");");},clearLambdaCache:function(){_1d0={};}});return df;});},"dojox/lang/functional/array":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","./lambda"],function(_1d5,lang,arr,df){var _1d6={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _1d6)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _1d6)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _1d6)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _1d6)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _1d6)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/lang/functional/object":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_1d7,lang,df){var _1d8={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _1d8)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _1d8)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _1d8)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);for(var i in obj){if(!(i in _1d8)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _1d8)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojox/charting/scaler/common":function(){define(["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _1d9=lang.getObject("dojox.charting.scaler.common",true);var _1da={};return lang.mixin(_1d9,{doIfLoaded:function(_1db,_1dc,_1dd){if(_1da[_1db]===undefined){try{_1da[_1db]=require(_1db);}catch(e){_1da[_1db]=null;}}if(_1da[_1db]){return _1dc(_1da[_1db]);}else{return _1dd();}},getNumericLabel:function(_1de,_1df,_1e0){var def="";_1d9.doIfLoaded("dojo/number",function(_1e1){def=(_1e0.fixed?_1e1.format(_1de,{places:_1df<0?-_1df:0}):_1e1.format(_1de))||"";},function(){def=_1e0.fixed?_1de.toFixed(_1df<0?-_1df:0):_1de.toString();});if(_1e0.labelFunc){var r=_1e0.labelFunc(def,_1de,_1df);if(r){return r;}}if(_1e0.labels){var l=_1e0.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_1de){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}}return def;}});});},"dojox/lang/functional/fold":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/kernel","./lambda"],function(lang,arr,_1e2,df){var _1e3={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _1e3)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _1e4=true;for(i in a){if(!(i in _1e3)){if(_1e4){z=a[i];_1e4=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||_1e2.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"dojox/lang/functional/reversed":function(){define(["dojo/_base/lang","dojo/_base/kernel","./lambda"],function(lang,_1e5,df){lang.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojox/charting/plot2d/Spider":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","dojo/dom-geometry","dojo/_base/fx","dojo/fx","dojo/sniff","./Base","./_PlotEvents","./common","../axis2d/common","dojox/gfx","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/utils","dojo/fx/easing"],function(lang,_1e6,hub,arr,_1e7,_1e8,_1e9,has,Base,_1ea,dc,da,g,m,_1eb,df,du,_1ec){var _1ed=0.2;var _1ee=_1e6("dojox.charting.plot2d.Spider",[Base,_1ea],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:-10,labelStyle:"default",htmlLabels:true,startAngle:-90,divisions:3,axisColor:"",axisWidth:0,spiderColor:"",spiderWidth:0,seriesWidth:0,seriesFillAlpha:0.2,spiderOrigin:0.16,markerSize:3,spiderType:"polygon",animationType:_1ec.backOut,animate:null,axisTickFont:"",axisTickFontColor:"",axisFont:"",axisFontColor:""},optionalParams:{radius:0,font:"",fontColor:""},constructor:function(_1ef,_1f0){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_1f0);du.updateWithPattern(this.opt,_1f0,this.optionalParams);this.dyn=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animate=this.opt.animate===null?{}:this.opt.animate;this.animations={};},clear:function(){this.inherited(arguments);this.dyn=[];this.axes=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};return this;},setAxis:function(axis){if(axis){if(axis.opt.min!=undefined){this.datas[axis.name].min=axis.opt.min;}if(axis.opt.max!=undefined){this.datas[axis.name].max=axis.opt.max;}}return this;},addSeries:function(run){this.series.push(run);var key;for(key in run.data){var val=run.data[key],data=this.datas[key];if(data){data.vlist.push(val);data.min=Math.min(data.min,val);data.max=Math.max(data.max,val);}else{var _1f1="__"+key;this.axes.push(_1f1);this[_1f1]=key;this.datas[key]={min:val,max:val,vlist:[val]};}}if(this.labelKey.length<=0){for(key in run.data){this.labelKey.push(key);}}return this;},getSeriesStats:function(){return dc.collectSimpleStats(this.series,function(v){return v===null;});},render:function(dim,_1f2){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,t=this.chart.theme;this.resetEvents();if(!this.series||!this.series.length){return this;}var o=this.opt,ta=t.axis,rx=(dim.width-_1f2.l-_1f2.r)/2,ry=(dim.height-_1f2.t-_1f2.b)/2,r=Math.min(rx,ry),_1f3=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font)||"normal normal normal 7pt Tahoma",_1f4=o.axisFont||(ta.tick&&ta.tick.titleFont)||"normal normal normal 11pt Tahoma",_1f5=o.axisTickFontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"silver",_1f6=o.axisFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_1f7=o.axisColor||(ta.tick&&ta.tick.axisColor)||"silver",_1f8=o.spiderColor||(ta.tick&&ta.tick.spiderColor)||"silver",_1f9=o.axisWidth||(ta.stroke&&ta.stroke.width)||2,_1fa=o.spiderWidth||(ta.stroke&&ta.stroke.width)||2,_1fb=o.seriesWidth||(ta.stroke&&ta.stroke.width)||2,_1fc=g.normalizedLength(g.splitFontString(_1f4).size),_1fd=m._degToRad(o.startAngle),_1fe=_1fd,_1ff,_200,_201,_202,_203,_204,_205,_206,ro=o.spiderOrigin,dv=o.divisions>=3?o.divisions:3,ms=o.markerSize,spt=o.spiderType,at=o.animationType,_207=o.labelOffset<-10?o.labelOffset:-10,_208=0.2,i,j,_209,len,_20a,_20b,_20c,run,data,min,max,_20d;if(o.labels){_1ff=arr.map(this.series,function(s){return s.name;},this);_200=df.foldl1(df.map(_1ff,function(_20e){var font=t.series.font;return g._base._getTextBox(_20e,{font:font}).w;},this),"Math.max(a, b)")/2;r=Math.min(rx-2*_200,ry-_1fc)+_207;_201=r-_207;}if("radius" in o){r=o.radius;_201=r-_207;}r/=(1+_208);var _20f={cx:_1f2.l+rx,cy:_1f2.t+ry,r:r};for(var i=0;i<this.series.length;i++){_20c=this.series[i];if(!this.dirty&&!_20c.dirty){t.skip();continue;}_20c.cleanGroup();run=_20c.data;if(run!==null){len=this._getObjectLength(run);if(!_202||_202.length<=0){_202=[],_203=[],_206=[];this._buildPoints(_202,len,_20f,r,_1fe,true,dim);this._buildPoints(_203,len,_20f,r*ro,_1fe,true,dim);this._buildPoints(_206,len,_20f,_201,_1fe,false,dim);if(dv>2){_204=[],_205=[];for(j=0;j<dv-2;j++){_204[j]=[];this._buildPoints(_204[j],len,_20f,r*(ro+(1-ro)*(j+1)/(dv-1)),_1fe,true,dim);_205[j]=r*(ro+(1-ro)*(j+1)/(dv-1));}}}}}var _210=s.createGroup(),_211={color:_1f7,width:_1f9},_212={color:_1f8,width:_1fa};for(j=_202.length-1;j>=0;--j){_209=_202[j];var st={x:_209.x+(_209.x-_20f.cx)*_208,y:_209.y+(_209.y-_20f.cy)*_208},nd={x:_209.x+(_209.x-_20f.cx)*_208/2,y:_209.y+(_209.y-_20f.cy)*_208/2};_210.createLine({x1:_20f.cx,y1:_20f.cy,x2:st.x,y2:st.y}).setStroke(_211);this._drawArrow(_210,st,nd,_211);}var _213=s.createGroup();for(j=_206.length-1;j>=0;--j){_209=_206[j];_20a=g._base._getTextBox(this.labelKey[j],{font:_1f4}).w||0;_20b=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";var elem=da.createText[_20b](this.chart,_213,(!_1e7.isBodyLtr()&&_20b=="html")?(_209.x+_20a-dim.width):_209.x,_209.y,"middle",this.labelKey[j],_1f4,_1f6);if(this.opt.htmlLabels){this.htmlElements.push(elem);}}var _214=s.createGroup();if(spt=="polygon"){_214.createPolyline(_202).setStroke(_212);_214.createPolyline(_203).setStroke(_212);if(_204.length>0){for(j=_204.length-1;j>=0;--j){_214.createPolyline(_204[j]).setStroke(_212);}}}else{_214.createCircle({cx:_20f.cx,cy:_20f.cy,r:r}).setStroke(_212);_214.createCircle({cx:_20f.cx,cy:_20f.cy,r:r*ro}).setStroke(_212);if(_205.length>0){for(j=_205.length-1;j>=0;--j){_214.createCircle({cx:_20f.cx,cy:_20f.cy,r:_205[j]}).setStroke(_212);}}}len=this._getObjectLength(this.datas);var _215=s.createGroup(),k=0;for(var key in this.datas){data=this.datas[key];min=data.min;max=data.max;_20d=max-min;end=_1fe+2*Math.PI*k/len;for(i=0;i<dv;i++){var text=min+_20d*i/(dv-1);_209=this._getCoordinate(_20f,r*(ro+(1-ro)*i/(dv-1)),end,dim);text=this._getLabel(text);_20a=g._base._getTextBox(text,{font:_1f3}).w||0;_20b=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";if(this.opt.htmlLabels){this.htmlElements.push(da.createText[_20b](this.chart,_215,(!_1e7.isBodyLtr()&&_20b=="html")?(_209.x+_20a-dim.width):_209.x,_209.y,"start",text,_1f3,_1f5));}}k++;}this.chart.seriesShapes={};for(i=this.series.length-1;i>=0;i--){_20c=this.series[i];run=_20c.data;if(run!==null){var _216=t.next("spider",[o,_20c]),f=g.normalizeColor(_216.series.fill),sk={color:_216.series.fill,width:_1fb};f.a=o.seriesFillAlpha;_20c.dyn={fill:f,stroke:sk};if(_20c.hidden){continue;}var _217=[],_218=[];k=0;for(key in run){data=this.datas[key];min=data.min;max=data.max;_20d=max-min;var _219=run[key],end=_1fe+2*Math.PI*k/len;_209=this._getCoordinate(_20f,r*(ro+(1-ro)*(_219-min)/_20d),end,dim);_217.push(_209);_218.push({sname:_20c.name,key:key,data:_219});k++;}_217[_217.length]=_217[0];_218[_218.length]=_218[0];var _21a=this._getBoundary(_217),ts=_20c.group;var osps=this.oldSeriePoints[_20c.name];var cs=this._createSeriesEntry(ts,(osps||_203),_217,f,sk,r,ro,ms,at);this.chart.seriesShapes[_20c.name]=cs;this.oldSeriePoints[_20c.name]=_217;var po={element:"spider_poly",index:i,id:"spider_poly_"+_20c.name,run:_20c,plot:this,shape:cs.poly,parent:ts,brect:_21a,cx:_20f.cx,cy:_20f.cy,cr:r,f:f,s:s};this._connectEvents(po);var so={element:"spider_plot",index:i,id:"spider_plot_"+_20c.name,run:_20c,plot:this,shape:_20c.group};this._connectEvents(so);arr.forEach(cs.circles,function(c,i){var co={element:"spider_circle",index:i,id:"spider_circle_"+_20c.name+i,run:_20c,plot:this,shape:c,parent:ts,tdata:_218[i],cx:_217[i].x,cy:_217[i].y,f:f,s:s};this._connectEvents(co);},this);}}return this;},_createSeriesEntry:function(ts,osps,sps,f,sk,r,ro,ms,at){var _21b=this.animate?osps:sps;var _21c=ts.createPolyline(_21b).setFill(f).setStroke(sk),_21d=[];for(var j=0;j<_21b.length;j++){var _21e=_21b[j],cr=ms;var _21f=ts.createCircle({cx:_21e.x,cy:_21e.y,r:cr}).setFill(f).setStroke(sk);_21d.push(_21f);}if(this.animate){var _220=arr.map(sps,function(np,j){var sp=osps[j],anim=new _1e8.Animation(lang.delegate({duration:1000,easing:at,curve:[sp.y,np.y]},this.animate));var spl=_21c,sc=_21d[j];hub.connect(anim,"onAnimate",function(y){var _221=spl.getShape();_221.points[j].y=y;spl.setShape(_221);var _222=sc.getShape();_222.cy=y;sc.setShape(_222);});return anim;},this);var _223=arr.map(sps,function(np,j){var sp=osps[j],anim=new _1e8.Animation(lang.delegate({duration:1000,easing:at,curve:[sp.x,np.x]},this.animate));var spl=_21c,sc=_21d[j];hub.connect(anim,"onAnimate",function(x){var _224=spl.getShape();_224.points[j].x=x;spl.setShape(_224);var _225=sc.getShape();_225.cx=x;sc.setShape(_225);});return anim;},this);var _226=_1e9.combine(_220.concat(_223));_226.play();}return {group:ts,poly:_21c,circles:_21d};},plotEvent:function(o){if(o.element=="spider_plot"){if(o.type=="onmouseover"&&!has("ie")){o.shape.moveToFront();}}},tooltipFunc:function(o){if(o.element=="spider_circle"){return o.tdata.sname+"<br/>"+o.tdata.key+"<br/>"+o.tdata.data;}else{return null;}},_getBoundary:function(_227){var xmax=_227[0].x,xmin=_227[0].x,ymax=_227[0].y,ymin=_227[0].y;for(var i=0;i<_227.length;i++){var _228=_227[i];xmax=Math.max(_228.x,xmax);ymax=Math.max(_228.y,ymax);xmin=Math.min(_228.x,xmin);ymin=Math.min(_228.y,ymin);}return {x:xmin,y:ymin,width:xmax-xmin,height:ymax-ymin};},_drawArrow:function(s,_229,end,_22a){var len=Math.sqrt(Math.pow(end.x-_229.x,2)+Math.pow(end.y-_229.y,2)),sin=(end.y-_229.y)/len,cos=(end.x-_229.x)/len,_22b={x:end.x+(len/3)*(-sin),y:end.y+(len/3)*cos},_22c={x:end.x+(len/3)*sin,y:end.y+(len/3)*(-cos)};s.createPolyline([_229,_22b,_22c]).setFill(_22a.color).setStroke(_22a);},_buildPoints:function(_22d,_22e,_22f,_230,_231,_232,dim){for(var i=0;i<_22e;i++){var end=_231+2*Math.PI*i/_22e;_22d.push(this._getCoordinate(_22f,_230,end,dim));}if(_232){_22d.push(this._getCoordinate(_22f,_230,_231+2*Math.PI,dim));}},_getCoordinate:function(_233,_234,_235,dim){var x=_233.cx+_234*Math.cos(_235);if(has("dojo-bidi")&&this.chart.isRightToLeft()&&dim){x=dim.width-x;}return {x:x,y:_233.cy+_234*Math.sin(_235)};},_getObjectLength:function(obj){var _236=0;if(lang.isObject(obj)){for(var key in obj){_236++;}}return _236;},_getLabel:function(_237){return dc.getLabel(_237,this.opt.fixed,this.opt.precision);}});return _1ee;});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_238,dojo,_239,_23a,_23b,dom,_23c,geom,_23d,_23e){if(!dojo.isAsync){_23d(0,function(){var _23f=["./fx/Toggler"];_23e(_23f);});}var _240=dojo.fx={};var _241={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _242=function(_243){this._index=-1;this._animations=_243||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_239.forEach(this._animations,function(a){if(a){if(typeof a.duration!="undefined"){this.duration+=a.duration;}if(a.delay){this.duration+=a.delay;}}},this);};_242.prototype=new _238();lang.extend(_242,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_23a.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_23a.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_244,_245){if(!this._current){this._current=this._animations[this._index=0];}if(!_245&&this._current.status()=="playing"){return this;}var _246=_23a.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_247=_23a.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_248=_23a.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_246.remove();_247.remove();_248.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_23a.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_23a.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_23a.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_249,_24a){this.pause();var _24b=this.duration*_249;this._current=null;_239.some(this._animations,function(a,_24c){if(_24b<=a.duration){this._current=a;this._index=_24c;return true;}_24b-=a.duration;return false;},this);if(this._current){this._current.gotoPercent(_24b/this._current.duration);}if(_24a){this.play();}return this;},stop:function(_24d){if(this._current){if(_24d){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_23a.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){this.stop();if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_242,_241);_240.chain=function(_24e){return new _242(lang.isArray(_24e)?_24e:Array.prototype.slice.call(_24e,0));};var _24f=function(_250){this._animations=_250||[];this._connects=[];this._finished=0;this.duration=0;_239.forEach(_250,function(a){var _251=a.duration;if(a.delay){_251+=a.delay;}if(this.duration<_251){this.duration=_251;}this._connects.push(_23a.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _23b.Animation({curve:[0,1],duration:this.duration});var self=this;_239.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_23a.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_24f,{_doAction:function(_252,args){_239.forEach(this._animations,function(a){a[_252].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_253,args){var t=this._pseudoAnimation;t[_253].apply(t,args);},play:function(_254,_255){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_256,_257){var ms=this.duration*_256;_239.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_257);});this._call("gotoPercent",arguments);return this;},stop:function(_258){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){this.stop();_239.forEach(this._connects,function(_259){_259.remove();});}});lang.extend(_24f,_241);_240.combine=function(_25a){return new _24f(lang.isArray(_25a)?_25a:Array.prototype.slice.call(_25a,0));};_240.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_23b.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _25b=_23c.get(node,"height");return Math.max(_25b,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_23a.after(anim,"onStop",fini,true);_23a.after(anim,"onEnd",fini,true);return anim;};_240.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_23b.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_23a.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_23a.after(anim,"onStop",fini,true);_23a.after(anim,"onEnd",fini,true);return anim;};_240.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_23c.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_23b.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_23a.after(anim,"beforeBegin",init,true);return anim;};return _240;});},"dojox/charting/plot2d/Base":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojox/gfx","../Element","./common","../axis2d/common","dojo/has"],function(_25c,arr,lang,gfx,_25d,_25e,ac,has){var Base=_25c("dojox.charting.plot2d.Base",_25d,{constructor:function(_25f,_260){if(_260&&_260.tooltipFunc){this.tooltipFunc=_260.tooltipFunc;}},clear:function(){this.series=[];this.dirty=true;return this;},setAxis:function(axis){return this;},assignAxes:function(axes){arr.forEach(this.axes,function(axis){if(this[axis]){this.setAxis(axes[this[axis]]);}},this);},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _25e.collectSimpleStats(this.series,lang.hitch(this,"isNullValue"));},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},initializeScalers:function(){return this;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},render:function(dim,_261){return this;},renderLabel:function(_262,x,y,_263,_264,_265,_266){var elem=ac.createText[this.opt.htmlLabels&&gfx.renderer!="vml"?"html":"gfx"](this.chart,_262,x,y,_266?_266:"middle",_263,_264.series.font,_264.series.fontColor);if(_265){if(this.opt.htmlLabels&&gfx.renderer!="vml"){elem.style.pointerEvents="none";}else{if(elem.rawNode){elem.rawNode.style.pointerEvents="none";}}}if(this.opt.htmlLabels&&gfx.renderer!="vml"){this.htmlElements.push(elem);}return elem;},getRequiredColors:function(){return this.series.length;},_getLabel:function(_267){return _25e.getLabel(_267,this.opt.fixed,this.opt.precision);}});if(has("dojo-bidi")){Base.extend({_checkOrientation:function(_268,dim,_269){this.chart.applyMirroring(this.group,dim,_269);}});}return Base;});},"dojox/charting/plot2d/_PlotEvents":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(lang,arr,_26a,hub){return _26a("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=lang.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";arr.forEach(this.chart.stack,function(plot){if(plot!==this&&plot.plotEvent){t.plot=plot;plot.plotEvent(t);}},this);},connect:function(_26b,_26c){this.dirty=true;return hub.connect(this,"plotEvent",_26b,_26c);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){arr.forEach(this._shapeEvents,function(item){item.shape.disconnect(item.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_26d){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_26d,this,function(e){o.type=_26d;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_26e){var a=this._eventSeries[_26e];if(a){arr.forEach(a,this._connectEvents,this);}},fireEvent:function(_26f,_270,_271,_272){var s=this._eventSeries[_26f];if(s&&s.length&&_271<s.length){var o=s[_271];o.type=_270;o.event=_272||null;this.raiseEvent(o);o.event=null;}}});});},"dojox/gfx/fx":function(){define(["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect","dojo/sniff"],function(lang,g,m,_273,arr,fx,Hub,has){var fxg=g.fx={};function _274(_275,end){this.start=_275,this.end=end;};_274.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _276(_277,end,_278){this.start=_277,this.end=end;this.units=_278;};_276.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _279(_27a,end){this.start=_27a,this.end=end;this.temp=new _273();};_279.prototype.getValue=function(r){return _273.blendColors(this.start,this.end,r,this.temp);};function _27b(_27c){this.values=_27c;this.length=_27c.length;};_27b.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _27d(_27e,def){this.values=_27e;this.def=def?def:{};};_27d.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _27f(_280,_281){this.stack=_280;this.original=_281;};_27f.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(t.name=="matrix"){if((t.start instanceof m.Matrix2D)&&(t.end instanceof m.Matrix2D)){var _282=new m.Matrix2D();for(var p in t.start){_282[p]=(t.end[p]-t.start[p])*r+t.start[p];}ret.push(_282);}return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_283=f.apply(m,val);if(_283 instanceof m.Matrix2D){ret.push(_283);}},this);return ret;};var _284=new _273(0,0,0,0);function _285(prop,obj,name,def){if(prop.values){return new _27b(prop.values);}var _286,_287,end;if(prop.start){_287=g.normalizeColor(prop.start);}else{_287=_286=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_286){_286=obj?(name?obj[name]:obj):def;}end=_286;}return new _279(_287,end);};function _288(prop,obj,name,def){if(prop.values){return new _27b(prop.values);}var _289,_28a,end;if(prop.start){_28a=prop.start;}else{_28a=_289=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _289!="number"){_289=obj?obj[name]:def;}end=_289;}return new _274(_28a,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_28b=args.shape,_28c;Hub.connect(anim,"beforeBegin",anim,function(){_28c=_28b.getStroke();var prop=args.color,_28d={},_28e,_28f,end;if(prop){_28d.color=_285(prop,_28c,"color",_284);}prop=args.style;if(prop&&prop.values){_28d.style=new _27b(prop.values);}prop=args.width;if(prop){_28d.width=_288(prop,_28c,"width",1);}prop=args.cap;if(prop&&prop.values){_28d.cap=new _27b(prop.values);}prop=args.join;if(prop){if(prop.values){_28d.join=new _27b(prop.values);}else{_28f=prop.start?prop.start:(_28c&&_28c.join||0);end=prop.end?prop.end:(_28c&&_28c.join||0);if(typeof _28f=="number"&&typeof end=="number"){_28d.join=new _274(_28f,end);}}}this.curve=new _27d(_28d,_28c);});Hub.connect(anim,"onAnimate",_28b,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_290=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=_290.getFill();var prop=args.color,_291={};if(prop){this.curve=_285(prop,fill,"",_284);}});Hub.connect(anim,"onAnimate",_290,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_292=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=_292.getFont();var prop=args.style,_293={},_294,_295,end;if(prop&&prop.values){_293.style=new _27b(prop.values);}prop=args.variant;if(prop&&prop.values){_293.variant=new _27b(prop.values);}prop=args.weight;if(prop&&prop.values){_293.weight=new _27b(prop.values);}prop=args.family;if(prop&&prop.values){_293.family=new _27b(prop.values);}prop=args.size;if(prop&&prop.units){_295=parseFloat(prop.start?prop.start:(_292.font&&_292.font.size||"0"));end=parseFloat(prop.end?prop.end:(_292.font&&_292.font.size||"0"));_293.size=new _276(_295,end,prop.units);}this.curve=new _27d(_293,font);});Hub.connect(anim,"onAnimate",_292,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_296=args.shape,_297;Hub.connect(anim,"beforeBegin",anim,function(){_297=_296.getTransform();this.curve=new _27f(args.transform,_297);});Hub.connect(anim,"onAnimate",_296,"setTransform");if(g.renderer==="svg"&&(has("ie")>=9||has("ff"))){var _298=[Hub.connect(anim,"onBegin",anim,function(){var _299=_296.getParent();while(_299&&_299.getParent){_299=_299.getParent();}if(_299){_296.__svgContainer=_299.rawNode.parentNode;_296.__svgRoot=_299.rawNode;if(_296.__svgRoot&&_296.__svgRoot.getAttribute){_296.__svgWidth=parseInt(_296.__svgRoot.getAttribute("width"),10);if(isNaN(_296.__svgWidth)){delete _296.__svgWidth;}}}}),Hub.connect(anim,"onAnimate",anim,function(){try{if(_296.__svgContainer){var ov=_296.__svgContainer.style.visibility;_296.__svgContainer.style.visibility="visible";var _29a=_296.__svgContainer.offsetHeight;_296.__svgContainer.style.visibility=ov;var _29b=_296.__svgWidth;if(!isNaN(_29b)){try{_296.__svgRoot.setAttribute("width",_29b-0.000005);_296.__svgRoot.setAttribute("width",_29b);}catch(ignore){}}}}catch(e){}}),Hub.connect(anim,"onEnd",anim,function(){arr.forEach(_298,Hub.disconnect);if(_296.__svgContainer){var sn=_296.__svgContainer;if(sn.getAttribute("__gotVis")==null){sn.setAttribute("__gotVis",true);var ov=_296.__svgContainer.style.visibility;var root=_296.__svgRoot;var _29c=_296.__svgWidth;sn.style.visibility="visible";setTimeout(function(){try{sn.style.visibility=ov;sn.removeAttribute("__gotVis");sn=null;try{if(!isNaN(_29c)){root.setAttribute("width",_29c-0.000005);root.setAttribute("width",_29c);}}catch(ignore){}}catch(e){}},100);}}delete _296.__svgContainer;delete _296.__svgRoot;delete _296.__svgWidth;})];}return anim;};return fxg;});},"dojo/fx/easing":function(){define(["../_base/lang"],function(lang){var _29d={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_29d.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _29d.bounceIn(n*2)/2;}return (_29d.bounceOut(n*2-1)/2)+0.5;}};lang.setObject("dojo.fx.easing",_29d);return _29d;});},"dojox/charting/themes/PlotKit/blue":function(){define(["./base","../../Theme"],function(pk,_29e){pk.blue=pk.base.clone();pk.blue.chart.fill=pk.blue.plotarea.fill="#e7eef6";pk.blue.colors=_29e.defineColors({hue:217,saturation:60,low:40,high:88});return pk.blue;});},"dojox/charting/themes/PlotKit/base":function(){define(["dojo/_base/lang","dojo/_base/Color","../../Theme","../common"],function(lang,_29f,_2a0,_2a1){var pk=lang.getObject("PlotKit",true,_2a1);pk.base=new _2a0({chart:{stroke:null,fill:"yellow"},plotarea:{stroke:null,fill:"yellow"},axis:{stroke:{color:"#fff",width:1},line:{color:"#fff",width:0.5},majorTick:{color:"#fff",width:0.5,length:6},minorTick:{color:"#fff",width:0.5,length:3},tick:{font:"normal normal normal 7pt Helvetica,Arial,sans-serif",fontColor:"#999"}},series:{stroke:{width:2.5,color:"#fff"},fill:"#666",font:"normal normal normal 7.5pt Helvetica,Arial,sans-serif",fontColor:"#666"},marker:{stroke:{width:2},fill:"#333",font:"normal normal normal 7pt Helvetica,Arial,sans-serif",fontColor:"#666"},colors:["red","green","blue"]});pk.base.next=function(_2a2,_2a3,_2a4){var _2a5=_2a0.prototype.next.apply(this,arguments);if(_2a2=="line"){_2a5.marker.outline={width:2,color:"#fff"};_2a5.series.stroke.width=3.5;_2a5.marker.stroke.width=2;}else{if(_2a2=="candlestick"){_2a5.series.stroke.width=1;}else{if(_2a5.series.stroke.color&&(_2a5.series.stroke.color.toString()==new _29f(this.colors[(this._current-1)%this.colors.length]).toString())){_2a5.series.stroke.color="#fff";}}}return _2a5;};return pk;});},"dojox/charting/Theme":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","./SimpleTheme","dojox/color/_base","dojox/color/Palette","dojox/gfx/gradutils"],function(lang,_2a6,_2a7,_2a8,_2a9,_2aa){var _2ab=_2a6("dojox.charting.Theme",_2a8,{});lang.mixin(_2ab,{defineColors:function(_2ac){_2ac=_2ac||{};var l,c=[],n=_2ac.num||5;if(_2ac.colors){l=_2ac.colors.length;for(var i=0;i<n;i++){c.push(_2ac.colors[i%l]);}return c;}if(_2ac.hue){var s=_2ac.saturation||100,st=_2ac.low||30,end=_2ac.high||90;l=(end+st)/2;return _2aa.generate(_2a9.fromHsv(_2ac.hue,s,l),"monochromatic").colors;}if(_2ac.generator){return _2a9.Palette.generate(_2ac.base,_2ac.generator).colors;}return c;},generateGradient:function(_2ad,_2ae,_2af){var fill=lang.delegate(_2ad);fill.colors=[{offset:0,color:_2ae},{offset:1,color:_2af}];return fill;},generateHslColor:function(_2b0,_2b1){_2b0=new _2a7(_2b0);var hsl=_2b0.toHsl(),_2b2=_2a9.fromHsl(hsl.h,hsl.s,_2b1);_2b2.a=_2b0.a;return _2b2;},generateHslGradient:function(_2b3,_2b4,_2b5,_2b6){_2b3=new _2a7(_2b3);var hsl=_2b3.toHsl(),_2b7=_2a9.fromHsl(hsl.h,hsl.s,_2b5),_2b8=_2a9.fromHsl(hsl.h,hsl.s,_2b6);_2b7.a=_2b8.a=_2b3.a;return _2ab.generateGradient(_2b4,_2b7,_2b8);}});_2ab.defaultMarkers=_2a8.defaultMarkers;_2ab.defaultColors=_2a8.defaultColors;_2ab.defaultTheme=_2a8.defaultTheme;return _2ab;});},"dojox/color/_base":function(){define(["../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(_2b9,lang,_2ba,_2bb){var cx=lang.getObject("color",true,_2b9);cx.Color=_2ba;cx.blend=_2ba.blendColors;cx.fromRgb=_2ba.fromRgb;cx.fromHex=_2ba.fromHex;cx.fromArray=_2ba.fromArray;cx.fromString=_2ba.fromString;cx.greyscale=_2bb.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_2bc,_2bd){if(lang.isArray(cyan)){_2bc=cyan[1],_2bd=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_2bc=cyan.m,_2bd=cyan.y,cyan=cyan.c;}}cyan/=100,_2bc/=100,_2bd/=100;var r=1-cyan,g=1-_2bc,b=1-_2bd;return new _2ba({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_2be,_2bf,_2c0){if(lang.isArray(cyan)){_2be=cyan[1],_2bf=cyan[2],_2c0=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_2be=cyan.m,_2bf=cyan.y,_2c0=cyan.b,cyan=cyan.c;}}cyan/=100,_2be/=100,_2bf/=100,_2c0/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_2c0)+_2c0);g=1-Math.min(1,_2be*(1-_2c0)+_2c0);b=1-Math.min(1,_2bf*(1-_2c0)+_2c0);return new _2ba({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_2c1,_2c2){if(lang.isArray(hue)){_2c1=hue[1],_2c2=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_2c1=hue.s,_2c2=hue.l,hue=hue.h;}}_2c1/=100;_2c2/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_2c1*Math.min(r,1)+(1-_2c1);g=2*_2c1*Math.min(g,1)+(1-_2c1);b=2*_2c1*Math.min(b,1)+(1-_2c1);if(_2c2<0.5){r*=_2c2,g*=_2c2,b*=_2c2;}else{r=(1-_2c2)*r+2*_2c2-1;g=(1-_2c2)*g+2*_2c2-1;b=(1-_2c2)*b+2*_2c2-1;}return new _2ba({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_2c3,_2c4){if(lang.isArray(hue)){_2c3=hue[1],_2c4=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_2c3=hue.s,_2c4=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_2c3/=100;_2c4/=100;var r,g,b;if(_2c3==0){r=_2c4,b=_2c4,g=_2c4;}else{var _2c5=hue/60,i=Math.floor(_2c5),f=_2c5-i;var p=_2c4*(1-_2c3);var q=_2c4*(1-(_2c3*f));var t=_2c4*(1-(_2c3*(1-f)));switch(i){case 0:r=_2c4,g=t,b=p;break;case 1:r=q,g=_2c4,b=p;break;case 2:r=p,g=_2c4,b=t;break;case 3:r=p,g=q,b=_2c4;break;case 4:r=t,g=p,b=_2c4;break;case 5:r=_2c4,g=p,b=q;break;}}return new _2ba({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_2ba,{toCmy:function(){var cyan=1-(this.r/255),_2c6=1-(this.g/255),_2c7=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_2c6*100),y:Math.round(_2c7*100)};},toCmyk:function(){var cyan,_2c8,_2c9,_2ca;var r=this.r/255,g=this.g/255,b=this.b/255;_2ca=Math.min(1-r,1-g,1-b);cyan=(1-r-_2ca)/(1-_2ca);_2c8=(1-g-_2ca)/(1-_2ca);_2c9=(1-b-_2ca)/(1-_2ca);return {c:Math.round(cyan*100),m:Math.round(_2c8*100),y:Math.round(_2c9*100),b:Math.round(_2ca*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _2cb=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_2cb/((l<0.5)?(2*l):(2-2*l));}if(_2cb>0){if(max==r&&max!=g){h+=(g-b)/_2cb;}if(max==g&&max!=b){h+=(2+(b-r)/_2cb);}if(max==b&&max!=r){h+=(4+(r-g)/_2cb);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _2cc=max-min;var h=null,s=(max==0)?0:(_2cc/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_2cc;}else{if(g==max){h=120+60*(b-r)/_2cc;}else{h=240+60*(r-g)/_2cc;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_2cd,_2ce){var _2cf={};lang.setObject("dojo.colors",_2cf);var _2d0=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_2cd.fromRgb=function(_2d1,obj){var m=_2d1.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_2ce.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _2cd.fromArray(a,obj);}return _2cd.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_2d0(m1,m2,H+1/3)*256,_2d0(m1,m2,H)*256,_2d0(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _2cd.fromArray(a,obj);}}return null;};var _2d2=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_2cd.prototype.sanitize=function(){var t=this;t.r=Math.round(_2d2(t.r,0,255));t.g=Math.round(_2d2(t.g,0,255));t.b=Math.round(_2d2(t.b,0,255));t.a=_2d2(t.a,0,1);return this;};_2cf.makeGrey=_2cd.makeGrey=function(g,a){return _2cd.fromArray([g,g,g,a]);};lang.mixin(_2cd.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _2cd;});},"dojox/color/Palette":function(){define(["dojo/_base/lang","dojo/_base/array","./_base"],function(lang,arr,dxc){dxc.Palette=function(base){this.colors=[];if(base instanceof dxc.Palette){this.colors=base.colors.slice(0);}else{if(base instanceof dxc.Color){this.colors=[null,null,base,null,null];}else{if(lang.isArray(base)){this.colors=arr.map(base.slice(0),function(item){if(lang.isString(item)){return new dxc.Color(item);}return item;});}else{if(lang.isString(base)){this.colors=[null,null,new dxc.Color(base),null,null];}}}}};function _2d3(p,_2d4,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var r=(_2d4=="dr")?item.r+val:item.r,g=(_2d4=="dg")?item.g+val:item.g,b=(_2d4=="db")?item.b+val:item.b,a=(_2d4=="da")?item.a+val:item.a;ret.colors.push(new dxc.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});return ret;};function tCMY(p,_2d5,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmy(),c=(_2d5=="dc")?o.c+val:o.c,m=(_2d5=="dm")?o.m+val:o.m,y=(_2d5=="dy")?o.y+val:o.y;ret.colors.push(dxc.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;};function _2d6(p,_2d7,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmyk(),c=(_2d7=="dc")?o.c+val:o.c,m=(_2d7=="dm")?o.m+val:o.m,y=(_2d7=="dy")?o.y+val:o.y,k=(_2d7=="dk")?o.b+val:o.b;ret.colors.push(dxc.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;};function tHSL(p,_2d8,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsl(),h=(_2d8=="dh")?o.h+val:o.h,s=(_2d8=="ds")?o.s+val:o.s,l=(_2d8=="dl")?o.l+val:o.l;ret.colors.push(dxc.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;};function tHSV(p,_2d9,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsv(),h=(_2d9=="dh")?o.h+val:o.h,s=(_2d9=="ds")?o.s+val:o.s,v=(_2d9=="dv")?o.v+val:o.v;ret.colors.push(dxc.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;};function _2da(val,low,high){return high-((high-val)*((high-low)/high));};lang.extend(dxc.Palette,{transform:function(_2db){var fn=_2d3;if(_2db.use){var use=_2db.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=tHSL;}else{fn=tHSV;}}else{if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=_2d6;}else{fn=tCMY;}}}}else{if("dc" in _2db||"dm" in _2db||"dy" in _2db){if("dk" in _2db){fn=_2d6;}else{fn=tCMY;}}else{if("dh" in _2db||"ds" in _2db){if("dv" in _2db){fn=tHSV;}else{fn=tHSL;}}}}var _2dc=this;for(var p in _2db){if(p=="use"){continue;}_2dc=fn(_2dc,p,_2db[p]);}return _2dc;},clone:function(){return new dxc.Palette(this);}});lang.mixin(dxc.Palette,{generators:{analogous:function(args){var high=args.high||60,low=args.low||18,base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(high/2)+360)%360,(hsv.h-high+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2];return new dxc.Palette(arr.map(h,function(hue,i){return dxc.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=_2da(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v3),base,dxc.fromHsv(hsv.h,s1,v3),dxc.fromHsv(hsv.h,s2,v2)]);},triadic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,hsv.v),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h2,s2,v1),dxc.fromHsv(h2,s3,v3)]);},complementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=_2da(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h1,s3,v2),dxc.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,_2dd=args.da||30,hsv=base.toHsv();var _2de=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(_2de-_2dd+360)%360,h2=(_2de+_2dd)%360,s1=Math.max(hsv.s-10,0),s2=_2da(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v2),dxc.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v3),dxc.fromHsv(h3,s2,v2)]);},shades:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dxc.fromHsv(hsv.h,s,v1),new dxc.fromHsv(hsv.h,s,v2),base,new dxc.fromHsv(hsv.h,s,v3),new dxc.fromHsv(hsv.h,s,v4)]);}},generate:function(base,type){if(lang.isFunction(type)){return type({base:base});}else{if(dxc.Palette.generators[type]){return dxc.Palette.generators[type]({base:base});}}throw new Error("dojox.color.Palette.generate: the specified generator ('"+type+"') does not exist.");}});return dxc.Palette;});},"dojox/charting/themes/common":function(){define(["dojo/_base/lang"],function(lang){return lang.getObject("dojox.charting.themes",true);});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_2df,_2e0,fx,dom,_2e1,_2e2,_2e3,lang,_2e4,on,has,_2e5,_2e6,_2e7,_2e8,_2e9,_2ea,_2eb){var _2ec=_2e0("dijit._MasterTooltip",[_2e7,_2e8],{duration:_2e5.defaultDuration,templateString:_2ea,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _2e9(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_2ed,_2ee,_2ef,rtl,_2f0,_2f1,_2f2){if(this.aroundNode&&this.aroundNode===_2ee&&this.containerNode.innerHTML==_2ed){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_2ed;if(_2f0){this.set("textDir",_2f0);}this.containerNode.align=rtl?"right":"left";var pos=_2e6.around(this.domNode,_2ee,_2ef&&_2ef.length?_2ef:_2f3.defaultPosition,!rtl,lang.hitch(this,"orient"));var _2f4=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_2f4.y+((_2f4.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_2f4.x+((_2f4.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_2e3.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_2ee;this.onMouseEnter=_2f1||noop;this.onMouseLeave=_2f2||noop;},orient:function(node,_2f5,_2f6,_2f7,_2f8){this.connectorNode.style.top="";var _2f9=_2f7.h,_2fa=_2f7.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_2f5+"-"+_2f6];this.domNode.style.width="auto";var size=_2e2.position(this.domNode);if(has("ie")||has("trident")){size.w+=2;}var _2fb=Math.min((Math.max(_2fa,1)),size.w);_2e2.setMarginBox(this.domNode,{w:_2fb});if(_2f6.charAt(0)=="B"&&_2f5.charAt(0)=="B"){var bb=_2e2.position(node);var _2fc=this.connectorNode.offsetHeight;if(bb.h>_2f9){var _2fd=_2f9-((_2f8.h+_2fc)>>1);this.connectorNode.style.top=_2fd+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_2f8.h/2-_2fc/2,0),bb.h-_2fc)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_2fa);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_2fe){if(this._onDeck&&this._onDeck[1]==_2fe){this._onDeck=null;}else{if(this.aroundNode===_2fe){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}this.onMouseEnter=this.onMouseLeave=noop;},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_2ec.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_2df.forEach(node.children,function(_2ff){this._setAutoTextDir(_2ff);},this);},_setTextDirAttr:function(_300){this._set("textDir",_300);if(_300=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_2eb.showTooltip=function(_301,_302,_303,rtl,_304,_305,_306){if(_303){_303=_2df.map(_303,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_2f3._masterTT){_2eb._masterTT=_2f3._masterTT=new _2ec();}return _2f3._masterTT.show(_301,_302,_303,rtl,_304,_305,_306);};_2eb.hideTooltip=function(_307){return _2f3._masterTT&&_2f3._masterTT.hide(_307);};var _308="DORMANT",_309="SHOW TIMER",_30a="SHOWING",_30b="HIDE TIMER";function noop(){};var _2f3=_2e0("dijit.Tooltip",_2e7,{label:"",showDelay:400,hideDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_30c){_2df.forEach(this._connections||[],function(_30d){_2df.forEach(_30d,function(_30e){_30e.remove();});},this);this._connectIds=_2df.filter(lang.isArrayLike(_30c)?_30c:(_30c?[_30c]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_2df.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_30f=this.selector,_310=_30f?function(_311){return on.selector(_30f,_311);}:function(_312){return _312;},self=this;return [on(node,_310(_2e4.enter),function(){self._onHover(this);}),on(node,_310("focusin"),function(){self._onHover(this);}),on(node,_310(_2e4.leave),lang.hitch(self,"_onUnHover")),on(node,_310("focusout"),lang.hitch(self,"set","state",_308))];},this);this._set("connectId",_30c);},addTarget:function(node){var id=node.id||node;if(_2df.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_2df.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_2e1.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_2df.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},state:_308,_setStateAttr:function(val){if(this.state==val||(val==_309&&this.state==_30a)||(val==_30b&&this.state==_308)){return;}if(this._hideTimer){this._hideTimer.remove();delete this._hideTimer;}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}switch(val){case _308:if(this._connectNode){_2f3.hide(this._connectNode);delete this._connectNode;this.onHide();}break;case _309:if(this.state!=_30a){this._showTimer=this.defer(function(){this.set("state",_30a);},this.showDelay);}break;case _30a:var _313=this.getContent(this._connectNode);if(!_313){this.set("state",_308);return;}_2f3.show(_313,this._connectNode,this.position,!this.isLeftToRight(),this.textDir,lang.hitch(this,"set","state",_30a),lang.hitch(this,"set","state",_30b));this.onShow(this._connectNode,this.position);break;case _30b:this._hideTimer=this.defer(function(){this.set("state",_308);},this.hideDelay);break;}this._set("state",val);},_onHover:function(_314){if(this._connectNode&&_314!=this._connectNode){this.set("state",_308);}this._connectNode=_314;this.set("state",_309);},_onUnHover:function(_315){this.set("state",_30b);},open:function(_316){this.set("state",_308);this._connectNode=_316;this.set("state",_30a);},close:function(){this.set("state",_308);},onShow:function(){},onHide:function(){},destroy:function(){this.set("state",_308);_2df.forEach(this._connections||[],function(_317){_2df.forEach(_317,function(_318){_318.remove();});},this);this.inherited(arguments);}});_2f3._MasterTooltip=_2ec;_2f3.show=_2eb.showTooltip;_2f3.hide=_2eb.hideTooltip;_2f3.defaultPosition=["after-centered","before-centered"];return _2f3;});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_319,_31a,lang,_31b,_31c){var _31d={};_319.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_31d[name]=_31b[name];});lang.mixin(_31d,{defaultDuration:_31a["defaultDuration"]||200});lang.mixin(_31c,_31d);return _31c;});},"dijit/registry":function(){define(["dojo/_base/array","dojo/_base/window","./main"],function(_31e,win,_31f){var _320={},hash={};var _321={length:0,add:function(_322){if(hash[_322.id]){throw new Error("Tried to register widget with id=="+_322.id+" but that id is already registered");}hash[_322.id]=_322;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_323){var id;do{id=_323+"_"+(_323 in _320?++_320[_323]:_320[_323]=0);}while(hash[id]);return _31f._scopeName=="dijit"?id:_31f._scopeName+"_"+id;},findWidgets:function(root,_324){var _325=[];function _326(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _327=node.getAttribute("widgetId");if(_327){var _328=hash[_327];if(_328){_325.push(_328);}}else{if(node!==_324){_326(node);}}}}};_326(root);return _325;},_destroyAll:function(){_31f._curFocus=null;_31f._prevFocus=null;_31f._activeStack=[];_31e.forEach(_321.findWidgets(win.body()),function(_329){if(!_329._destroyed){if(_329.destroyRecursive){_329.destroyRecursive();}else{if(_329.destroy){_329.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_31f.registry=_321;return _321;});},"dijit/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_32a,_32b,_32c,_32d,win,_32e,_32f){function _330(node,_331,_332,_333){var view=_32e.getEffectiveBox(node.ownerDocument);if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body(node.ownerDocument).appendChild(node);}var best=null;_32a.some(_331,function(_334){var _335=_334.corner;var pos=_334.pos;var _336=0;var _337={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_335.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_335.charAt(0)]};var s=node.style;s.left=s.right="auto";if(_332){var res=_332(node,_334.aroundCorner,_335,_337,_333);_336=typeof res=="undefined"?0:res;}var _338=node.style;var _339=_338.display;var _33a=_338.visibility;if(_338.display=="none"){_338.visibility="hidden";_338.display="";}var bb=_32b.position(node);_338.display=_339;_338.visibility=_33a;var _33b={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_335.charAt(1)],_33c={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_335.charAt(0)],_33d=Math.max(view.l,_33b),_33e=Math.max(view.t,_33c),endX=Math.min(view.l+view.w,_33b+bb.w),endY=Math.min(view.t+view.h,_33c+bb.h),_33f=endX-_33d,_340=endY-_33e;_336+=(bb.w-_33f)+(bb.h-_340);if(best==null||_336<best.overflow){best={corner:_335,aroundCorner:_334.aroundCorner,x:_33d,y:_33e,w:_33f,h:_340,overflow:_336,spaceAvailable:_337};}return !_336;});if(best.overflow&&_332){_332(node,best.aroundCorner,best.corner,best.spaceAvailable,_333);}var top=best.y,side=best.x,body=win.body(node.ownerDocument);if(/relative|absolute/.test(_32c.get(body,"position"))){top-=_32c.get(body,"marginTop");side-=_32c.get(body,"marginLeft");}var s=node.style;s.top=top+"px";s.left=side+"px";s.right="auto";return best;};var _341={"TL":"BR","TR":"BL","BL":"TR","BR":"TL"};var _342={at:function(node,pos,_343,_344,_345){var _346=_32a.map(_343,function(_347){var c={corner:_347,aroundCorner:_341[_347],pos:{x:pos.x,y:pos.y}};if(_344){c.pos.x+=_347.charAt(1)=="L"?_344.x:-_344.x;c.pos.y+=_347.charAt(0)=="T"?_344.y:-_344.y;}return c;});return _330(node,_346,_345);},around:function(node,_348,_349,_34a,_34b){var _34c;if(typeof _348=="string"||"offsetWidth" in _348||"ownerSVGElement" in _348){_34c=_32b.position(_348,true);if(/^(above|below)/.test(_349[0])){var _34d=_32b.getBorderExtents(_348),_34e=_348.firstChild?_32b.getBorderExtents(_348.firstChild):{t:0,l:0,b:0,r:0},_34f=_32b.getBorderExtents(node),_350=node.firstChild?_32b.getBorderExtents(node.firstChild):{t:0,l:0,b:0,r:0};_34c.y+=Math.min(_34d.t+_34e.t,_34f.t+_350.t);_34c.h-=Math.min(_34d.t+_34e.t,_34f.t+_350.t)+Math.min(_34d.b+_34e.b,_34f.b+_350.b);}}else{_34c=_348;}if(_348.parentNode){var _351=_32c.getComputedStyle(_348).position=="absolute";var _352=_348.parentNode;while(_352&&_352.nodeType==1&&_352.nodeName!="BODY"){var _353=_32b.position(_352,true),pcs=_32c.getComputedStyle(_352);if(/relative|absolute/.test(pcs.position)){_351=false;}if(!_351&&/hidden|auto|scroll/.test(pcs.overflow)){var _354=Math.min(_34c.y+_34c.h,_353.y+_353.h);var _355=Math.min(_34c.x+_34c.w,_353.x+_353.w);_34c.x=Math.max(_34c.x,_353.x);_34c.y=Math.max(_34c.y,_353.y);_34c.h=_354-_34c.y;_34c.w=_355-_34c.x;}if(pcs.position=="absolute"){_351=true;}_352=_352.parentNode;}}var x=_34c.x,y=_34c.y,_356="w" in _34c?_34c.w:(_34c.w=_34c.width),_357="h" in _34c?_34c.h:(_32d.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_34c.height+", width:"+_356+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_34c.height+", w:"+_356+" }","","2.0"),_34c.h=_34c.height);var _358=[];function push(_359,_35a){_358.push({aroundCorner:_359,corner:_35a,pos:{x:{"L":x,"R":x+_356,"M":x+(_356>>1)}[_359.charAt(1)],y:{"T":y,"B":y+_357,"M":y+(_357>>1)}[_359.charAt(0)]}});};_32a.forEach(_349,function(pos){var ltr=_34a;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _35b=_330(node,_358,_34b,{w:_356,h:_357});_35b.aroundNodePos=_34c;return _35b;}};return _32f.place=_342;});},"dijit/Viewport":function(){define(["dojo/Evented","dojo/on","dojo/domReady","dojo/sniff","dojo/window"],function(_35c,on,_35d,has,_35e){var _35f=new _35c();var _360;_35d(function(){var _361=_35e.getBox();_35f._rlh=on(window,"resize",function(){var _362=_35e.getBox();if(_361.h==_362.h&&_361.w==_362.w){return;}_361=_362;_35f.emit("resize");});if(has("ie")==8){var _363=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_363){_363=screen.deviceXDPI;_35f.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_360=evt.target;});on(document,"focusout",function(evt){_360=null;});}});_35f.getEffectiveBox=function(doc){var box=_35e.getBox(doc);var tag=_360&&_360.tagName&&_360.tagName.toLowerCase();if(has("ios")&&_360&&!_360.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_360.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var rect=_360.getBoundingClientRect();box.h=Math.max(box.h,rect.top+rect.height);}return box;};return _35f;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_364,dom,geom,_365,_366){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_364.body(doc),_367=_366.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_366.create("div",{style:{overflow:"hidden",direction:"ltr"}},_367,"last"),ret=geom.position(div).x!=0;_367.removeChild(div);body.removeChild(_367);return ret;});has.add("position-fixed-support",function(win,doc){var body=_364.body(doc),_368=_366.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_369=_366.create("span",{style:{position:"fixed",left:"0",top:"0"}},_368,"last"),ret=geom.position(_369).x!=geom.position(_368).x;_368.removeChild(_369);body.removeChild(_368);return ret;});var _36a={getBox:function(doc){doc=doc||_364.doc;var _36b=(doc.compatMode=="BackCompat")?_364.body(doc):doc.documentElement,_36c=geom.docScroll(doc),w,h;if(has("touch")){var _36d=_36a.get(doc);w=_36d.innerWidth||_36b.clientWidth;h=_36d.innerHeight||_36b.clientHeight;}else{w=_36b.clientWidth;h=_36b.clientHeight;}return {l:_36c.x,t:_36c.y,w:w,h:h};},get:function(doc){if(has("ie")&&_36a!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_364.doc,body=_364.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie")||has("trident"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera")||has("trident")||has("edge"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _36e=doc.compatMode=="BackCompat",_36f=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_370=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_371=(isWK||_36e)?body:html,_372=pos||geom.position(node),el=node.parentNode,_373=function(el){return (isIE<=6||(isIE==7&&_36e))?false:(has("position-fixed-support")&&(_365.get(el,"position").toLowerCase()=="fixed"));},self=this,_374=function(el,x,y){if(el.tagName=="BODY"||el.tagName=="HTML"){self.get(el.ownerDocument).scrollBy(x,y);}else{x&&(el.scrollLeft+=x);y&&(el.scrollTop+=y);}};if(_373(node)){return;}while(el){if(el==body){el=_371;}var _375=geom.position(el),_376=_373(el),rtl=_365.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_371){_375.w=_36f;_375.h=_370;if(_371==html&&(isIE||has("trident"))&&rtl){_375.x+=_371.offsetWidth-_375.w;}_375.x=0;_375.y=0;}else{var pb=geom.getPadBorderExtents(el);_375.w-=pb.w;_375.h-=pb.h;_375.x+=pb.l;_375.y+=pb.t;var _377=el.clientWidth,_378=_375.w-_377;if(_377>0&&_378>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_375.x+=_378;}_375.w=_377;}_377=el.clientHeight;_378=_375.h-_377;if(_377>0&&_378>0){_375.h=_377;}}if(_376){if(_375.y<0){_375.h+=_375.y;_375.y=0;}if(_375.x<0){_375.w+=_375.x;_375.x=0;}if(_375.y+_375.h>_370){_375.h=_370-_375.y;}if(_375.x+_375.w>_36f){_375.w=_36f-_375.x;}}var l=_372.x-_375.x,t=_372.y-_375.y,r=l+_372.w-_375.w,bot=t+_372.h-_375.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_371||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_36e)||has("trident")>=5)){s=-s;}old=el.scrollLeft;_374(el,s,0);s=el.scrollLeft-old;_372.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_371||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;_374(el,0,s);s=el.scrollTop-old;_372.y-=s;}el=(el!=_371)&&!_376&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_36a);return _36a;});},"dijit/_Widget":function(){define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_379,_37a,_37b,_37c,has,_37d,lang,_37e,_37f,_380,_381,_382,_383){function _384(){};function _385(_386){return function(obj,_387,_388,_389){if(obj&&typeof _387=="string"&&obj[_387]==_384){return obj.on(_387.substring(2).toLowerCase(),lang.hitch(_388,_389));}return _386.apply(_37b,arguments);};};_379.around(_37b,"connect",_385);if(_37d.connect){_379.around(_37d,"connect",_385);}var _38a=_37c("dijit._Widget",[_381,_382,_383],{onClick:_384,onDblClick:_384,onKeyDown:_384,onKeyPress:_384,onKeyUp:_384,onMouseDown:_384,onMouseMove:_384,onMouseOut:_384,onMouseOver:_384,onMouseLeave:_384,onMouseEnter:_384,onMouseUp:_384,constructor:function(_38b){this._toConnect={};for(var name in _38b){if(this[name]===_384){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_38b[name];delete _38b[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_384){return _37b.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_38c){_37d.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_38c);},attr:function(name,_38d){var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_37d.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_37e("[widgetId]",this.containerNode).map(_380.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_37f(0,function(){var _38e=["dijit/_base"];require(_38e);});}return _38a;});},"dijit/_WidgetBase":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","dojo/has!dojo-bidi?./_BidiMixin","./registry"],function(_38f,_390,_391,_392,_393,_394,dom,_395,_396,_397,_398,_399,has,_39a,lang,on,_39b,_39c,_39d,win,_39e,_39f,_3a0){has.add("dijit-legacy-requires",!_39a.isAsync);has.add("dojo-bidi",false);if(has("dijit-legacy-requires")){_39b(0,function(){var _3a1=["dijit/_base/manager"];_38f(_3a1);});}var _3a2={};function _3a3(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _3a4(attr){return function(val){_395[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};function _3a5(a,b){return a===b||(a!==a&&b!==b);};var _3a6=_394("dijit._WidgetBase",[_39c,_39e],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_3a4("lang"),dir:"",_setDirAttr:_3a4("dir"),"class":"",_setClassAttr:{node:"domNode",type:"class"},_setTypeAttr:null,style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_392.blankGif||_38f.toUrl("dojo/resources/blank.gif"),textDir:"",_introspect:function(){var ctor=this.constructor;if(!ctor._setterAttrs){var _3a7=ctor.prototype,_3a8=ctor._setterAttrs=[],_3a9=(ctor._onMap={});for(var name in _3a7.attributeMap){_3a8.push(name);}for(name in _3a7){if(/^on/.test(name)){_3a9[name.substring(2).toLowerCase()]=name;}if(/^_set[A-Z](.*)Attr$/.test(name)){name=name.charAt(4).toLowerCase()+name.substr(5,name.length-9);if(!_3a7.attributeMap||!(name in _3a7.attributeMap)){_3a8.push(name);}}}}},postscript:function(_3aa,_3ab){this.create(_3aa,_3ab);},create:function(_3ac,_3ad){this._introspect();this.srcNodeRef=dom.byId(_3ad);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&this.srcNodeRef.id&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_3ac){this.params=_3ac;lang.mixin(this,_3ac);}this.postMixInProperties();if(!this.id){this.id=_3a0.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:document);this.ownerDocumentBody=win.body(this.ownerDocument);_3a0.add(this);this.buildRendering();var _3ae;if(this.domNode){this._applyAttributes();var _3af=this.srcNodeRef;if(_3af&&_3af.parentNode&&this.domNode!==_3af){_3af.parentNode.replaceChild(this.domNode,_3af);_3ae=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_3ae){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var _3b0={};for(var key in this.params||{}){_3b0[key]=this._get(key);}_390.forEach(this.constructor._setterAttrs,function(key){if(!(key in _3b0)){var val=this._get(key);if(val){this.set(key,val);}}},this);for(key in _3b0){this.set(key,_3b0[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _3b1=this.baseClass.split(" ");if(!this.isLeftToRight()){_3b1=_3b1.concat(_390.map(_3b1,function(name){return name+"Rtl";}));}_396.add(this.domNode,_3b1);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_390.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_3b2){this._beingDestroyed=true;this.destroyDescendants(_3b2);this.destroy(_3b2);},destroy:function(_3b3){this._beingDestroyed=true;this.uninitialize();function _3b4(w){if(w.destroyRecursive){w.destroyRecursive(_3b3);}else{if(w.destroy){w.destroy(_3b3);}}};_390.forEach(this._connects,lang.hitch(this,"disconnect"));_390.forEach(this._supportingWidgets,_3b4);if(this.domNode){_390.forEach(_3a0.findWidgets(this.domNode,this.containerNode),_3b4);}this.destroyRendering(_3b3);_3a0.remove(this.id);this._destroyed=true;},destroyRendering:function(_3b5){if(this.bgIframe){this.bgIframe.destroy(_3b5);delete this.bgIframe;}if(this.domNode){if(_3b5){_395.remove(this.domNode,"widgetId");}else{_397.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_3b5){_397.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_3b6){_390.forEach(this.getChildren(),function(_3b7){if(_3b7.destroyRecursive){_3b7.destroyRecursive(_3b6);}});},uninitialize:function(){return false;},_setStyleAttr:function(_3b8){var _3b9=this.domNode;if(lang.isObject(_3b8)){_399.set(_3b9,_3b8);}else{if(_3b9.style.cssText){_3b9.style.cssText+="; "+_3b8;}else{_3b9.style.cssText=_3b8;}}this._set("style",_3b8);},_attrToDom:function(attr,_3ba,_3bb){_3bb=arguments.length>=3?_3bb:this.attributeMap[attr];_390.forEach(lang.isArray(_3bb)?_3bb:[_3bb],function(_3bc){var _3bd=this[_3bc.node||_3bc||"domNode"];var type=_3bc.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_3ba)){_3ba=lang.hitch(this,_3ba);}var _3be=_3bc.attribute?_3bc.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_3bd.tagName){_395.set(_3bd,_3be,_3ba);}else{_3bd.set(_3be,_3ba);}break;case "innerText":_3bd.innerHTML="";_3bd.appendChild(this.ownerDocument.createTextNode(_3ba));break;case "textContent":_3bd.textContent=_3ba;break;case "innerHTML":_3bd.innerHTML=_3ba;break;case "class":_396.replace(_3bd,_3ba,this[attr]);break;case "toggleClass":_396.toggle(_3bd,_3bc.className||attr,_3ba);break;}},this);},get:function(name){var _3bf=this._getAttrNames(name);return this[_3bf.g]?this[_3bf.g]():this._get(name);},set:function(name,_3c0){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _3c1=this._getAttrNames(name),_3c2=this[_3c1.s];if(lang.isFunction(_3c2)){var _3c3=_3c2.apply(this,Array.prototype.slice.call(arguments,1));}else{var _3c4=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_3c4]&&this[_3c4].tagName,_3c5=tag&&(_3a2[tag]||(_3a2[tag]=_3a3(this[_3c4]))),map=name in this.attributeMap?this.attributeMap[name]:_3c1.s in this?this[_3c1.s]:((_3c5&&_3c1.l in _3c5&&typeof _3c0!="function")||/^aria-|^data-|^role$/.test(name))?_3c4:null;if(map!=null){this._attrToDom(name,_3c0,map);}this._set(name,_3c0);}return _3c3||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_3c6){var _3c7=this[name];this[name]=_3c6;if(this._created&&!_3a5(_3c7,_3c6)){if(this._watchCallbacks){this._watchCallbacks(name,_3c7,_3c6);}this.emit("attrmodified-"+name,{detail:{prevValue:_3c7,newValue:_3c6}});}},_get:function(name){return this[name];},emit:function(type,_3c8,_3c9){_3c8=_3c8||{};if(_3c8.bubbles===undefined){_3c8.bubbles=true;}if(_3c8.cancelable===undefined){_3c8.cancelable=true;}if(!_3c8.detail){_3c8.detail={};}_3c8.detail.widget=this;var ret,_3ca=this["on"+type];if(_3ca){ret=_3ca.apply(this,_3c9?_3c9:[_3c8]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_3c8);}return ret;},on:function(type,func){var _3cb=this._onMap(type);if(_3cb){return _391.after(this,_3cb,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_3a0.findWidgets(this.containerNode):[];},getParent:function(){return _3a0.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_3cc,_3cd){return this.own(_393.connect(obj,_3cc,this,_3cd))[0];},disconnect:function(_3ce){_3ce.remove();},subscribe:function(t,_3cf){return this.own(_39d.subscribe(t,lang.hitch(this,_3cf)))[0];},unsubscribe:function(_3d0){_3d0.remove();},isLeftToRight:function(){return this.dir?(this.dir.toLowerCase()=="ltr"):_398.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_399.get(this.domNode,"display")!="none");},placeAt:function(_3d1,_3d2){var _3d3=!_3d1.tagName&&_3a0.byId(_3d1);if(_3d3&&_3d3.addChild&&(!_3d2||typeof _3d2==="number")){_3d3.addChild(this,_3d2);}else{var ref=_3d3&&("domNode" in _3d3)?(_3d3.containerNode&&!/after|before|replace/.test(_3d2||"")?_3d3.containerNode:_3d3.domNode):dom.byId(_3d1,this.ownerDocument);_397.place(this.domNode,ref,_3d2);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},defer:function(fcn,_3d4){var _3d5=setTimeout(lang.hitch(this,function(){if(!_3d5){return;}_3d5=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_3d4||0);return {remove:function(){if(_3d5){clearTimeout(_3d5);_3d5=null;}return null;}};}});if(has("dojo-bidi")){_3a6.extend(_39f);}return _3a6;});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_3d6,lang,_3d7,when){return _3d6("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_3d8){if(_3d8){this.set(_3d8);}},_get:function(name,_3d9){return typeof this[_3d9.g]==="function"?this[_3d9.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_3da){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _3db=this._getAttrNames(name),_3dc=this._get(name,_3db),_3dd=this[_3db.s],_3de;if(typeof _3dd==="function"){_3de=_3dd.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_3da;}if(this._watchCallbacks){var self=this;when(_3de,function(){self._watchCallbacks(name,_3dc,_3da);});}return this;},_changeAttrValue:function(name,_3df){var _3e0=this.get(name);this[name]=_3df;if(this._watchCallbacks){this._watchCallbacks(name,_3e0,_3df);}return this;},watch:function(name,_3e1){var _3e2=this._watchCallbacks;if(!_3e2){var self=this;_3e2=this._watchCallbacks=function(name,_3e3,_3e4,_3e5){var _3e6=function(_3e7){if(_3e7){_3e7=_3e7.slice();for(var i=0,l=_3e7.length;i<l;i++){_3e7[i].call(self,name,_3e3,_3e4);}}};_3e6(_3e2["_"+name]);if(!_3e5){_3e6(_3e2["*"]);}};}if(!_3e1&&typeof name==="function"){_3e1=name;name="*";}else{name="_"+name;}var _3e8=_3e2[name];if(typeof _3e8!=="object"){_3e8=_3e2[name]=[];}_3e8.push(_3e1);var _3e9={};_3e9.unwatch=_3e9.remove=function(){var _3ea=_3d7.indexOf(_3e8,_3e1);if(_3ea>-1){_3e8.splice(_3ea,1);}};return _3e9;}});});},"dijit/Destroyable":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_3eb,_3ec,_3ed){return _3ed("dijit.Destroyable",null,{destroy:function(_3ee){this._destroyed=true;},own:function(){var _3ef=["destroyRecursive","destroy","remove"];_3eb.forEach(arguments,function(_3f0){var _3f1;var odh=_3ec.before(this,"destroy",function(_3f2){_3f0[_3f1](_3f2);});var hdhs=[];function _3f3(){odh.remove();_3eb.forEach(hdhs,function(hdh){hdh.remove();});};if(_3f0.then){_3f1="cancel";_3f0.then(_3f3,_3f3);}else{_3eb.forEach(_3ef,function(_3f4){if(typeof _3f0[_3f4]==="function"){if(!_3f1){_3f1=_3f4;}hdhs.push(_3ec.after(_3f0,_3f4,_3f3,true));}});}},this);return arguments;}});});},"dijit/_OnDijitClickMixin":function(){define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","./a11yclick"],function(on,_3f5,keys,_3f6,has,_3f7){var ret=_3f6("dijit._OnDijitClickMixin",null,{connect:function(obj,_3f8,_3f9){return this.inherited(arguments,[obj,_3f8=="ondijitclick"?_3f7:_3f8,_3f9]);}});ret.a11yclick=_3f7;return ret;});},"dijit/a11yclick":function(){define(["dojo/keys","dojo/mouse","dojo/on","dojo/touch"],function(keys,_3fa,on,_3fb){function _3fc(e){if((e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!/input|button|textarea/i.test(e.target.nodeName)){for(var node=e.target;node;node=node.parentNode){if(node.dojoClick){return true;}}}};var _3fd;on(document,"keydown",function(e){if(_3fc(e)){_3fd=e.target;e.preventDefault();}else{_3fd=null;}});on(document,"keyup",function(e){if(_3fc(e)&&e.target==_3fd){_3fd=null;on.emit(e.target,"click",{cancelable:true,bubbles:true,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey,_origType:e.type});}});var _3fe=function(node,_3ff){node.dojoClick=true;return on(node,"click",_3ff);};_3fe.click=_3fe;_3fe.press=function(node,_400){var _401=on(node,_3fb.press,function(evt){if(evt.type=="mousedown"&&!_3fa.isLeft(evt)){return;}_400(evt);}),_402=on(node,"keydown",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_400(evt);}});return {remove:function(){_401.remove();_402.remove();}};};_3fe.release=function(node,_403){var _404=on(node,_3fb.release,function(evt){if(evt.type=="mouseup"&&!_3fa.isLeft(evt)){return;}_403(evt);}),_405=on(node,"keyup",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_403(evt);}});return {remove:function(){_404.remove();_405.remove();}};};_3fe.move=_3fb.move;return _3fe;});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./dom-class","./_base/lang","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_406,dom,_407,lang,on,has,_408,_409,win){var ios4=has("ios")<5;var _40a=has("pointer-events")||has("MSPointer"),_40b=(function(){var _40c={};for(var type in {down:1,move:1,up:1,cancel:1,over:1,out:1}){_40c[type]=has("MSPointer")?"MSPointer"+type.charAt(0).toUpperCase()+type.slice(1):"pointer"+type;}return _40c;})();var _40d=has("touch-events");var _40e,_40f,_410=false,_411,_412,_413,_414,_415,_416;var _417;function _418(_419,_41a,_41b){if(_40a&&_41b){return function(node,_41c){return on(node,_41b,_41c);};}else{if(_40d){return function(node,_41d){var _41e=on(node,_41a,function(evt){_41d.call(this,evt);_417=(new Date()).getTime();}),_41f=on(node,_419,function(evt){if(!_417||(new Date()).getTime()>_417+1000){_41d.call(this,evt);}});return {remove:function(){_41e.remove();_41f.remove();}};};}else{return function(node,_420){return on(node,_419,_420);};}}};function _421(node){do{if(node.dojoClick!==undefined){return node;}}while(node=node.parentNode);};function _422(e,_423,_424){if(_408.isRight(e)){return;}var _425=_421(e.target);_40f=!e.target.disabled&&_425&&_425.dojoClick;if(_40f){_410=(_40f=="useTarget");_411=(_410?_425:e.target);if(_410){e.preventDefault();}_412=e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX;_413=e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY;_414=(typeof _40f=="object"?_40f.x:(typeof _40f=="number"?_40f:0))||4;_415=(typeof _40f=="object"?_40f.y:(typeof _40f=="number"?_40f:0))||4;if(!_40e){_40e=true;var _426=function _426(e){if(_410){_40f=dom.isDescendant(win.doc.elementFromPoint((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX),(e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)),_411);}else{_40f=_40f&&(e.changedTouches?e.changedTouches[0].target:e.target)==_411&&Math.abs((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX)-_412)<=_414&&Math.abs((e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)-_413)<=_415;}};win.doc.addEventListener(_423,function(e){if(_408.isRight(e)){return;}_426(e);if(_410){e.preventDefault();}},true);win.doc.addEventListener(_424,function(e){if(_408.isRight(e)){return;}_426(e);if(_40f){_416=(new Date()).getTime();var _427=(_410?_411:e.target);if(_427.tagName==="LABEL"){_427=dom.byId(_427.getAttribute("for"))||_427;}var src=(e.changedTouches)?e.changedTouches[0]:e;var _428=function _428(type){var evt=document.createEvent("MouseEvents");evt._dojo_click=true;evt.initMouseEvent(type,true,true,e.view,e.detail,src.screenX,src.screenY,src.clientX,src.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,0,null);return evt;};var _429=_428("mousedown");var _42a=_428("mouseup");var _42b=_428("click");setTimeout(function(){on.emit(_427,"mousedown",_429);on.emit(_427,"mouseup",_42a);on.emit(_427,"click",_42b);_416=(new Date()).getTime();},0);}},true);var _42c=function _42c(type){win.doc.addEventListener(type,function(e){var _42d=e.target;if(_40f&&!e._dojo_click&&(new Date()).getTime()<=_416+1000&&!(_42d.tagName=="INPUT"&&_407.contains(_42d,"dijitOffScreen"))){e.stopPropagation();e.stopImmediatePropagation&&e.stopImmediatePropagation();if(type=="click"&&(_42d.tagName!="INPUT"||(_42d.type=="radio"&&(_407.contains(_42d,"dijitCheckBoxInput")||_407.contains(_42d,"mblRadioButton")))||(_42d.type=="checkbox"&&(_407.contains(_42d,"dijitCheckBoxInput")||_407.contains(_42d,"mblCheckBox"))))&&_42d.tagName!="TEXTAREA"&&_42d.tagName!="AUDIO"&&_42d.tagName!="VIDEO"){e.preventDefault();}}},true);};_42c("click");_42c("mousedown");_42c("mouseup");}}};var _42e;if(has("touch")){if(_40a){_409(function(){win.doc.addEventListener(_40b.down,function(evt){_422(evt,_40b.move,_40b.up);},true);});}else{_409(function(){_42e=win.body();win.doc.addEventListener("touchstart",function(evt){_417=(new Date()).getTime();var _42f=_42e;_42e=evt.target;on.emit(_42f,"dojotouchout",{relatedTarget:_42e,bubbles:true});on.emit(_42e,"dojotouchover",{relatedTarget:_42f,bubbles:true});_422(evt,"touchmove","touchend");},true);function _430(evt){var _431=lang.delegate(evt,{bubbles:true});if(has("ios")>=6){_431.touches=evt.touches;_431.altKey=evt.altKey;_431.changedTouches=evt.changedTouches;_431.ctrlKey=evt.ctrlKey;_431.metaKey=evt.metaKey;_431.shiftKey=evt.shiftKey;_431.targetTouches=evt.targetTouches;}return _431;};on(win.doc,"touchmove",function(evt){_417=(new Date()).getTime();var _432=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_432){if(_42e!==_432){on.emit(_42e,"dojotouchout",{relatedTarget:_432,bubbles:true});on.emit(_432,"dojotouchover",{relatedTarget:_42e,bubbles:true});_42e=_432;}if(!on.emit(_432,"dojotouchmove",_430(evt))){evt.preventDefault();}}});on(win.doc,"touchend",function(evt){_417=(new Date()).getTime();var node=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset))||win.body();on.emit(node,"dojotouchend",_430(evt));});});}}var _433={press:_418("mousedown","touchstart",_40b.down),move:_418("mousemove","dojotouchmove",_40b.move),release:_418("mouseup","dojotouchend",_40b.up),cancel:_418(_408.leave,"touchcancel",_40a?_40b.cancel:null),over:_418("mouseover","dojotouchover",_40b.over),out:_418("mouseout","dojotouchout",_40b.out),enter:_408._eventHandler(_418("mouseover","dojotouchover",_40b.over)),leave:_408._eventHandler(_418("mouseout","dojotouchout",_40b.out))};1&&(dojo.touch=_433);return _433;});},"dijit/_FocusMixin":function(){define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_434,_435,_436,lang){lang.extend(_435,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _436("dijit._FocusMixin",null,{_focusManager:_434});});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/domReady","dojo/sniff","dojo/Stateful","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_437,_438,dom,_439,_43a,_43b,_43c,lang,on,_43d,has,_43e,win,_43f,a11y,_440,_441){var _442;var _443;var _444=_438([_43e,_43c],{curNode:null,activeStack:[],constructor:function(){var _445=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_437.before(_43b,"empty",_445);_437.before(_43b,"destroy",_445);},registerIframe:function(_446){return this.registerWin(_446.contentWindow,_446);},registerWin:function(_447,_448){var _449=this,body=_447.document&&_447.document.body;if(body){var _44a=has("pointer-events")?"pointerdown":has("MSPointer")?"MSPointerDown":has("touch-events")?"mousedown, touchstart":"mousedown";var mdh=on(_447.document,_44a,function(evt){if(evt&&evt.target&&evt.target.parentNode==null){return;}_449._onTouchNode(_448||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isFocusable(evt.target)){_449._onFocusNode(_448||evt.target);}else{_449._onTouchNode(_448||evt.target);}});var foh=on(body,"focusout",function(evt){_449._onBlurNode(_448||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){var now=(new Date()).getTime();if(now<_442+100){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}if(now<_443+100){return;}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){_443=(new Date()).getTime();if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}if(_43a.contains(node,"dijitPopup")){node=node.firstChild;}var _44b=[];try{while(node){var _44c=_439.get(node,"dijitPopupParent");if(_44c){node=_440.byId(_44c).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_43f.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_44d=id&&_440.byId(id);if(_44d&&!(by=="mouse"&&_44d.get("disabled"))){_44b.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_44b,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}_442=(new Date()).getTime();if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_44e,by){var _44f=this.activeStack,_450=_44f.length-1,_451=_44e.length-1;if(_44e[_451]==_44f[_450]){return;}this.set("activeStack",_44e);var _452,i;for(i=_450;i>=0&&_44f[i]!=_44e[i];i--){_452=_440.byId(_44f[i]);if(_452){_452._hasBeenBlurred=true;_452.set("focused",false);if(_452._focusManager==this){_452._onBlur(by);}this.emit("widget-blur",_452,by);}}for(i++;i<=_451;i++){_452=_440.byId(_44e[i]);if(_452){_452.set("focused",true);if(_452._focusManager==this){_452._onFocus(by);}this.emit("widget-focus",_452,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _453=new _444();_43d(function(){var _454=_453.registerWin(_43f.get(document));if(has("ie")){on(window,"unload",function(){if(_454){_454.remove();_454=null;}});}});_441.focus=function(node){_453.focus(node);};for(var attr in _453){if(!/^_/.test(attr)){_441.focus[attr]=typeof _453[attr]=="function"?lang.hitch(_453,attr):_453[attr];}}_453.watch(function(attr,_455,_456){_441.focus[attr]=_456;});return _453;});},"dijit/a11y":function(){define(["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_457,dom,_458,_459,lang,has,_45a){var _45b;var a11y={_isElementShown:function(elem){var s=_459.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_458.get(elem,"type")!="hidden");},hasDefaultTabStop:function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _458.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _45c=elem.contentDocument;if("designMode" in _45c&&_45c.designMode=="on"){return true;}body=_45c.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}},effectiveTabIndex:function(elem){if(_458.get(elem,"disabled")){return _45b;}else{if(_458.has(elem,"tabIndex")){return +_458.get(elem,"tabIndex");}else{return a11y.hasDefaultTabStop(elem)?0:_45b;}}},isTabNavigable:function(elem){return a11y.effectiveTabIndex(elem)>=0;},isFocusable:function(elem){return a11y.effectiveTabIndex(elem)>=-1;},_getTabNavigable:function(root){var _45d,last,_45e,_45f,_460,_461,_462={};function _463(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _464=a11y._isElementShown,_465=a11y.effectiveTabIndex;var _466=function(_467){for(var _468=_467.firstChild;_468;_468=_468.nextSibling){if(_468.nodeType!=1||(has("ie")<=9&&_468.scopeName!=="HTML")||!_464(_468)){continue;}var _469=_465(_468);if(_469>=0){if(_469==0){if(!_45d){_45d=_468;}last=_468;}else{if(_469>0){if(!_45e||_469<_45f){_45f=_469;_45e=_468;}if(!_460||_469>=_461){_461=_469;_460=_468;}}}var rn=_463(_468);if(_458.get(_468,"checked")&&rn){_462[rn]=_468;}}if(_468.nodeName.toUpperCase()!="SELECT"){_466(_468);}}};if(_464(root)){_466(root);}function rs(node){return _462[_463(node)]||node;};return {first:rs(_45d),last:rs(last),lowest:rs(_45e),highest:rs(_460)};},getFirstInTabbingOrder:function(root,doc){var _46a=a11y._getTabNavigable(dom.byId(root,doc));return _46a.lowest?_46a.lowest:_46a.first;},getLastInTabbingOrder:function(root,doc){var _46b=a11y._getTabNavigable(dom.byId(root,doc));return _46b.last?_46b.last:_46b.highest;}};1&&lang.mixin(_45a,a11y);return a11y;});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./domReady","./sniff","./_base/window"],function(_46c,lang,_46d,has,_46e){var html=_46e.doc.documentElement,ie=has("ie"),_46f=has("trident"),_470=has("opera"),maj=Math.floor,ff=has("ff"),_471=_46c.boxModel.replace(/-/,""),_472={"dj_quirks":has("quirks"),"dj_opera":_470,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_edge":has("edge"),"dj_gecko":has("mozilla"),"dj_ios":has("ios"),"dj_android":has("android")};if(ie){_472["dj_ie"]=true;_472["dj_ie"+maj(ie)]=true;_472["dj_iequirks"]=has("quirks");}if(_46f){_472["dj_trident"]=true;_472["dj_trident"+maj(_46f)]=true;}if(ff){_472["dj_ff"+maj(ff)]=true;}_472["dj_"+_471]=true;var _473="";for(var clz in _472){if(_472[clz]){_473+=clz+" ";}}html.className=lang.trim(html.className+" "+_473);_46d(function(){if(!_46c.isBodyLtr()){var _474="dj_rtl dijitRtl "+_473.replace(/ /g,"-rtl ");html.className=lang.trim(html.className+" "+_474+"dj_rtl dijitRtl "+_473.replace(/ /g,"-rtl "));}});return has;});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/domReady","dojo/_base/window"],function(_475,has,_476,win){_476(function(){if(has("highcontrast")){_475.add(win.body(),"dijit_a11y");}});return has;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./domReady","./_base/window"],function(_477,_478,_479,_47a,has,_47b,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");try{div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url(\""+(_478.blankGif||_477.toUrl("./resources/blank.gif"))+"\");";win.body().appendChild(div);var cs=_47a.getComputedStyle(div),_47c=cs.backgroundImage;return cs.borderTopColor==cs.borderRightColor||(_47c&&(_47c=="none"||_47c=="url(invalid-url:)"));}catch(e){console.warn("hccss: exception detecting high-contrast mode, document is likely hidden: "+e.toString());return false;}finally{if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}}});_47b(function(){if(has("highcontrast")){_479.add(win.body(),"dj_a11y");}});return has;});},"dijit/_TemplatedMixin":function(){define(["dojo/cache","dojo/_base/declare","dojo/dom-construct","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_AttachMixin"],function(_47d,_47e,_47f,lang,on,has,_480,_481){var _482=_47e("dijit._TemplatedMixin",_481,{templateString:null,templatePath:null,_skipNodeCache:false,searchContainerNode:true,_stringRepl:function(tmpl){var _483=this.declaredClass,_484=this;return _480.substitute(tmpl,this,function(_485,key){if(key.charAt(0)=="!"){_485=lang.getObject(key.substr(1),false,_484);}if(typeof _485=="undefined"){throw new Error(_483+" template:"+key);}if(_485==null){return "";}return key.charAt(0)=="!"?_485:this._escapeValue(""+_485);},this);},_escapeValue:function(val){return val.replace(/["'<>&]/g,function(val){return {"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;"}[val];});},buildRendering:function(){if(!this._rendered){if(!this.templateString){this.templateString=_47d(this.templatePath,{sanitize:true});}var _486=_482.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_486)){node=_47f.toDom(this._stringRepl(_486),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_486);}}else{node=_486.cloneNode(true);}this.domNode=node;}this.inherited(arguments);if(!this._rendered){this._fillContent(this.srcNodeRef);}this._rendered=true;},_fillContent:function(_487){var dest=this.containerNode;if(_487&&dest){while(_487.hasChildNodes()){dest.appendChild(_487.firstChild);}}}});_482._templateCache={};_482.getCachedTemplate=function(_488,_489,doc){var _48a=_482._templateCache;var key=_488;var _48b=_48a[key];if(_48b){try{if(!_48b.ownerDocument||_48b.ownerDocument==(doc||document)){return _48b;}}catch(e){}_47f.destroy(_48b);}_488=_480.trim(_488);if(_489||_488.match(/\$\{([^\}]+)\}/g)){return (_48a[key]=_488);}else{var node=_47f.toDom(_488,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_488);}return (_48a[key]=node);}};if(has("ie")){on(window,"unload",function(){var _48c=_482._templateCache;for(var key in _48c){var _48d=_48c[key];if(typeof _48d=="object"){_47f.destroy(_48d);}delete _48c[key];}});}return _482;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dojo/text":function(){define(["./_base/kernel","require","./has","./request"],function(dojo,_48e,has,_48f){var _490;if(1){_490=function(url,sync,load){_48f(url,{sync:!!sync,headers:{"X-Requested-With":null}}).then(load);};}else{if(_48e.getText){_490=_48e.getText;}else{console.error("dojo/text plugin failed to load because loader does not support getText");}}var _491={},_492=function(text){if(text){text=text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");var _493=text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_493){text=_493[1];}}else{text="";}return text;},_494={},_495={};dojo.cache=function(_496,url,_497){var key;if(typeof _496=="string"){if(/\//.test(_496)){key=_496;_497=url;}else{key=_48e.toUrl(_496.replace(/\./g,"/")+(url?("/"+url):""));}}else{key=_496+"";_497=url;}var val=(_497!=undefined&&typeof _497!="string")?_497.value:_497,_498=_497&&_497.sanitize;if(typeof val=="string"){_491[key]=val;return _498?_492(val):val;}else{if(val===null){delete _491[key];return null;}else{if(!(key in _491)){_490(key,true,function(text){_491[key]=text;});}return _498?_492(_491[key]):_491[key];}}};return {dynamic:true,normalize:function(id,_499){var _49a=id.split("!"),url=_49a[0];return (/^\./.test(url)?_499(url):url)+(_49a[1]?"!"+_49a[1]:"");},load:function(id,_49b,load){var _49c=id.split("!"),_49d=_49c.length>1,_49e=_49c[0],url=_49b.toUrl(_49c[0]),_49f="url:"+url,text=_494,_4a0=function(text){load(_49d?_492(text):text);};if(_49e in _491){text=_491[_49e];}else{if(_49b.cache&&_49f in _49b.cache){text=_49b.cache[_49f];}else{if(url in _491){text=_491[url];}}}if(text===_494){if(_495[url]){_495[url].push(_4a0);}else{var _4a1=_495[url]=[_4a0];_490(url,!_49b.async,function(text){_491[_49e]=_491[url]=text;for(var i=0;i<_4a1.length;){_4a1[i++](text);}delete _495[url];});}}else{_4a0(text);}}};});},"dojo/request":function(){define(["./request/default!"],function(_4a2){return _4a2;});},"dojo/request/default":function(){define(["exports","require","../has"],function(_4a3,_4a4,has){var _4a5=has("config-requestProvider"),_4a6;if(1||has("host-webworker")){_4a6="./xhr";}else{if(0){_4a6="./node";}}if(!_4a5){_4a5=_4a6;}_4a3.getPlatformDefaultId=function(){return _4a6;};_4a3.load=function(id,_4a7,_4a8,_4a9){_4a4([id=="platform"?_4a6:_4a5],function(_4aa){_4a8(_4aa);});};});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_4ab,lang){var _4ac=/[&<>'"\/]/g;var _4ad={"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;","/":"&#x2F;"};var _4ae={};lang.setObject("dojo.string",_4ae);_4ae.escape=function(str){if(!str){return "";}return str.replace(_4ac,function(c){return _4ad[c];});};_4ae.codePointAt=String.prototype.codePointAt?function(str,_4af){return String.prototype.codePointAt.call(str,_4af);}:function(str,_4b0){if(str==null){throw new TypeError("codePointAt called on null or undefined");}var size;var _4b1;var _4b2;var _4b3;str=String(str);size=str.length;_4b3=_4b0?Number(_4b0):0;if(_4b3!=_4b3){_4b3=0;}if(_4b3<0||_4b3>=size){return undefined;}_4b1=str.charCodeAt(_4b3);if(_4b1>=55296&&_4b1<=56319&&size>_4b3+1){_4b2=str.charCodeAt(_4b3+1);if(_4b2>=56320&&_4b2<=57343){return (_4b1-55296)*1024+_4b2-56320+65536;}}return _4b1;};_4ae.fromCodePoint=String.fromCodePoint||function(){var _4b4=[];var _4b5=0;var _4b6="";var _4b7;var _4b8;for(_4b8=0,len=arguments.length;_4b8!==len;++_4b8){_4b7=+arguments[_4b8];if(!(_4b7<1114111&&(_4b7>>>0)===_4b7)){throw RangeError("Invalid code point: "+_4b7);}if(_4b7<=65535){_4b5=_4b4.push(_4b7);}else{_4b7-=65536;_4b5=_4b4.push((_4b7>>10)+55296,(_4b7%1024)+56320);}if(_4b5>=16383){_4b6+=String.fromCharCode.apply(null,_4b4);_4b4.length=0;}}return _4b6+String.fromCharCode.apply(null,_4b4);};_4ae.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_4ae.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_4ae.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_4ae.substitute=function(_4b9,map,_4ba,_4bb){_4bb=_4bb||_4ab.global;_4ba=_4ba?lang.hitch(_4bb,_4ba):function(v){return v;};return _4b9.replace(/\$\{([^\s\:\}]*)(?:\:([^\s\:\}]+))?\}/g,function(_4bc,key,_4bd){if(key==""){return "$";}var _4be=lang.getObject(key,false,map);if(_4bd){_4be=lang.getObject(_4bd,false,_4bb).call(_4bb,_4be,key);}var _4bf=_4ba(_4be,key);if(typeof _4bf==="undefined"){throw new Error("string.substitute could not find key \""+key+"\" in template");}return _4bf.toString();});};_4ae.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _4ae;});},"dijit/_AttachMixin":function(){define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","./_WidgetBase"],function(_4c0,_4c1,_4c2,_4c3,lang,_4c4,on,_4c5,_4c6){var _4c7=lang.delegate(_4c5,{"mouseenter":_4c4.enter,"mouseleave":_4c4.leave,"keypress":_4c2._keypress});var _4c8;var _4c9=_4c3("dijit._AttachMixin",null,{constructor:function(){this._attachPoints=[];this._attachEvents=[];},buildRendering:function(){this.inherited(arguments);this._attachTemplateNodes(this.domNode);this._beforeFillContent();},_beforeFillContent:function(){},_attachTemplateNodes:function(_4ca){var node=_4ca;while(true){if(node.nodeType==1&&(this._processTemplateNode(node,function(n,p){return n.getAttribute(p);},this._attach)||this.searchContainerNode)&&node.firstChild){node=node.firstChild;}else{if(node==_4ca){return;}while(!node.nextSibling){node=node.parentNode;if(node==_4ca){return;}}node=node.nextSibling;}}},_processTemplateNode:function(_4cb,_4cc,_4cd){var ret=true;var _4ce=this.attachScope||this,_4cf=_4cc(_4cb,"dojoAttachPoint")||_4cc(_4cb,"data-dojo-attach-point");if(_4cf){var _4d0,_4d1=_4cf.split(/\s*,\s*/);while((_4d0=_4d1.shift())){if(lang.isArray(_4ce[_4d0])){_4ce[_4d0].push(_4cb);}else{_4ce[_4d0]=_4cb;}ret=(_4d0!="containerNode");this._attachPoints.push(_4d0);}}var _4d2=_4cc(_4cb,"dojoAttachEvent")||_4cc(_4cb,"data-dojo-attach-event");if(_4d2){var _4d3,_4d4=_4d2.split(/\s*,\s*/);var trim=lang.trim;while((_4d3=_4d4.shift())){if(_4d3){var _4d5=null;if(_4d3.indexOf(":")!=-1){var _4d6=_4d3.split(":");_4d3=trim(_4d6[0]);_4d5=trim(_4d6[1]);}else{_4d3=trim(_4d3);}if(!_4d5){_4d5=_4d3;}this._attachEvents.push(_4cd(_4cb,_4d3,lang.hitch(_4ce,_4d5)));}}}return ret;},_attach:function(node,type,func){type=type.replace(/^on/,"").toLowerCase();if(type=="dijitclick"){type=_4c8||(_4c8=_4c0("./a11yclick"));}else{type=_4c7[type]||type;}return on(node,type,func);},_detachTemplateNodes:function(){var _4d7=this.attachScope||this;_4c1.forEach(this._attachPoints,function(_4d8){delete _4d7[_4d8];});this._attachPoints=[];_4c1.forEach(this._attachEvents,function(_4d9){_4d9.remove();});this._attachEvents=[];},destroyRendering:function(){this._detachTemplateNodes();this.inherited(arguments);}});lang.extend(_4c6,{dojoAttachEvent:"",dojoAttachPoint:""});return _4c9;});},"dijit/BackgroundIframe":function(){define(["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff"],function(_4da,_4db,_4dc,_4dd,_4de,lang,on,has){has.add("config-bgIframe",(has("ie")||has("trident"))&&!/IEMobile\/10\.0/.test(navigator.userAgent));var _4df=new function(){var _4e0=[];this.pop=function(){var _4e1;if(_4e0.length){_4e1=_4e0.pop();_4e1.style.display="";}else{if(has("ie")<9){var burl=_4dc["dojoBlankHtmlUrl"]||_4da.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_4e1=document.createElement(html);}else{_4e1=_4dd.create("iframe");_4e1.src="javascript:\"\"";_4e1.className="dijitBackgroundIframe";_4e1.setAttribute("role","presentation");_4de.set(_4e1,"opacity",0.1);}_4e1.tabIndex=-1;}return _4e1;};this.push=function(_4e2){_4e2.style.display="none";_4e0.push(_4e2);};}();_4db.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("config-bgIframe")){var _4e3=(this.iframe=_4df.pop());node.appendChild(_4e3);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,"resize",node));}else{_4de.set(_4e3,{width:"100%",height:"100%"});}}};lang.extend(_4db.BackgroundIframe,{resize:function(node){if(this.iframe){_4de.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){this.iframe.parentNode.removeChild(this.iframe);_4df.push(this.iframe);delete this.iframe;}}});return _4db.BackgroundIframe;});},"dijit/form/CheckBox":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom","../a11yclick"],function(_4e4,_4e5,_4e6,has,_4e7,_4e8,_4e9,_4ea,_4eb){if(has("dijit-legacy-requires")){_4e8(0,function(){var _4ec=["dijit/form/RadioButton"];_4e4(_4ec);});}return _4e5("dijit.form.CheckBox",[_4e9,_4ea],{templateString:_4eb,baseClass:"dijitCheckBox",_setValueAttr:function(_4ed,_4ee){if(typeof _4ed=="string"){this.inherited(arguments);_4ed=true;}if(this._created){this.set("checked",_4ed,_4ee);}},_getValueAttr:function(){return this.checked&&this._get("value");},_setIconClassAttr:null,_setNameAttr:"focusNode",postMixInProperties:function(){this.inherited(arguments);this.checkedAttrSetting="";},_fillContent:function(){},_onFocus:function(){if(this.id){_4e7("label[for='"+this.id+"']").addClass("dijitFocusedLabel");}this.inherited(arguments);},_onBlur:function(){if(this.id){_4e7("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");}this.inherited(arguments);}});});},"dijit/form/ToggleButton":function(){define(["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_4ef,_4f0,_4f1,_4f2){return _4ef("dijit.form.ToggleButton",[_4f1,_4f2],{baseClass:"dijitToggleButton",setChecked:function(_4f3){_4f0.deprecated("setChecked("+_4f3+") is deprecated. Use set('checked',"+_4f3+") instead.","","2.0");this.set("checked",_4f3);}});});},"dijit/form/Button":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html","../a11yclick"],function(_4f4,_4f5,_4f6,has,_4f7,lang,_4f8,_4f9,_4fa,_4fb){if(has("dijit-legacy-requires")){_4f8(0,function(){var _4fc=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];_4f4(_4fc);});}var _4fd=_4f5("dijit.form.Button"+(has("dojo-bidi")?"_NoBidi":""),[_4f9,_4fa],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_4fb,_setValueAttr:"valueNode",_setNameAttr:function(name){if(this.valueNode){this.valueNode.setAttribute("name",name);}},postCreate:function(){this.inherited(arguments);this._setLabelFromContainer();},_setLabelFromContainer:function(){if(this.containerNode&&!this.label){this.label=lang.trim(this.containerNode.innerHTML);this.onLabelSet();}},_setShowLabelAttr:function(val){if(this.containerNode){_4f6.toggle(this.containerNode,"dijitDisplayNone",!val);}this._set("showLabel",val);},setLabel:function(_4fe){_4f7.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_4fe);},onLabelSet:function(){this.inherited(arguments);if(!this.showLabel&&!("title" in this.params)){this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_4fd=_4f5("dijit.form.Button",_4fd,{onLabelSet:function(){this.inherited(arguments);if(this.titleNode.title){this.applyTextDir(this.titleNode,this.titleNode.title);}},_setTextDirAttr:function(_4ff){if(this._created&&this.textDir!=_4ff){this._set("textDir",_4ff);this._setLabelAttr(this.label);}}});}return _4fd;});},"dijit/form/_FormWidget":function(){define(["dojo/_base/declare","dojo/sniff","dojo/_base/kernel","dojo/ready","../_Widget","../_CssStateMixin","../_TemplatedMixin","./_FormWidgetMixin"],function(_500,has,_501,_502,_503,_504,_505,_506){if(has("dijit-legacy-requires")){_502(0,function(){var _507=["dijit/form/_FormValueWidget"];require(_507);});}return _500("dijit.form._FormWidget",[_503,_505,_504,_506],{setDisabled:function(_508){_501.deprecated("setDisabled("+_508+") is deprecated. Use set('disabled',"+_508+") instead.","","2.0");this.set("disabled",_508);},setValue:function(_509){_501.deprecated("dijit.form._FormWidget:setValue("+_509+") is deprecated.  Use set('value',"+_509+") instead.","","2.0");this.set("value",_509);},getValue:function(){_501.deprecated(this.declaredClass+"::getValue() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},postMixInProperties:function(){this.nameAttrSetting=(this.name&&!has("msapp"))?("name=\""+this.name.replace(/"/g,"&quot;")+"\""):"";this.inherited(arguments);}});});},"dijit/_CssStateMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/on","dojo/domReady","dojo/touch","dojo/_base/window","./a11yclick","./registry"],function(_50a,_50b,dom,_50c,has,lang,on,_50d,_50e,win,_50f,_510){var _511=_50b("dijit._CssStateMixin",[],{hovering:false,active:false,_applyAttributes:function(){this.inherited(arguments);_50a.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active","_opened"],function(attr){this.watch(attr,lang.hitch(this,"_setStateClass"));},this);for(var ap in this.cssStateNodes||{}){this._trackMouseState(this[ap],this.cssStateNodes[ap]);}this._trackMouseState(this.domNode,this.baseClass);this._setStateClass();},_cssMouseEvent:function(_512){if(!this.disabled){switch(_512.type){case "mouseover":case "MSPointerOver":case "pointerover":this._set("hovering",true);this._set("active",this._mouseDown);break;case "mouseout":case "MSPointerOut":case "pointerout":this._set("hovering",false);this._set("active",false);break;case "mousedown":case "touchstart":case "MSPointerDown":case "pointerdown":case "keydown":this._set("active",true);break;case "mouseup":case "dojotouchend":case "MSPointerUp":case "pointerup":case "keyup":this._set("active",false);break;}}},_setStateClass:function(){var _513=this.baseClass.split(" ");function _514(_515){_513=_513.concat(_50a.map(_513,function(c){return c+_515;}),"dijit"+_515);};if(!this.isLeftToRight()){_514("Rtl");}var _516=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");if(this.checked){_514(_516);}if(this.state){_514(this.state);}if(this.selected){_514("Selected");}if(this._opened){_514("Opened");}if(this.disabled){_514("Disabled");}else{if(this.readOnly){_514("ReadOnly");}else{if(this.active){_514("Active");}else{if(this.hovering){_514("Hover");}}}}if(this.focused){_514("Focused");}var tn=this.stateNode||this.domNode,_517={};_50a.forEach(tn.className.split(" "),function(c){_517[c]=true;});if("_stateClasses" in this){_50a.forEach(this._stateClasses,function(c){delete _517[c];});}_50a.forEach(_513,function(c){_517[c]=true;});var _518=[];for(var c in _517){_518.push(c);}tn.className=_518.join(" ");this._stateClasses=_513;},_subnodeCssMouseEvent:function(node,_519,evt){if(this.disabled||this.readOnly){return;}function _51a(_51b){_50c.toggle(node,_519+"Hover",_51b);};function _51c(_51d){_50c.toggle(node,_519+"Active",_51d);};function _51e(_51f){_50c.toggle(node,_519+"Focused",_51f);};switch(evt.type){case "mouseover":case "MSPointerOver":case "pointerover":_51a(true);break;case "mouseout":case "MSPointerOut":case "pointerout":_51a(false);_51c(false);break;case "mousedown":case "touchstart":case "MSPointerDown":case "pointerdown":case "keydown":_51c(true);break;case "mouseup":case "MSPointerUp":case "pointerup":case "dojotouchend":case "keyup":_51c(false);break;case "focus":case "focusin":_51e(true);break;case "blur":case "focusout":_51e(false);break;}},_trackMouseState:function(node,_520){node._cssState=_520;}});_50d(function(){function _521(evt,_522,_523){if(_523&&dom.isDescendant(_523,_522)){return;}for(var node=_522;node&&node!=_523;node=node.parentNode){if(node._cssState){var _524=_510.getEnclosingWidget(node);if(_524){if(node==_524.domNode){_524._cssMouseEvent(evt);}else{_524._subnodeCssMouseEvent(node,node._cssState,evt);}}}}};var body=win.body(),_525;on(body,_50e.over,function(evt){_521(evt,evt.target,evt.relatedTarget);});on(body,_50e.out,function(evt){_521(evt,evt.target,evt.relatedTarget);});on(body,_50f.press,function(evt){_525=evt.target;_521(evt,_525);});on(body,_50f.release,function(evt){_521(evt,_525);_525=null;});on(body,"focusin, focusout",function(evt){var node=evt.target;if(node._cssState&&!node.getAttribute("widgetId")){var _526=_510.getEnclosingWidget(node);if(_526){_526._subnodeCssMouseEvent(node,node._cssState,evt);}}});});return _511;});},"dijit/form/_FormWidgetMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","dojo/window","../a11y"],function(_527,_528,_529,_52a,lang,_52b,on,has,_52c,a11y){return _528("dijit.form._FormWidgetMixin",null,{name:"",alt:"",value:"",type:"text","aria-label":"focusNode",tabIndex:"0",_setTabIndexAttr:"focusNode",disabled:false,intermediateChanges:false,scrollOnFocus:true,_setIdAttr:"focusNode",_setDisabledAttr:function(_52d){this._set("disabled",_52d);if(/^(button|input|select|textarea|optgroup|option|fieldset)$/i.test(this.focusNode.tagName)){_529.set(this.focusNode,"disabled",_52d);if(has("trident")&&"readOnly" in this){_529.set(this.focusNode,"readonly",_52d||this.readOnly);}}else{this.focusNode.setAttribute("aria-disabled",_52d?"true":"false");}if(this.valueNode){_529.set(this.valueNode,"disabled",_52d);}if(_52d){this._set("hovering",false);this._set("active",false);var _52e="tabIndex" in this.attributeMap?this.attributeMap.tabIndex:("_setTabIndexAttr" in this)?this._setTabIndexAttr:"focusNode";_527.forEach(lang.isArray(_52e)?_52e:[_52e],function(_52f){var node=this[_52f];if(has("webkit")||a11y.hasDefaultTabStop(node)){node.setAttribute("tabIndex","-1");}else{node.removeAttribute("tabIndex");}},this);}else{if(this.tabIndex!=""){this.set("tabIndex",this.tabIndex);}}},_onFocus:function(by){if(by=="mouse"&&this.isFocusable()){var _530=this.own(on(this.focusNode,"focus",function(){_531.remove();_530.remove();}))[0];var _532=has("pointer-events")?"pointerup":has("MSPointer")?"MSPointerUp":has("touch-events")?"touchend, mouseup":"mouseup";var _531=this.own(on(this.ownerDocumentBody,_532,lang.hitch(this,function(evt){_531.remove();_530.remove();if(this.focused){if(evt.type=="touchend"){this.defer("focus");}else{this.focus();}}})))[0];}if(this.scrollOnFocus){this.defer(function(){_52c.scrollIntoView(this.domNode);});}this.inherited(arguments);},isFocusable:function(){return !this.disabled&&this.focusNode&&(_52a.get(this.domNode,"display")!="none");},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},compare:function(val1,val2){if(typeof val1=="number"&&typeof val2=="number"){return (isNaN(val1)&&isNaN(val2))?0:val1-val2;}else{if(val1>val2){return 1;}else{if(val1<val2){return -1;}else{return 0;}}}},onChange:function(){},_onChangeActive:false,_handleOnChange:function(_533,_534){if(this._lastValueReported==undefined&&(_534===null||!this._onChangeActive)){this._resetValue=this._lastValueReported=_533;}this._pendingOnChange=this._pendingOnChange||(typeof _533!=typeof this._lastValueReported)||(this.compare(_533,this._lastValueReported)!=0);if((this.intermediateChanges||_534||_534===undefined)&&this._pendingOnChange){this._lastValueReported=_533;this._pendingOnChange=false;if(this._onChangeActive){if(this._onChangeHandle){this._onChangeHandle.remove();}this._onChangeHandle=this.defer(function(){this._onChangeHandle=null;this.onChange(_533);});}}},create:function(){this.inherited(arguments);this._onChangeActive=true;},destroy:function(){if(this._onChangeHandle){this._onChangeHandle.remove();this.onChange(this._lastValueReported);}this.inherited(arguments);}});});},"dijit/form/_ButtonMixin":function(){define(["dojo/_base/declare","dojo/dom","dojo/has","../registry"],function(_535,dom,has,_536){var _537=_535("dijit.form._ButtonMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{label:"",type:"button",__onClick:function(e){e.stopPropagation();e.preventDefault();if(!this.disabled){this.valueNode.click(e);}return false;},_onClick:function(e){if(this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.onClick(e)===false){e.preventDefault();}var _538=e.defaultPrevented;if(!_538&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){for(var node=this.domNode;node.parentNode;node=node.parentNode){var _539=_536.byNode(node);if(_539&&typeof _539._onSubmit=="function"){_539._onSubmit(e);e.preventDefault();_538=true;break;}}}return !_538;},postCreate:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},onClick:function(){return true;},_setLabelAttr:function(_53a){this._set("label",_53a);var _53b=this.containerNode||this.focusNode;_53b.innerHTML=_53a;this.onLabelSet();},onLabelSet:function(){}});if(has("dojo-bidi")){_537=_535("dijit.form._ButtonMixin",_537,{onLabelSet:function(){this.inherited(arguments);var _53c=this.containerNode||this.focusNode;this.applyTextDir(_53c);}});}return _537;});},"dijit/form/_ToggleButtonMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_53d,_53e){return _53d("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){var _53f=this.checked;this._set("checked",!_53f);var ret=this.inherited(arguments);this.set("checked",ret?this.checked:_53f);return ret;},_setCheckedAttr:function(_540,_541){this._set("checked",_540);var node=this.focusNode||this.domNode;if(this._created){if(_53e.get(node,"checked")!=!!_540){_53e.set(node,"checked",!!_540);}}node.setAttribute(this._aria_attr,String(_540));this._handleOnChange(_540,_541);},postCreate:function(){this.inherited(arguments);var node=this.focusNode||this.domNode;if(this.checked){node.setAttribute("checked","checked");}if(this._resetValue===undefined){this._lastValueReported=this._resetValue=this.checked;}},reset:function(){this._hasBeenBlurred=false;this.set("checked",this.params.checked||false);}});});},"dijit/form/_CheckBoxMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_542,_543){return _542("dijit.form._CheckBoxMixin",null,{type:"checkbox",value:"on",readOnly:false,_aria_attr:"aria-checked",_setReadOnlyAttr:function(_544){this._set("readOnly",_544);_543.set(this.focusNode,"readOnly",_544);},_setLabelAttr:undefined,_getSubmitValue:function(_545){return (_545==null||_545==="")?"on":_545;},_setValueAttr:function(_546){_546=this._getSubmitValue(_546);this._set("value",_546);_543.set(this.focusNode,"value",_546);},reset:function(){this.inherited(arguments);this._set("value",this._getSubmitValue(this.params.value));_543.set(this.focusNode,"value",this.value);},_onClick:function(e){if(this.readOnly){e.stopPropagation();e.preventDefault();return false;}return this.inherited(arguments);}});});},"dijit/form/RadioButton":function(){define(["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_547,_548,_549){return _547("dijit.form.RadioButton",[_548,_549],{baseClass:"dijitRadio"});});},"dijit/form/_RadioButtonMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/lang","dojo/query!css2","../registry"],function(_54a,_54b,_54c,lang,_54d,_54e){return _54b("dijit.form._RadioButtonMixin",null,{type:"radio",_getRelatedWidgets:function(){var ary=[];_54d("input[type=radio]",this.focusNode.form||this.ownerDocument).forEach(lang.hitch(this,function(_54f){if(_54f.name==this.name&&_54f.form==this.focusNode.form){var _550=_54e.getEnclosingWidget(_54f);if(_550){ary.push(_550);}}}));return ary;},_setCheckedAttr:function(_551){this.inherited(arguments);if(!this._created){return;}if(_551){_54a.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_552){if(_552!=this&&_552.checked){_552.set("checked",false);}}));}},_getSubmitValue:function(_553){return _553==null?"on":_553;},_onClick:function(e){if(this.checked||this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.readOnly){e.stopPropagation();e.preventDefault();_54a.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_554){_54c.set(this.focusNode||this.domNode,"checked",_554.checked);}));return false;}var _555=false;var _556;_54a.some(this._getRelatedWidgets(),function(_557){if(_557.checked){_556=_557;return true;}return false;});this.checked=true;_556&&(_556.checked=false);if(this.onClick(e)===false||e.defaultPrevented){_555=true;}this.checked=false;_556&&(_556.checked=true);if(_555){e.preventDefault();}else{this.set("checked",true);}return !_555;}});});},"dijit/form/Form":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/sniff","../_Widget","../_TemplatedMixin","./_FormMixin","../layout/_ContentPaneResizeMixin"],function(_558,_559,_55a,has,_55b,_55c,_55d,_55e){return _558("dijit.form.Form",[_55b,_55c,_55d,_55e],{name:"",action:"",method:"",encType:"","accept-charset":"",accept:"",target:"",templateString:"<form data-dojo-attach-point='containerNode' data-dojo-attach-event='onreset:_onReset,onsubmit:_onSubmit' ${!nameAttrSetting}></form>",postMixInProperties:function(){this.nameAttrSetting=this.name?("name='"+this.name+"'"):"";this.inherited(arguments);},execute:function(){},onExecute:function(){},_setEncTypeAttr:function(_55f){_559.set(this.domNode,"encType",_55f);if(has("ie")){this.domNode.encoding=_55f;}this._set("encType",_55f);},reset:function(e){var faux={returnValue:true,preventDefault:function(){this.returnValue=false;},stopPropagation:function(){},currentTarget:e?e.target:this.domNode,target:e?e.target:this.domNode};if(!(this.onReset(faux)===false)&&faux.returnValue){this.inherited(arguments,[]);}},onReset:function(){return true;},_onReset:function(e){this.reset(e);e.stopPropagation();e.preventDefault();return false;},_onSubmit:function(e){var fp=this.constructor.prototype;if(this.execute!=fp.execute||this.onExecute!=fp.onExecute){_55a.deprecated("dijit.form.Form:execute()/onExecute() are deprecated. Use onSubmit() instead.","","2.0");this.onExecute();this.execute(this.getValues());}if(this.onSubmit(e)===false){e.stopPropagation();e.preventDefault();}},onSubmit:function(){return this.isValid();},submit:function(){if(!(this.onSubmit()===false)){this.containerNode.submit();}}});});},"dijit/form/_FormMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/window"],function(_560,_561,_562,lang,on,_563){return _561("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_564){var res=[];_560.forEach(_564||this.getChildren(),function(_565){if("value" in _565){res.push(_565);}else{res=res.concat(this._getDescendantFormWidgets(_565.getChildren()));}},this);return res;},reset:function(){_560.forEach(this._getDescendantFormWidgets(),function(_566){if(_566.reset){_566.reset();}});},validate:function(){var _567=false;return _560.every(_560.map(this._getDescendantFormWidgets(),function(_568){_568._hasBeenBlurred=true;var _569=_568.disabled||!_568.validate||_568.validate();if(!_569&&!_567){_563.scrollIntoView(_568.containerNode||_568.domNode);_568.focus();_567=true;}return _569;}),function(item){return item;});},setValues:function(val){_562.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(obj){var map={};_560.forEach(this._getDescendantFormWidgets(),function(_56a){if(!_56a.name){return;}var _56b=map[_56a.name]||(map[_56a.name]=[]);_56b.push(_56a);});for(var name in map){if(!map.hasOwnProperty(name)){continue;}var _56c=map[name],_56d=lang.getObject(name,false,obj);if(_56d===undefined){continue;}_56d=[].concat(_56d);if(typeof _56c[0].checked=="boolean"){_560.forEach(_56c,function(w){w.set("value",_560.indexOf(_56d,w._get("value"))!=-1);});}else{if(_56c[0].multiple){_56c[0].set("value",_56d);}else{_560.forEach(_56c,function(w,i){w.set("value",_56d[i]);});}}}},getValues:function(){_562.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},_getValueAttr:function(){var obj={};_560.forEach(this._getDescendantFormWidgets(),function(_56e){var name=_56e.name;if(!name||_56e.disabled){return;}var _56f=_56e.get("value");if(typeof _56e.checked=="boolean"){if(/Radio/.test(_56e.declaredClass)){if(_56f!==false){lang.setObject(name,_56f,obj);}else{_56f=lang.getObject(name,false,obj);if(_56f===undefined){lang.setObject(name,null,obj);}}}else{var ary=lang.getObject(name,false,obj);if(!ary){ary=[];lang.setObject(name,ary,obj);}if(_56f!==false){ary.push(_56f);}}}else{var prev=lang.getObject(name,false,obj);if(typeof prev!="undefined"){if(lang.isArray(prev)){prev.push(_56f);}else{lang.setObject(name,[prev,_56f],obj);}}else{lang.setObject(name,_56f,obj);}}});return obj;},isValid:function(){return this.state=="";},onValidStateChange:function(){},_getState:function(){var _570=_560.map(this._descendants,function(w){return w.get("state")||"";});return _560.indexOf(_570,"Error")>=0?"Error":_560.indexOf(_570,"Incomplete")>=0?"Incomplete":"";},disconnectChildren:function(){},connectChildren:function(_571){this._descendants=this._getDescendantFormWidgets();_560.forEach(this._descendants,function(_572){if(!_572._started){_572.startup();}});if(!_571){this._onChildChange();}},_onChildChange:function(attr){if(!attr||attr=="state"||attr=="disabled"){this._set("state",this._getState());}if(!attr||attr=="value"||attr=="disabled"||attr=="checked"){if(this._onChangeDelayTimer){this._onChangeDelayTimer.remove();}this._onChangeDelayTimer=this.defer(function(){delete this._onChangeDelayTimer;this._set("value",this.get("value"));},10);}},startup:function(){this.inherited(arguments);this._descendants=this._getDescendantFormWidgets();this.value=this.get("value");this.state=this._getState();var self=this;this.own(on(this.containerNode,"attrmodified-state, attrmodified-disabled, attrmodified-value, attrmodified-checked",function(evt){if(evt.target==self.domNode){return;}self._onChildChange(evt.type.replace("attrmodified-",""));}));this.watch("state",function(attr,_573,_574){this.onValidStateChange(_574=="");});},destroy:function(){this.inherited(arguments);}});});},"dijit/layout/_ContentPaneResizeMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/query","../registry","../Viewport","./utils"],function(_575,_576,_577,_578,_579,lang,_57a,_57b,_57c,_57d){return _576("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){if(this._started){return;}var _57e=this.getParent();this._childOfLayoutWidget=_57e&&_57e.isLayoutContainer;this._needLayout=!this._childOfLayoutWidget;this.inherited(arguments);if(this._isShown()){this._onShow();}if(!this._childOfLayoutWidget){this.own(_57c.on("resize",lang.hitch(this,"resize")));}},_checkIfSingleChild:function(){if(!this.doLayout){return;}var _57f=[],_580=false;_57a("> *",this.containerNode).some(function(node){var _581=_57b.byNode(node);if(_581&&_581.resize){_57f.push(_581);}else{if(!/script|link|style/i.test(node.nodeName)&&node.offsetHeight){_580=true;}}});this._singleChild=_57f.length==1&&!_580?_57f[0]:null;_577.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);},resize:function(_582,_583){this._resizeCalled=true;this._scheduleLayout(_582,_583);},_scheduleLayout:function(_584,_585){if(this._isShown()){this._layout(_584,_585);}else{this._needLayout=true;this._changeSize=_584;this._resultSize=_585;}},_layout:function(_586,_587){delete this._needLayout;if(!this._wasShown&&this.open!==false){this._onShow();}if(_586){_578.setMarginBox(this.domNode,_586);}var cn=this.containerNode;if(cn===this.domNode){var mb=_587||{};lang.mixin(mb,_586||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_578.getMarginBox(cn),mb);}this._contentBox=_57d.marginBox2contentBox(cn,mb);}else{this._contentBox=_578.getContentBox(cn);}this._layoutChildren();},_layoutChildren:function(){this._checkIfSingleChild();if(this._singleChild&&this._singleChild.resize){var cb=this._contentBox||_578.getContentBox(this.containerNode);this._singleChild.resize({w:cb.w,h:cb.h});}else{var _588=this.getChildren(),_589,i=0;while(_589=_588[i++]){if(_589.resize){_589.resize();}}}},_isShown:function(){if(this._childOfLayoutWidget){if(this._resizeCalled&&"open" in this){return this.open;}return this._resizeCalled;}else{if("open" in this){return this.open;}else{var node=this.domNode,_58a=this.domNode.parentNode;return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_577.contains(node,"dijitHidden")&&_58a&&_58a.style&&(_58a.style.display!="none");}}},_onShow:function(){this._wasShown=true;if(this._needLayout){this._layout(this._changeSize,this._resultSize);}this.inherited(arguments);}});});},"dijit/layout/utils":function(){define(["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang"],function(_58b,_58c,_58d,_58e,lang){function _58f(word){return word.substring(0,1).toUpperCase()+word.substring(1);};function size(_590,dim){var _591=_590.resize?_590.resize(dim):_58d.setMarginBox(_590.domNode,dim);if(_591){lang.mixin(_590,_591);}else{lang.mixin(_590,_58d.getMarginBox(_590.domNode));lang.mixin(_590,dim);}};var _592={marginBox2contentBox:function(node,mb){var cs=_58e.getComputedStyle(node);var me=_58d.getMarginExtents(node,cs);var pb=_58d.getPadBorderExtents(node,cs);return {l:_58e.toPixelValue(node,cs.paddingLeft),t:_58e.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};},layoutChildren:function(_593,dim,_594,_595,_596){dim=lang.mixin({},dim);_58c.add(_593,"dijitLayoutContainer");_594=_58b.filter(_594,function(item){return item.region!="center"&&item.layoutAlign!="client";}).concat(_58b.filter(_594,function(item){return item.region=="center"||item.layoutAlign=="client";}));_58b.forEach(_594,function(_597){var elm=_597.domNode,pos=(_597.region||_597.layoutAlign);if(!pos){throw new Error("No region setting for "+_597.id);}var _598=elm.style;_598.left=dim.l+"px";_598.top=dim.t+"px";_598.position="absolute";_58c.add(elm,"dijitAlign"+_58f(pos));var _599={};if(_595&&_595==_597.id){_599[_597.region=="top"||_597.region=="bottom"?"h":"w"]=_596;}if(pos=="leading"){pos=_597.isLeftToRight()?"left":"right";}if(pos=="trailing"){pos=_597.isLeftToRight()?"right":"left";}if(pos=="top"||pos=="bottom"){_599.w=dim.w;size(_597,_599);dim.h-=_597.h;if(pos=="top"){dim.t+=_597.h;}else{_598.top=dim.t+dim.h+"px";}}else{if(pos=="left"||pos=="right"){_599.h=dim.h;size(_597,_599);dim.w-=_597.w;if(pos=="left"){dim.l+=_597.w;}else{_598.left=dim.l+dim.w+"px";}}else{if(pos=="client"||pos=="center"){size(_597,dim);}}}});}};lang.setObject("dijit.layout.utils",_592);return _592;});},"dojox/charting/widget/SelectableLegend":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/query","dojo/_base/connect","dojo/_base/Color","./Legend","dijit/form/CheckBox","../action2d/Highlight","dojox/lang/functional","dojox/gfx/fx","dojo/keys","dojo/dom-construct","dojo/dom-prop","dijit/registry"],function(_59a,_59b,_59c,hub,_59d,_59e,_59f,_5a0,df,fx,keys,dom,_5a1,_5a2){var _5a3=_59b(null,{constructor:function(_5a4){this.legend=_5a4;this.index=0;this.horizontalLength=this._getHrizontalLength();_59a.forEach(_5a4.legends,function(item,i){if(i>0){_59c("input",item).attr("tabindex",-1);}});this.firstLabel=_59c("input",_5a4.legends[0])[0];hub.connect(this.firstLabel,"focus",this,function(){this.legend.active=true;});hub.connect(this.legend.domNode,"keydown",this,"_onKeyEvent");},_getHrizontalLength:function(){var _5a5=this.legend.horizontal;if(typeof _5a5=="number"){return Math.min(_5a5,this.legend.legends.length);}else{if(!_5a5){return 1;}else{return this.legend.legends.length;}}},_onKeyEvent:function(e){if(!this.legend.active){return;}if(e.keyCode==keys.TAB){this.legend.active=false;return;}var max=this.legend.legends.length;switch(e.keyCode){case keys.LEFT_ARROW:this.index--;if(this.index<0){this.index+=max;}break;case keys.RIGHT_ARROW:this.index++;if(this.index>=max){this.index-=max;}break;case keys.UP_ARROW:if(this.index-this.horizontalLength>=0){this.index-=this.horizontalLength;}break;case keys.DOWN_ARROW:if(this.index+this.horizontalLength<max){this.index+=this.horizontalLength;}break;default:return;}this._moveToFocus();Event.stop(e);},_moveToFocus:function(){_59c("input",this.legend.legends[this.index])[0].focus();}});var _5a6=_59b(_5a0,{connect:function(){}});var _5a7=_59b("dojox.charting.widget.SelectableLegend",_59e,{outline:false,transitionFill:null,transitionStroke:null,autoScale:false,postCreate:function(){this.legends=[];this.legendAnim={};this._cbs=[];this.inherited(arguments);},refresh:function(){this.legends=[];this._clearLabels();this.inherited(arguments);this._applyEvents();new _5a3(this);},_clearLabels:function(){var cbs=this._cbs;while(cbs.length){cbs.pop().destroyRecursive();}},_addLabel:function(dyn,_5a8){this.inherited(arguments);var _5a9=_59c("td",this.legendBody);var _5aa=_5a9[_5a9.length-1];this.legends.push(_5aa);var _5ab=new _59f({checked:true});this._cbs.push(_5ab);dom.place(_5ab.domNode,_5aa,"first");var _5ac=_59c("label",_5aa)[0];_5a1.set(_5ac,"for",_5ab.id);},_applyEvents:function(){if(this.chart.dirty){return;}_59a.forEach(this.legends,function(_5ad,i){var _5ae,_5af,_5b0;if(this._isPie()){_5ae=this.chart.stack[0];_5af=_5ae.name;_5b0=this.chart.series[0].name;}else{_5ae=this.chart.series[i];_5af=_5ae.plot;_5b0=_5ae.name;}var _5b1=_5a2.byNode(_59c(".dijitCheckBox",_5ad)[0]);_5b1.set("checked",!this._isHidden(_5af,i));hub.connect(_5b1,"onClick",this,function(e){this.toogle(_5af,i,!_5b1.get("checked"));e.stopPropagation();});var _5b2=_59c(".dojoxLegendIcon",_5ad)[0],_5b3=this._getFilledShape(this._surfaces[i].children);_59a.forEach(["onmouseenter","onmouseleave"],function(_5b4){hub.connect(_5b2,_5b4,this,function(e){this._highlight(e,_5b3,i,!_5b1.get("checked"),_5b0,_5af);});},this);},this);},_isHidden:function(_5b5,_5b6){if(this._isPie()){return _59a.indexOf(this.chart.getPlot(_5b5).runFilter,_5b6)!=-1;}else{return this.chart.series[_5b6].hidden;}},toogle:function(_5b7,_5b8,hide){var plot=this.chart.getPlot(_5b7);if(this._isPie()){if(_59a.indexOf(plot.runFilter,_5b8)!=-1){if(!hide){plot.runFilter=_59a.filter(plot.runFilter,function(item){return item!=_5b8;});}}else{if(hide){plot.runFilter.push(_5b8);}}}else{this.chart.series[_5b8].hidden=hide;}this.autoScale?this.chart.dirty=true:plot.dirty=true;this.chart.render();},_highlight:function(e,_5b9,_5ba,_5bb,_5bc,_5bd){if(!_5bb){var anim=this._getAnim(_5bd),_5be=this._isPie(),type=_5bf(e.type);var _5c0={shape:_5b9,index:_5be?"legend"+_5ba:"legend",run:{name:_5bc},type:type};anim.process(_5c0);_59a.forEach(this._getShapes(_5ba,_5bd),function(_5c1,i){var o={shape:_5c1,index:_5be?_5ba:i,run:{name:_5bc},type:type};anim.duration=100;anim.process(o);});}},_getShapes:function(i,_5c2){var _5c3=[];if(this._isPie()){var _5c4=0;_59a.forEach(this.chart.getPlot(_5c2).runFilter,function(item){if(i>item){_5c4++;}});_5c3.push(this.chart.stack[0].group.children[i-_5c4]);}else{if(this._isCandleStick(_5c2)){_59a.forEach(this.chart.series[i].group.children,function(_5c5){_59a.forEach(_5c5.children,function(_5c6){_59a.forEach(_5c6.children,function(_5c7){if(_5c7.shape.type!="line"){_5c3.push(_5c7);}});});});}else{_5c3=this.chart.series[i].group.children;}}return _5c3;},_getAnim:function(_5c8){if(!this.legendAnim[_5c8]){this.legendAnim[_5c8]=new _5a6(this.chart,_5c8);}return this.legendAnim[_5c8];},_getTransitionFill:function(_5c9){if(this.chart.stack[this.chart.plots[_5c9]].declaredClass.indexOf("dojox.charting.plot2d.Stacked")!=-1){return this.chart.theme.plotarea.fill;}return null;},_getFilledShape:function(_5ca){var i=0;while(_5ca[i]){if(_5ca[i].getFill()){return _5ca[i];}i++;}return null;},_isPie:function(){return this.chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie";},_isCandleStick:function(_5cb){return this.chart.stack[this.chart.plots[_5cb]].declaredClass=="dojox.charting.plot2d.Candlesticks";},destroy:function(){this._clearLabels();this.inherited(arguments);}});function _5bf(type){if(type=="mouseenter"){return "onmouseover";}if(type=="mouseleave"){return "onmouseout";}return "on"+type;};return _5a7;});},"dojox/charting/widget/Legend":function(){define(["dojo/_base/declare","dijit/_WidgetBase","dojox/gfx","dojo/_base/array","dojo/has","dojo/has!dojo-bidi?../bidi/widget/Legend","dojox/lang/functional","dojo/dom","dojo/dom-construct","dojo/dom-class","dijit/registry"],function(_5cc,_5cd,gfx,arr,has,_5ce,df,dom,_5cf,_5d0,_5d1){var _5d2=_5cc(has("dojo-bidi")?"dojox.charting.widget.NonBidiLegend":"dojox.charting.widget.Legend",_5cd,{chartRef:"",horizontal:true,swatchSize:18,legendBody:null,postCreate:function(){if(!this.chart&&this.chartRef){this.chart=_5d1.byId(this.chartRef)||_5d1.byNode(dom.byId(this.chartRef));if(!this.chart){}}this.chart=this.chart.chart||this.chart;this.refresh();},buildRendering:function(){this.domNode=_5cf.create("table",{role:"group","aria-label":"chart legend","class":"dojoxLegendNode"});this.legendBody=_5cf.create("tbody",null,this.domNode);this.inherited(arguments);},destroy:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_5d3){_5d3.destroy();});}this.inherited(arguments);},refresh:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_5d4){_5d4.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){_5cf.destroy(this.legendBody.lastChild);}if(this.horizontal){_5d0.add(this.domNode,"dojoxLegendHorizontal");this._tr=_5cf.create("tr",null,this.legendBody);this._inrow=0;}var s=this.series||this.chart.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _5d5=df.map(t.run.data,"Math.max(x, 0)");var _5d6=df.map(_5d5,"/this",df.foldl(_5d5,"+",0));arr.forEach(_5d6,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{arr.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{arr.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_5d7){var _5d8=_5cf.create("td"),icon=_5cf.create("div",null,_5d8),text=_5cf.create("label",null,_5d8),div=_5cf.create("div",{style:{"width":this.swatchSize+"px","height":this.swatchSize+"px","float":"left"}},icon);_5d0.add(icon,"dojoxLegendIcon dijitInline");_5d0.add(text,"dojoxLegendText");if(this._tr){this._tr.appendChild(_5d8);if(++this._inrow===this.horizontal){this._tr=_5cf.create("tr",null,this.legendBody);this._inrow=0;}}else{var tr=_5cf.create("tr",null,this.legendBody);tr.appendChild(_5d8);}this._makeIcon(div,dyn);text.innerHTML=String(_5d7);if(has("dojo-bidi")){text.dir=this.getTextDir(_5d7,text.dir);}},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _5d9=gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_5d9);if(dyn.fill){_5d9.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_5d9.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};_5d9.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.markerFill).setStroke(dyn.markerStroke);}}else{_5d9.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_5d9.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_5d9.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}}});return has("dojo-bidi")?_5cc("dojox.charting.widget.Legend",[_5d2,_5ce]):_5d2;});},"dojox/charting/action2d/Highlight":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","dojo/_base/connect","dojox/color/_base","./PlotAction","dojo/fx/easing","dojox/gfx/fx"],function(lang,_5da,_5db,hub,c,_5dc,dfe,dgf){var _5dd=100,_5de=75,_5df=50,cc=function(_5e0){return function(){return _5e0;};},hl=function(_5e1){var a=new c.Color(_5e1),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_5dd;if(x.l<_5df){x.l=_5de;}else{if(x.l>_5de){x.l=_5df;}else{x.l=x.l-_5df>_5de-x.l?_5df:_5de;}}}var _5e2=c.fromHsl(x);_5e2.a=a.a;return _5e2;},_5e3=function(_5e4){var r=hl(_5e4);r.a=0.7;return r;};return _5da("dojox.charting.action2d.Highlight",_5dc,{defaultParams:{duration:400,easing:dfe.backOut},optionalParams:{highlight:"red"},constructor:function(_5e5,plot,_5e6){var a=_5e6&&_5e6.highlight;this.colorFunc=a?(lang.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}if(o.element=="spider_circle"||o.element=="spider_plot"){return;}else{if(o.element=="spider_poly"&&this.colorFunc==hl){this.colorFunc=_5e3;}}var _5e7=o.run.name,_5e8=o.index,anim;if(_5e7 in this.anim){anim=this.anim[_5e7][_5e8];}else{this.anim[_5e7]={};}if(anim){anim.action.stop(true);}else{var _5e9=o.shape.getFill();if(!_5e9||!(_5e9 instanceof _5db)){return;}this.anim[_5e7][_5e8]=anim={start:_5e9,end:this.colorFunc(_5e9)};}var _5ea=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_5ea;_5ea=end;end=t;}anim.action=dgf.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_5ea,end:end}});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_5e7]){delete this.anim[_5e7][_5e8];}});}anim.action.play();}});});},"dojox/charting/action2d/PlotAction":function(){define(["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional"],function(hub,_5eb,Base,dfe,df){var _5ec=400,_5ed=dfe.backOut;return _5eb("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_5ee,plot,_5ef){this.anim={};if(!_5ef){_5ef={};}this.duration=_5ef.duration?_5ef.duration:_5ec;this.easing=_5ef.easing?_5ef.easing:_5ed;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dojox/charting/action2d/Base":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/Evented"],function(lang,_5f0,_5f1){return _5f0("dojox.charting.action2d.Base",_5f1,{constructor:function(_5f2,plot){this.chart=_5f2;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\" data-dojo-attach-event=\"mouseenter:onMouseEnter,mouseleave:onMouseLeave\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n","url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\ttabIndex=\"-1\" aria-hidden=\"true\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"ondijitclick:_onClick\"\n/></div>\n"}});var switchData,switchSpider,switchDivisions,switchAnimation;require(["dojo/_base/lang","dojo/ready","dojo/dom","dojo/dom-construct","dojox/charting/Chart","dojox/charting/plot2d/Spider","dojox/charting/themes/PlotKit/blue","dijit/Tooltip","dijit/form/CheckBox","dijit/form/RadioButton","dijit/form/Form","dojo/fx/easing","dojox/gfx/fx","dojox/charting/widget/SelectableLegend"],function(lang,_5f3,dom,_5f4,_5f5,_5f6,blue,_5f7,_5f8,_5f9,Form,_5fa,fx,_5fb){var _5fc=7,_5fd="polygon";var _5fe={};var _5ff=function(from,_600){var _601=lang.getObject(from);for(var name in _601){if(name in _5fe){continue;}var fun=_601[name];if(lang.isFunction(fun)){_5f4.create("option",{value:from+"."+name,selected:name=="backOut",innerHTML:from+"."+name},_600);}}};var _602,_603;makeObjects=function(){_602=new dojox.charting.Chart("spider");_602.setTheme(dojox.charting.themes.PlotKit.blue);_602.theme.plotarea.fill=null;_602.theme.chart.fill=null;_602.addPlot("default",{type:"Spider",labelOffset:-10,divisions:_5fc,axisColor:"lightgray",fill:null,spiderColor:"silver",seriesFillAlpha:0.2,spiderOrigin:0.16,markerSize:3,precision:0,spiderType:_5fd});_602.addSeries("China",{data:{"GDP":2,"area":6,"population":2000,"inflation":15,"growth":12}},{fill:"blue"});_602.addSeries("France",{data:{"GDP":6,"area":15,"population":500,"inflation":5,"growth":6}},{fill:"red"});_602.addSeries("USA",{data:{"GDP":3,"area":20,"population":1500,"inflation":10,"growth":3}},{fill:"green"});_602.addSeries("Japan",{data:{"GDP":4,"area":2,"population":1000,"inflation":20,"growth":2}},{fill:"yellow"});_602.addSeries("Korean",{data:{"GDP":10,"area":10,"population":800,"inflation":2,"growth":18}},{fill:"orange"});_602.addSeries("Canada",{data:{"GDP":1,"area":18,"population":300,"inflation":3,"growth":15}},{fill:"purple"});_602.render();_603=new _5fb({chart:_602,horizontal:true},"legend1");_5ff("dojo.fx.easing","easing");};_5f3(makeObjects);switchData=function(val){if(val=="b1"){_602.updateSeries("China",{data:{"GDP":2,"area":6,"population":2000,"inflation":15,"growth":12}},{fill:"blue"});_602.updateSeries("France",{data:{"GDP":6,"area":15,"population":500,"inflation":5,"growth":6}},{fill:"red"});_602.updateSeries("USA",{data:{"GDP":3,"area":20,"population":1500,"inflation":10,"growth":3}},{fill:"green"});_602.updateSeries("Japan",{data:{"GDP":4,"area":2,"population":1000,"inflation":20,"growth":2}},{fill:"yellow"});_602.updateSeries("Korean",{data:{"GDP":10,"area":10,"population":800,"inflation":2,"growth":18}},{fill:"orange"});_602.updateSeries("Canada",{data:{"GDP":1,"area":18,"population":300,"inflation":3,"growth":15}},{fill:"purple"});}else{_602.updateSeries("China",{data:{"GDP":8,"area":2,"population":500,"inflation":2,"growth":18}},{fill:"blue"});_602.updateSeries("France",{data:{"GDP":10,"area":6,"population":1000,"inflation":20,"growth":12}},{fill:"red"});_602.updateSeries("USA",{data:{"GDP":2,"area":5,"population":1500,"inflation":12,"growth":6}},{fill:"green"});_602.updateSeries("Japan",{data:{"GDP":1,"area":20,"population":500,"inflation":5,"growth":11}},{fill:"yellow"});_602.updateSeries("Korean",{data:{"GDP":4,"area":2,"population":2000,"inflation":16,"growth":8}},{fill:"orange"});_602.updateSeries("Canada",{data:{"GDP":6,"area":10,"population":300,"inflation":3,"growth":2}},{fill:"purple"});}_602.render();_603&&_603.refresh&&_603.refresh();};switchSpider=function(val){_5fd=dom.byId("b11").checked?"polygon":"circle";if(val=="b11"){_602.addPlot("default",{type:"Spider",divisions:_5fc,spiderType:_5fd});}else{_602.addPlot("default",{type:"Spider",divisions:_5fc,spiderType:_5fd});}_602.render();_603&&_603.refresh&&_603.refresh();};switchDivisions=function(val){if(val=="b111"){_5fc=7;_602.addPlot("default",{type:"Spider",divisions:_5fc,spiderType:_5fd});}else{_5fc=3;_602.addPlot("default",{type:"Spider",divisions:_5fc,spiderType:_5fd});}_602.render();_603&&_603.refresh&&_603.refresh();};switchAnimation=function(val){_5fa=lang.getObject(dom.byId("easing").value);_602.addPlot("default",{type:"Spider",divisions:_5fc,spiderType:_5fd,animationType:_5fa});_602.render();_603&&_603.refresh&&_603.refresh();};});